package com.mobit.takeout;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.mobit.managers.DataSimulation;
import com.mobit.managers.JSONParser;
import com.mobit.managers.StaticCall;
import com.mobit.models.Menu;
import com.mobit.models.MenuAdapter;
import com.mobit.models.RestInfo;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;

@SuppressLint("NewApi")
public class MenuFragment extends Fragment {

	private Handler handler;
	private LinearLayout ll_rest_info;
	private View view;
	private ListView lv_menu;
	private ImageView img_rest_logo;
	private TextView tv_address, tv_contact, tv_time;
	private ProgressBar pb_load_menu;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup group,
			Bundle savedInstanceState) {
		view = inflater.inflate(R.layout.menu_fragment, group, false);
		init();

		return view;

	}

	public void init() {
		handler = new Handler();
		ll_rest_info = (LinearLayout) view.findViewById(R.id.ll_rest_info);
		lv_menu = (ListView) view.findViewById(R.id.lv_menu_list);
		img_rest_logo = (ImageView) view.findViewById(R.id.img_rest_menu_logo);
		tv_address = (TextView) view.findViewById(R.id.txtv_address);
		tv_contact = (TextView) view.findViewById(R.id.txtv_contact);
		tv_time = (TextView) view.findViewById(R.id.txtv_time);
		pb_load_menu = (ProgressBar) view.findViewById(R.id.pb_load_menu);

		Bundle b = this.getArguments();
		String cat_id = b.getString("cat_id");
		String rest_id = b.getString("rest_id");

		String[] params = { cat_id, rest_id };

		fetchMenu(params);

	}

	public void fetchMenu(final String[] params_arr) {
		boolean has_net = StaticCall.checkNet(this.getActivity());

		if (has_net) {
			new Thread(new Runnable() {
				@Override
				public void run() {

					Looper.prepare();
					try {
						final ArrayList<Menu> menu_list = new ArrayList<Menu>();
						final RestInfo info = new RestInfo();
						List<NameValuePair> params = new ArrayList<NameValuePair>();
						JSONParser parser = new JSONParser();
						boolean hasList = false;
						boolean hasInfo = false;

						BasicNameValuePair cat_id = new BasicNameValuePair(
								"cat_id", params_arr[0]);

						BasicNameValuePair rest_id = new BasicNameValuePair(
								"rest_id", params_arr[1]);

						params.add(cat_id);
						params.add(rest_id);

						/*
						 * JSONObject jo_rests = parser.makeHttpRequest(
						 * StaticCall.base_url, "POST", params);
						 */

						JSONObject jo_menus = DataSimulation.getMenu();

						if (jo_menus != null) {
							hasList = true;

							/* Restaurant Info */
							JSONObject jo_info = jo_menus
									.getJSONObject("rest_info");

							if (jo_info != null) {
								hasInfo = true;

								info.setAddress(jo_info.getString("address"));
								info.setDel_time(jo_info.getString("del_time"));
								info.setLogo(jo_info.getString("logo"));
								info.setPhone(jo_info.getString("phone"));
								info.setRest_id(jo_info.getString("id"));
								info.setRest_name(jo_info.getString("name"));
							} else {
								hasInfo = false;
							}

							JSONArray ja_menu_list = jo_menus
									.getJSONArray("menu");

							if (ja_menu_list != null) {
								hasList = true;

								for (int i = 0; i < ja_menu_list.length(); i++) {
									JSONObject jo_menu = ja_menu_list
											.getJSONObject(i);

									if (jo_menu != null) {
										hasList = true;
										Menu menu = new Menu();

										menu.setFood_title(jo_menu
												.getString("title"));
										menu.setIngredients(jo_menu
												.getString("ingred"));
										menu.setLogo(jo_menu.getString("logo"));
										menu.setPrice(jo_menu
												.getString("price"));

										menu_list.add(menu);

									} else {
										hasList = false;
									}
								}
							} else {
								hasList = false;
							}

						} else {
							hasList = false;
						}

						if (hasList && hasInfo) {
							/* populate the list of categories */

							handler.post(new Runnable() {
								@Override
								public void run() {
									// display info
									showInfo(info);

									// display menu
									showMenu(menu_list);
								}
							});

						} else {
							/* show error */
						}
					} catch (JSONException je) {
						Log.e("Restaurants Fetch Error", je.toString());
					}
				}
			}, "fetchRestaurants").start();
		} else {
			StaticCall.getDialog(0, this.getActivity()).show();
		}
	}

	public void showInfo(RestInfo info) {
		this.pb_load_menu.setVisibility(View.GONE);
		this.ll_rest_info.setVisibility(View.VISIBLE);

		this.tv_address.setText(info.getAddress());
		this.tv_contact.setText(info.getPhone());
		this.tv_time.setText(info.getDel_time());

		DisplayImageOptions options = new DisplayImageOptions.Builder()
				.showImageForEmptyUri(R.drawable.java_old_school)
				.showImageOnFail(R.drawable.java_old_school).build();

		ImageLoader.getInstance().displayImage(info.getLogo(), img_rest_logo,
				options);

		this.getActivity().getActionBar().setTitle(info.getRest_name());
	}

	public void showMenu(ArrayList<Menu> menu_list) {
		lv_menu.setVisibility(View.VISIBLE);
		final MenuAdapter adapter = new MenuAdapter(
				this.getActivity(), menu_list);

		
		pb_load_menu.setVisibility(View.GONE);
		lv_menu.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
		lv_menu.setAdapter(adapter);
		lv_menu.setTextFilterEnabled(true);
		adapter.registerDataSetObserver(new DataSetObserver() {
			@Override
			public void onChanged() {
				super.onChanged();
				lv_menu.setSelection(adapter.getCount() - 1);
			}
		});

	}

	public void onViewClicked(View view) {
		switch (view.getId()) {
		case R.id.btn_call:
			call(tv_contact.getText().toString());
			break;
		}
	}

	public void call(String number) {
		try {
			Intent claim_status = new Intent(Intent.ACTION_VIEW);
			claim_status.setData(Uri.parse("tel:" + number));
			claim_status.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(claim_status);
		} catch (ActivityNotFoundException anfe) {
			anfe.printStackTrace();
		}
	}

}
