package com.mobit.takeout;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.database.DataSetObserver;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.Toast;

import com.mobit.managers.DataSimulation;
import com.mobit.managers.JSONParser;
import com.mobit.managers.StaticCall;
import com.mobit.models.Restaurant;
import com.mobit.models.RestaurantAdapter;

@SuppressLint("NewApi")
public class RestaurantFragment extends Fragment {

	// Handler to post on UI
	Handler handler;
	// the list of restaurants
	private ListView rest_list;

	// restaurant search box
	EditText etxt_srch_rest;

	// ImageButton for searching
	ImageButton btn_srch_rest;

	// the fragment view
	View view;

	// progressBar
	ProgressBar pb_srch_rest;

	// the category id to be used for searches and menus
	String cat_id;

	// the category name
	String cat_name;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		// Creating view corresponding to the fragment
		view = inflater.inflate(R.layout.rest_fragment, container, false);
		init();

		return view;
	}

	public void init() {

		handler = new Handler();
		Bundle b = this.getArguments();

		cat_id = b.getString("cat_id", "");
		cat_name = b.getString("cat_name", "");

		this.getActivity().getActionBar().setTitle(cat_name);

		rest_list = (ListView) view.findViewById(R.id.lv_rest_list);
		etxt_srch_rest = (EditText) view.findViewById(R.id.etxt_search_rest);
		pb_srch_rest = (ProgressBar) view.findViewById(R.id.pb_rest);
		btn_srch_rest = (ImageButton) view.findViewById(R.id.btn_srch_rest);

		etxt_srch_rest.addTextChangedListener(new TextWatcher() {

			@Override
			public void beforeTextChanged(CharSequence s, int start, int count,
					int after) {
				// TODO Auto-generated method stub

			}

			@Override
			public void onTextChanged(CharSequence s, int start, int before,
					int count) {
				// TODO Auto-generated method stub

			}

			@Override
			public void afterTextChanged(Editable s) {
				if (etxt_srch_rest.getText().toString().length() == 0) {
					btn_srch_rest.setVisibility(View.GONE);
					StaticCall.showSearchIcon(etxt_srch_rest, false);
				} else {
					btn_srch_rest.setVisibility(View.VISIBLE);
					StaticCall.showSearchIcon(etxt_srch_rest, true);
				}

			}
		});

		rest_list.setOnItemClickListener(new OnItemClickListener() {

			@SuppressWarnings("unchecked")
			@Override
			public void onItemClick(AdapterView<?> parent, View view,
					int position, long id) {
				Restaurant restaurant = (Restaurant) rest_list
						.getItemAtPosition(position);

				startMenuFragment(cat_id, restaurant.getId());

			}
		});

		String[] params = { cat_id, "ALL" };
		fetchRestaurants(params);

	}

	public void fetchRestaurants(final String[] params_arr) {
		boolean has_net = StaticCall.checkNet(this.getActivity());

		if (has_net) {
			new Thread(new Runnable() {
				@Override
				public void run() {

					Looper.prepare();
					try {
						final ArrayList<Restaurant> rests_list = new ArrayList<Restaurant>();
						List<NameValuePair> params = new ArrayList<NameValuePair>();
						JSONParser parser = new JSONParser();
						boolean hasList = false;

						BasicNameValuePair cat_id = new BasicNameValuePair(
								"cat_id", params_arr[0]);

						BasicNameValuePair rest_name = new BasicNameValuePair(
								"rest_name", params_arr[1]);

						params.add(cat_id);
						params.add(rest_name);

						/*
						 * JSONObject jo_rests = parser.makeHttpRequest(
						 * StaticCall.base_url, "POST", params);
						 */

						JSONObject jo_rests = DataSimulation.getRestaurants();

						if (jo_rests != null) {
							hasList = true;

							JSONArray ja_rests = jo_rests
									.getJSONArray("restaurants");

							if (ja_rests != null) {
								hasList = true;

								for (int i = 0; i < ja_rests.length(); i++) {
									JSONObject jo_rest = ja_rests
											.getJSONObject(i);

									if (jo_rest != null) {
										hasList = true;
										Restaurant rest = new Restaurant();

										rest.setId(jo_rest.getString("rest_id"));
										rest.setName(jo_rest
												.getString("rest_name"));
										rest.setSlogan(jo_rest
												.getString("slogan"));
										rest.setLocation(jo_rest
												.getString("location"));
										rest.setLogo(jo_rest.getString("logo"));
										rest.setCoordinates(jo_rest
												.getString("coordinates"));

										rests_list.add(rest);

									} else {
										hasList = false;
									}
								}
							} else {
								hasList = false;
							}

						} else {
							hasList = false;
						}

						if (hasList) {
							/* populate the list of categories */

							handler.post(new Runnable() {
								@Override
								public void run() {
									showRestaurants(rests_list);
								}
							});

						} else {
							/* show error */
						}
					} catch (JSONException je) {
						Log.e("Restaurants Fetch Error", je.toString());
					}
				}
			}, "fetchRestaurants").start();
		} else {
			StaticCall.getDialog(0, this.getActivity()).show();
		}

	}

	public void showRestaurants(ArrayList<Restaurant> rest_list_arr) {
		final RestaurantAdapter adapter = new RestaurantAdapter(
				this.getActivity(), rest_list_arr);

		rest_list.setVisibility(View.VISIBLE);
		pb_srch_rest.setVisibility(View.GONE);
		rest_list.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
		rest_list.setAdapter(adapter);
		rest_list.setTextFilterEnabled(true);
		adapter.registerDataSetObserver(new DataSetObserver() {
			@Override
			public void onChanged() {
				super.onChanged();
				rest_list.setSelection(adapter.getCount() - 1);
			}
		});

	}

	public void onViewClicked(View view) {
		switch (view.getId()) {
		case R.id.btn_srch_rest:
			Toast.makeText(this.getActivity(), R.string.searching,
					Toast.LENGTH_LONG).show();

			String[] params = { cat_id,
					etxt_srch_rest.getText().toString().trim() };

			rest_list.setVisibility(View.GONE);
			pb_srch_rest.setVisibility(View.VISIBLE);
			fetchRestaurants(params);
			break;
		}

	}

	public void startMenuFragment(String cat_id, String rest_id) {
		Bundle b = new Bundle();

		b.putString("cat_id", cat_id);
		b.putString("rest_id", rest_id);

		MenuFragment menu_frag = new MenuFragment();

		menu_frag.setArguments(b);

		TakeoutMain activity = (TakeoutMain) this.getActivity();

		activity.setMenuFragment(menu_frag);

		FragmentManager fm = getActivity().getFragmentManager();
		FragmentTransaction ft = fm.beginTransaction();
		ft.replace(R.id.content_frame, menu_frag);
		ft.commit();
	}

}