package com.tbitsglobal.client;

import java.util.LinkedList;
import java.util.Queue;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;

public class ConversationPage extends Composite{
	
	private static final int DELAY = 10;
	private TalkServiceAsync talkServiceAsync;
	private Queue<String> buffer;
	TextArea friendsChat;

	public ConversationPage()
	{
		talkServiceAsync = (TalkServiceAsync) GWT.create(TalkService.class);
		ServiceDefTarget endpoint = (ServiceDefTarget) talkServiceAsync;
		String moduleRelativeURL = GWT.getModuleBaseURL() + "getTalk";
		endpoint.setServiceEntryPoint(moduleRelativeURL);

		buffer = new LinkedList<String>();

		DockPanel dp = new DockPanel();

		HorizontalPanel myPanel = new HorizontalPanel();
		myPanel.setSize("100%", "100%");
		TextArea tb = new TextArea();
		tb.setSize("100%", "100%");
		tb.addKeyboardListener(new KeyboardListener() {

			public void onKeyDown(Widget sender, char keyCode, int modifiers) {
				
			}

			public void onKeyPress(Widget sender, char keyCode, int modifiers) {
			
			}

			public void onKeyUp(Widget sender, char keyCode, int modifiers) {
				// TODO Auto-generated method stub
				String str = ((TextArea) sender).getText(); 
				buffer.add(str);
			}

		});
		myPanel.add(tb);
		myPanel.setSpacing(5);
		
		HorizontalPanel frndPanel = new HorizontalPanel();
		frndPanel.setSize("100%", "100%");
		frndPanel.setSpacing(5);
		
		friendsChat = new TextArea();
		friendsChat.setReadOnly(true);
		friendsChat.setSize("100%", "100%");
		
		frndPanel.add(friendsChat);
		
		dp.setSpacing(5);

		dp.setSize("100%", "100%");
		dp.add(myPanel, DockPanel.NORTH);
		dp.add(frndPanel, DockPanel.SOUTH);

		initWidget(dp);
		
		startGetter();
		startSender();
	}

	private void scheduleStartSender()
	{
		Timer timer = new Timer()
		{

			@Override
			public void run() {
				startSender();
			}
			
		};
		timer.schedule(DELAY);
	}
	private void scheduleStartGetter()
	{
		Timer timer = new Timer()
		{

			@Override
			public void run() {
				startGetter();
			}
			
		};
		timer.schedule(DELAY);
	}
	private void startSender() {
		
		String msg = null;
		if(buffer.isEmpty())
		{
			scheduleStartSender();
			return;
		}
		else
			msg = buffer.remove();
		talkServiceAsync.add(msg,
				new AsyncCallback<Boolean>() {

					public void onFailure(Throwable caught) {
						caught.printStackTrace();
						scheduleStartSender();
					}

					public void onSuccess(Boolean result) {
						// startSender();
						scheduleStartSender();
					}

				});
	}

	private void startGetter() {
		talkServiceAsync.remove(new AsyncCallback<String>() {

			public void onFailure(Throwable caught) {
				// startGetter();
				caught.printStackTrace();
				scheduleStartGetter();
			}

			public void onSuccess(String results) {
				if(results != null)
				{
					friendsChat.setText(results);
				}
				scheduleStartGetter();
			}
		});
	}
}
