package ClientSide;

import java.awt.Point;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

import javax.swing.JOptionPane;

import BothSide.Constants.EntityType;
import BothSide.EntityInfo;
import ServerSide.ServicesInterface;


public class Client extends UnicastRemoteObject implements RemoteListener{
	 MainForm mainForm;
	 Player player;
	 ServicesInterface myServerObject;
	 EntityInfo info;
	 private Vector<RemotePlayer> remotePlayerList;	 
	 static protected Client instance;
	 
	 
	
	public Client() throws RemoteException{
		super();
		this.remotePlayerList = new Vector<RemotePlayer>();
		instance=this;
		info = new EntityInfo();
	}
	
	public static void main(String[]args)
	{
		
		Client c;
		try {
			c = new Client();
			c.run();
		} catch (RemoteException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	

	
	public  void run() {
	    final String serverName=JOptionPane.showInputDialog("ip server");
    	System.setProperty("java.security.policy","http://dl.dropbox.com/u/13520648/wideopen.policy");
    	if (System.getSecurityManager() == null)
    	  {System.setSecurityManager(new RMISecurityManager());}
		
		final String nome=JOptionPane.showInputDialog("scegli nome");
		
		try {
			// bind server object to object in client
			System.out.println("connessione in corso...");
			myServerObject = (ServicesInterface) Naming.lookup("//" + serverName + "/RMIimpl");
		//	UnicastRemoteObject.exportObject(this);
			System.out.println("connesso");
			new Thread(new Runnable() {
				public void run() {					
					player = new Player(nome, EntityType.PLAYER);
					mainForm = new MainForm(player);
					mainForm.setVisible(true);
					aggiornaInfo();
					try {
						myServerObject.bornPlayer(info);
					} catch (RemoteException e) {
						e.printStackTrace();
					}
				}
			}).start();
			while( mainForm==null)
			  {
				Thread.sleep(2000);// gli do il tempo di creare il pupazzo
			  }
			myServerObject.addListener(this);
			new Perform_updateRemotePlayers().start();
			new Perform_drawRemotePlayers().start();
			/*
			while (true) {
				info.nome = mainForm.getMainPlayer().nome_player;
			    info.stato =  mainForm.getMainPlayer().stato;
				info.orientation =  mainForm.getMainPlayer().orientation;
				info.location = (mainForm.getMainPlayer().getLocation());
				myServerObject.setPlayerInfo(info);				
				Thread.sleep(15);
			}
			*/
		} 
		catch (Exception e) {
			System.out.println("CLIENT Exception occured: " + e);
			e.printStackTrace();
			System.exit(0);
		}
		System.out.println("RMI connection successful");
	}

	
	
	public  void disconnetti(){
		try {
			myServerObject.killPlayer(info.nome);
			System.out.println(info.nome+" disconnesso");
		} catch (RemoteException e) {
			e.printStackTrace();
		}		
	}
	
	public void assegnaColpo(String nemico, Point p)
	{
		try {
			myServerObject.assegnaColpo(nemico, p);
			
		} catch (RemoteException e) {e.printStackTrace();}
	}
	
	public void colpoRicevuto(String nemico)
	{
		try {
			myServerObject.colpoRicevuto(nemico);
		} catch (RemoteException e) {e.printStackTrace();}
	}
	
	public  void aggiornaInfo(){
		info.nome = mainForm.getMainPlayer().nome_player;
		info.stato = mainForm.getMainPlayer().stato;
		info.orientation = mainForm.getMainPlayer().orientation;
	    info.location = mainForm.getMainPlayer().getLocation();
	    info.entityType = EntityType.PLAYER;
	}
	
	public String leggiOstacoli(){
		try {
			return(myServerObject.leggiOstacoli());
		} catch (RemoteException e) {
			e.printStackTrace();
			return null;
		}
	        
	}
	
	
	private class Perform_updateRemotePlayers extends Thread{
		
		public void run(){
			updateRemotePlayers();
		}
		
		public void updateRemotePlayers(){
			  try{
				  Vector<EntityInfo> infos;
				  infos = myServerObject.getRemotePlayersInfo();
				 RemotePlayer temp;	
				 int size =  remotePlayerList.size();				 
				 int toAdd = infos.size()-(size+1);
				 int j=0;
				 while( j < toAdd)
					 	{
						 temp = new RemotePlayer("new", EntityType.PLAYER);
						 addPlayer(temp);	
						 j++;
					 	}
				j=0;
				int toRemove =((size+1))-infos.size();
				while (j<toRemove)
					 	{
						 removePlayer((size+1)-j);
						 j++;
					 	}	
				 j=0;
				 int i=0;
				 while( i<infos.size())
				  {
					if( ! infos.get(i).nome.equals(player.nome_player))
					  {
					   synchronized (remotePlayerList){ temp = remotePlayerList.get(j);}
					   temp.entityType = infos.get(i).entityType; //deve essere la prima cosa che aggiorno, se non mi sbaglia il controllo se  player o nemico per il nick
					   temp.setNome(infos.get(i).nome) ;			   
					   temp.stato = infos.get(i).stato; 
					   temp.orientation = infos.get(i).orientation;
					   temp.setLocation(infos.get(i).location);
					   
					   j++;
					  }
					else if ( infos.get(i).puntoAttacco!=null) //controllo se sono stato colpito
						{
						 player.riceviColpo(infos.get(i).puntoAttacco);
						}
					i++;
				 }	
				 Thread.sleep(20);
				 updateRemotePlayers();
				}catch(Exception ex){System.out.println("synch problems");ex.printStackTrace();}
			}
		
		private void addPlayer(RemotePlayer rp){
			rp.setLocation(400, 200);
			synchronized (remotePlayerList) {remotePlayerList.add(rp);}			
		    player.getParent().add(rp);	
		    player.getParent().add(rp.nick);
		}

		private void removePlayer(int i){
			synchronized (remotePlayerList) {
			player.getParent().remove(remotePlayerList.remove(i));
			}
		}
		
	}
		

		private class Perform_drawRemotePlayers extends Thread{
			public void run(){
			 while(true)
			  {
			   int size;
			   synchronized (remotePlayerList){size=remotePlayerList.size();}
			   for (int i=0; i<size;i++)
			    {		
				   synchronized (remotePlayerList){try{remotePlayerList.get(i).updateIcon();}catch(Exception ex){}}
				}
			   try{Thread.sleep(110);}catch(Exception ex){}			
			   }
			}
		}


		@Override
		public EntityInfo getRemotePlayerInfo() throws RemoteException {
			EntityInfo info = new EntityInfo();
			info.nome = instance.player.nome_player;
			info.location = instance.player.getLocation();
			info.orientation = instance.player.orientation;
			info.stato = instance.player.stato;
			info.entityType = EntityType.PLAYER;
			return info;
		}
		
		
	
	
}