
package ClientSide;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import Animals.Cow_brown;
import BothSide.Constants.EntityType;
import Enemies.Skeleton;



/**
 *
 * @author iamdelac
 */
public class GraphicalEntity extends javax.swing.JLabel{

	
    private Vector<ImageIcon>[] sprites;
    // ===  Entity info  ===
    private String nome_player;
    protected String stato;
    protected String orientation;
    protected EntityType entityType;
    protected String nomeSprite;
    // ==========
    protected GraphicalEntity nemicoFocused;
    protected int  offset_x;
    protected int  offset_y;
    protected  javax.swing.JLabel nick;
    String statoOld;
    int currentFrame;
    boolean oneCycle;


    public void talk(final String message) {

    	final GraphicalEntity rp = this;
 
    	 new Thread( new Runnable()
    			{public void run() 
    				{
    				System.out.println(getNome()+": "+message);
    				 javax.swing.JLabel nuvoletta = new JLabel();
    				 nuvoletta.setText("<html>"+message+"</html>");
    				 nuvoletta.setDoubleBuffered(true);
    				 nuvoletta.setForeground(new Color(255,255,255,0));
    				 nuvoletta.setAutoscrolls(true);
    				 nuvoletta.setSize(100, 100);
    				 nuvoletta.setFont(new Font("SansSerif", 0, 14));
    				 nuvoletta.setLocation(new Point(rp.getLocation().x, rp.getLocation().y-100));
    				 nuvoletta.setVisible(true);
    			     rp.getParent().add(nuvoletta);
    				 nuvoletta.getParent().setComponentZOrder(nuvoletta, 0);
    			     int start = nuvoletta.getLocation().y;
    			     while ((start - nuvoletta.getLocation().y)<40)
    			      {
    			    	 nuvoletta.setLocation(new Point(nuvoletta.getLocation().x, nuvoletta.getLocation().y-1));
    			    	 try{ Thread.sleep(150); }catch(Exception ex){}
    			      }
    			     nuvoletta.setVisible(false);
    			     rp.getParent().remove(nuvoletta);
    			              
    				}
    			}
    	         ).start();
    }
    
    public void setHitted(final int h){
    	final GraphicalEntity rp = this;
    	if (h!=0)
    	{ 
    	 new Thread( new Runnable()
    			{public void run() 
    				{
    				 javax.swing.JLabel value = new JLabel();
    				 if (h>0){value.setText(h+"");value.setForeground(Color.RED);}
    				 if (h<0){value.setText("schivato"); value.setForeground(Color.YELLOW);}
    			     
    			     value.setSize(value.getText().length()*10, 10);
    			     value.setLocation(new Point(rp.getLocation().x, rp.getLocation().y-70));
    			     value.setVisible(true);
    			     rp.getParent().add(value);
    			     int start = value.getLocation().y;
    			     while ((start - value.getLocation().y)<10)
    			      {
    			    	 value.setLocation(new Point(value.getLocation().x, value.getLocation().y-1));
    			    	 try{ Thread.sleep(100); }catch(Exception ex){}
    			      }
    			     value.setVisible(false);
    			     rp.getParent().remove(value);
    			              
    				}
    			}
    	         ).start();
    	}
    }

    public void setNome(String nome){
    	nome_player=nome;
    	if (entityType.equals(EntityType.PLAYER))
    		{
    		 nick.setVisible(true);
    		 nick.setSize(nick.getText().length()*10, 10);
    		}
    	else{nick.setVisible(false);}
    	nick.setText(nome);
    }
 
    public GraphicalEntity (String nome_player, EntityType entityType, String nomeSprite ) {
       super();
       currentFrame=0;
       this.nome_player = nome_player;
       this.entityType = entityType;
       this.nomeSprite = nomeSprite;
       nick=new JLabel();
       nick.setText(nome_player);
       nick.setSize(nome_player.length()*10, 10);
       nick.setForeground(Color.GREEN);       
       sprites = new Vector[8];
       this.setDoubleBuffered(true);       
       this.orientation = "n/";
       stato = "player/looking/";
        statoOld = stato;
        oneCycle = false;
        cambiaAnimazione("player/looking/");
       final GraphicalEntity this_instance = this;
       addMouseListener(new java.awt.event.MouseAdapter() {
           public void mousePressed(java.awt.event.MouseEvent evt)
           {
        	 if (!stato.contains("die"))
               {
        		 System.out.println("richiesta attacco");
                 Client.instance.mainForm.getMainPlayer().attacca(this_instance);
               }
           }
         });
       addContainerListener(new java.awt.event.ContainerAdapter() { 
           public void componentRemoved(java.awt.event.ContainerEvent evt) {
               nick.getParent().remove(nick);
           }
       });
       }


 
 private void setOffset(String animazione){
	// SKELETON
		if (nomeSprite.equals("player"))
			{
			if (animazione.contains("walk"))
			 {
				offset_x = Skeleton.walk_offset.x; 
	            offset_y = Skeleton.walk_offset.y;
			 }
			else if (animazione.contains("hitted"))
			 {
			   offset_x = Skeleton.hitted_offset.x; 
	           offset_y = Skeleton.hitted_offset.y;
			 }
			else if (animazione.contains("die"))
			 {
				offset_x = Skeleton.die_offset.x; 
	           offset_y = Skeleton.die_offset.y;
			 }
			else if (animazione.contains("attack"))
			 {
				offset_x = Skeleton.attack_offset.x; 
	           offset_y = Skeleton.attack_offset.y;
			 }
			else if (animazione.contains("looking"))
			 {
				offset_x = Skeleton.looking_offset.x; 
	          offset_y = Skeleton.looking_offset.y;
			 }
			}
		// COW_BROWN
		else if (nomeSprite.equals("asino"))
			{
			if (animazione.contains("walk"))
			 {
				offset_x = Cow_brown.walk_offset.x; 
	           offset_y = Cow_brown.walk_offset.y;
			 }
			else if (animazione.contains("hitted"))
			 {
			   offset_x = Cow_brown.hitted_offset.x; 
	          offset_y = Cow_brown.hitted_offset.y;
			 }
			else if (animazione.contains("die"))
			 {
				offset_x = Cow_brown.die_offset.x; 
	          offset_y = Cow_brown.die_offset.y;
			 }
			else if (animazione.contains("attack"))
			 {
				offset_x = Cow_brown.attack_offset.x; 
	          offset_y = Cow_brown.attack_offset.y;
			 }
			else if (animazione.contains("looking"))
			 {
				offset_x = Cow_brown.looking_offset.x; 
	         offset_y = Cow_brown.looking_offset.y;
			 }
			}
 }
 
 public void cambiaAnimazione(String animazione){
	 setOffset(animazione);
	 sprites = Client.instance.allSprites.getSprites(nomeSprite, animazione);
	 setSize(sprites[0].get(0).getIconWidth(), sprites[0].get(0).getIconHeight());

 }
  /*  
public void cambiaAnimazione(String animazione){
	
	setOffset(animazione);
	Vector <javax.swing.ImageIcon[]> sprites_temp = new Vector <javax.swing.ImageIcon[]>();
    Vector <String> nomiFile=new Vector<String>();
   try{
    JarFile jarfile = new JarFile(System.getProperty("java.class.path"));
    for (Enumeration<JarEntry> em1 = jarfile.entries(); em1.hasMoreElements();) {
      Object elem = em1.nextElement();
      if ((""+elem).contains(stato+orientation) && ((""+elem).contains("jpg")||(""+elem).contains("gif")||(""+elem).contains("png")))
   	   {            	   
   	   String[] path =(""+elem).split("/");
   	   nomiFile.add(path[path.length-1]);
   	   }
    }
    
    for (int j=0;j<nomiFile.size();j++) 
 	{
	 for (int i=j; i<nomiFile.size();i++)
	 {
		if (Integer.parseInt(nomiFile.get(j).trim().split("\\.")[0]) > Integer.parseInt(nomiFile.get(i).trim().split("\\.")[0]))
			{
			String temp = nomiFile.get(j);
			nomiFile.set(j, nomiFile.get(i));
			nomiFile.set(i, temp);
			}
	 }
 	}
    for (String nomeFile : nomiFile) 
    {
     javax.swing.ImageIcon[] orientations = new javax.swing.ImageIcon[8];
	orientations[0] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"n/"+nomeFile));
	orientations[1] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"ne/"+nomeFile));
	orientations[2] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"e/"+nomeFile));
	orientations[3] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"se/"+nomeFile));
	orientations[4] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"s/"+nomeFile));
	orientations[5] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"sw/"+nomeFile));
	orientations[6] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"w/"+nomeFile));
	orientations[7] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"nw/"+nomeFile));
	sprites_temp.add(orientations);
      sprites = sprites_temp;
    }
   setSize(sprites_temp.get(0)[0].getIconWidth(), sprites.get(0)[0].getIconHeight());
   }
   catch(Exception ze){
     ze.printStackTrace();
     //System.exit(0);
   }

}

*/


public void setStato(String stato){
	this.stato=stato;
}

public void setOrientation(String or)
	{
	 orientation=or;
	}
        



protected boolean updateIcon(){
     try{
     if ( currentFrame>=sprites[0].size())
        {
    	 
    	 if (stato.contains("attack"))
              {stato=stato.replace("attack", "stand");
               currentFrame=0;
              }
    	 else if (stato.contains("die") ||  stato.equals("looking")) 
    		  {return false;}
    	 else {currentFrame=0;}
        }
     if (!statoOld.equals(stato))
         {
          statoOld = stato;
          cambiaAnimazione(stato);
          currentFrame=0;
         }

     if (orientation.equals("n/")) 		 {this.setIcon(sprites[0].get(currentFrame));}
     else{if (orientation.equals("ne/")) {this.setIcon(sprites[1].get(currentFrame));}
     else{if (orientation.equals("e/"))  {this.setIcon(sprites[2].get(currentFrame));}
     else{if (orientation.equals("se/")) {this.setIcon(sprites[3].get(currentFrame));}
     else{if (orientation.equals("s/"))  {this.setIcon(sprites[4].get(currentFrame));}
     else{if (orientation.equals("sw/")) {this.setIcon(sprites[5].get(currentFrame));}
     else{if (orientation.equals("w/"))  {this.setIcon(sprites[6].get(currentFrame));}
     else{if (orientation.equals("nw/")) {this.setIcon(sprites[7].get(currentFrame));}}}}}}}}          
     currentFrame++;
     }catch(Exception ex){ex.printStackTrace();return false;}
     return true;
}

@Override
public void setLocation(Point p){
	setLocation(p.x, p.y);
}
 @Override
public void setLocation(int x , int y){
	nick.setLocation(new Point(x-20,y+5));	 
    x = x - offset_x;
    y = y - offset_y;
   super.setLocation(x,y);
}

 @Override
 public Point getLocation(){ 
     return new Point (super.getLocation().x+offset_x,super.getLocation().y+offset_y);
 }

public String getNome() {
	return nome_player;
}

  

private class Perform_scalaEnergia extends Thread{
	public Vector<javax.swing.JLabel> energie;
	
	public Perform_scalaEnergia(){
		this.setName("azione_scalaEnergia");
		energie = new Vector<javax.swing.JLabel>();
	}
	public void run()
	{
	 
	}
}


private class Perform_talk extends Thread{
	public Vector<javax.swing.JLabel> energie;
	
	public Perform_talk(){
		this.setName("azione_talk");
		energie = new Vector<javax.swing.JLabel>();
	}
	public void run()
	{
	 
	}
}


       
}
