/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ServerSide;


import java.awt.Point;
import java.rmi.RemoteException;

import javax.sql.rowset.spi.SyncFactory;

import map.maps.MapPaths;
import BothSide.Constants;
import BothSide.Constants.EntityType;
import BothSide.EntityInfo;
import ClientSide.Client;



/**
 *
 * @author DeLac
 */
public class CPUentity extends Thread{
	/**i nemici camminano spesso, LOOKING = STAND
	 * gli animali camminano poco, STAND = mangiare*/
    protected  String STAND;
    protected  String WALK;
    protected  String ATTACK;
    protected  String HITTED;
    protected  String LOOKING;
    protected  String DIE;
    protected EntityInfo info;
    protected Point punto_destinazione;
    protected int distanza_destinazione;
    protected EntityInfo nemicoFocused;
    private Perform_riceviColpo azione_riceviColpo;
    private Perform_muovi azione_muovi;
    private Perform_vagabonda azione_vagabonda;
    private Perform_attacca azione_attacca;
    protected int frameAttack;

    public  CPUentity(String nome, EntityType type, String spriteName){
    	super();
    	info=new EntityInfo();
    	info.entityType= type;
    	info.spriteName=spriteName;
    	info.nome=nome;
    	info.orientation="n/";
    	info.location=(new Point(400,300));
    	STAND=	info.spriteName+"/stand/";
  	    WALK=	info.spriteName+"/walk/";
  	    ATTACK=	info.spriteName+"/attack/";
  	    HITTED=	info.spriteName+"/hitted/";
  	    LOOKING=info.spriteName+"/looking/";
  	    DIE=	info.spriteName+"/die/";
  	    info.stato=STAND;
    	azione_riceviColpo  = new Perform_riceviColpo(); 
		azione_riceviColpo.start();
    	azione_vagabonda = new Perform_vagabonda();   
    	azione_muovi= new Perform_muovi(null);
        azione_muovi.start();
        azione_attacca = new Perform_attacca();
		azione_attacca.start();
        	
    	
        }
      

    @Override
    public void run(){
    	try{sleep((int)(Math.random() * 2500));}catch(Exception ex){}
    	azione_vagabonda.start();
    	}

   

    private void die(){
    	System.out.println("e' morto "+info.nome);
    	try {sleep(7000);} catch (InterruptedException e) {return;}
    	Server.instance.nemici.remove(this);
    	try{Server.instance.impl.killPlayer(info.nome);}catch(Exception ex){ex.printStackTrace();}
    	azione_attacca.interrupt();
    	azione_muovi.interrupt();
    	azione_riceviColpo.interrupt();
    	azione_vagabonda.interrupt();
    	interrupt();
    	
    }
    
    public void cammina(Point lastPoint, int distanza){
        MapPaths map = Server.instance.map;
          java.util.ArrayList<String> path = map.calcolaPath(map.getRombo(info.location.x, info.location.y), map.getRombo(lastPoint.x, lastPoint.y));
          if (path==null) 
            {
        	  info.stato=STAND;
        	  synchronized (azione_vagabonda) {azione_vagabonda.notify();}
        	  return ;
        	} //end = ostacolo
           punto_destinazione = lastPoint;
           distanza_destinazione = distanza;
           azione_muovi.path=path;
           synchronized (azione_muovi) {azione_muovi.notify();}
    }
    

	
     
    
    
    


    private class Perform_riceviColpo extends Thread
    {
  	private String statoOld;
  	
  	
  	public void run()
  	{
  	 while(!info.stato.equals(DIE))
  		{
  	    synchronized (this) {try{ wait();}catch(InterruptedException ex){return;}}
  		 if (info.stato.equals(HITTED))
  		 {
          try{sleep(2000);}catch(InterruptedException ex){return;}
          if (info.stato.equals(DIE)) {die();}
          else{riprendiAzioneVecchia(statoOld);}
         }
  		 else if (info.stato.equals(DIE)) {die();}
  		} 
  	  }
    }
    
    protected void riprendiAzioneVecchia(String statoOld){
    	if (info.stato.equals(DIE)) {return;} //nel frattempo pu essere morto
        if (statoOld.equals(WALK)){cammina(punto_destinazione, distanza_destinazione);}
        if (statoOld.equals(STAND)) {info.stato=STAND;}
     }
    
    private void attacca (EntityInfo nemico)
    {
  	 if (nemico!=null && nemicoFocused!=nemico)
           {
  		    nemicoFocused = nemico;
  		    synchronized (azione_attacca) {azione_attacca.notify();}
           }
    }
    
    protected void beAggressive(EntityInfo player){
    	if ( nemicoFocused==null && info.entityType.equals(EntityType.ENEMY) )
    	{
    	 if (player.location.distance(info.location) < 100)
    	  {
    		 System.out.println("ATTACCAAAAAA");
    		attacca(player);
    	  }
    	}
    }

     synchronized public void riceviColpo(Point colpo){
    //	colpo=new Point(colpo.x+46,colpo.y+74);
		if(info.stato.equals(DIE))
		  {return;}
    	int hittedValue;
    	if ( info.location.distance(colpo) <= 50  )
            {
    		 hittedValue = 8;
    		 String statoOld;
    		// synchronized (info) 
    		  {
    			 info.energy = info.energy-hittedValue;
    		  }
        		 System.out.println("energia= "+info.energy);
			     statoOld = info.stato;
    			 if (info.energy>0) 
    			      {
    				   if (!info.stato.equals(ATTACK) && !info.stato.equals(HITTED) )
    					   {
    					    info.stato=HITTED; // se non sto attaccando, posso fare l'animazione di ricevere il colpo
    					    synchronized (azione_riceviColpo) 
    	    		        {
    	    		         azione_riceviColpo.statoOld = statoOld;
    	    		    	 azione_riceviColpo.notify();
    	    		    	}
    					   }
    			      }
    			 else 
    			     {
      			      info.stato=DIE;
      			      System.out.println(info.nome+"  stato = die");
 		              azione_riceviColpo.statoOld = statoOld;
      			      synchronized (azione_riceviColpo) 
    		           {
      			        System.out.println("notify azione ricevi");
    		    	    azione_riceviColpo.notify();
    		       	   }
      			     } 
    		    
    	        }
  
    	else{hittedValue= -1;}
    	try {Server.instance.impl.scalaEnergia(info.nome, hittedValue);} catch (RemoteException e) {e.printStackTrace();}
    }

  
    
    
    private class Perform_muovi extends Thread
    {
  	private  java.util.ArrayList<String> path;
  	
  	public Perform_muovi(java.util.ArrayList<String> path)
  	 {
  		this.path = path;
  	 }
  	
  public void run()
   {
  	int altezza = Constants.ALTEZZArOMBO;
    int larghezza = Constants.LARGHEZZArOMBO;
  	while(!info.stato.equals(DIE))
  	 {
  	   while(path==null)
  	       { try{synchronized (this) {wait();}}catch(InterruptedException ex){return;} }
  	   info.stato=WALK;
       Point destinazione = punto_destinazione;
       for (int i=1; i<path.size()-1; i++)
        {
         if (destinazione != punto_destinazione || !info.stato.equals(WALK))
            {break;}
         int x_end = (larghezza/2) * ((Integer.parseInt(path.get(i)))/(Constants.righe/2));
         if (  ((Integer.parseInt(path.get(i))%Constants.righe)%2 != 0) )
           {x_end = x_end + larghezza/2;}
         int y_end = (altezza/2)+ ((altezza/2) * (Integer.parseInt(path.get(i))%Constants.righe));
         int x_start = info.location.x;
         int y_start = info.location.y;
         muoviPuntoPunto(new Point(x_start, y_start), new Point(x_end, y_end), 0);
        }
       if (destinazione == punto_destinazione)
         {
           muoviPuntoPunto(new Point(info.location.x, info.location.y), punto_destinazione, distanza_destinazione);
         }  
       // dovrei essere arrivato
       while(punto_destinazione.distance(info.location) <= distanza_destinazione)
    	{
    	 info.stato=STAND; // sono arrivato
    	 if (nemicoFocused==null) 
    	    {
    		 synchronized (azione_vagabonda) {azione_vagabonda.notify();}
    	    }
   	     synchronized (this) {try{wait();}catch(InterruptedException ex){return;}}
    	}
  	   }
     }
  	
  	public void muoviPuntoPunto(Point start, Point end, int distanza)
    {
     Point destinazione = punto_destinazione;
     int new_x=start.x;
     int new_y=start.y;
     while (new Point(new_x,new_y ).distance(end)> distanza && (new_x != end.x || new_y != end.y)&& destinazione==punto_destinazione && info.stato.equals(WALK))
     {        

    	 info.orientation="";
      if (new_y < end.y)
       {
        new_y = new_y+1;
        info.orientation = "s";
        }
      else{
           if (new_y > end.y)
            {
              new_y = new_y-1;
              info.orientation = "n";
             }
          }
      if (new_x < end.x)
         {
          new_x = new_x+1;
          info.orientation += "e";
         }
      else{
           if (new_x > end.x)
             {
               new_x = new_x-1;
               info.orientation += "w";
             }
          }
      info.orientation +="/";
      info.location=new Point(new_x, new_y);
      try{Thread.sleep(20);}catch(InterruptedException ex){return;};
     }
    }
  }
  	
  	
    
    private class Perform_attacca extends Thread{
    	
   	 public void run()
     {
   	  this.setName("azione_attacca");
      while (!info.stato.equals(DIE)) 
   	   {
   		if (nemicoFocused==null)
   		 {
   		  synchronized (this) {try{wait();}catch(InterruptedException e){}}
   		 }
   		 segui();
   	      if ( !isInterrupted() && nemicoFocused!=null && !nemicoFocused.stato.contains("die"))  // forse mentre lo seguivo, ho cambiato idea e non lo attacco piu
   	        {
   	         if( (info.location.distance(nemicoFocused.location)) <= (distanza_destinazione+30))
   	           {
   	        	 info.stato=ATTACK;
   	        	 int x=info.location.x;
   	 	         int y=info.location.y;
   	 	        int c=0;
   	            while(/*!info.stato.equals(STAND)*/ c<9) 
   	             {
   	            	 int endx=nemicoFocused.location.x;
   		 	         int endy=nemicoFocused.location.y;
   	 	            	 String orient="";
   	 	                 if (y < endy)
   	 	                  {
   	 	                   orient = "s";
   	 	                   }
   	 	                 else{
   	 	                      if (y > endy)
   	 	                       {
   	 	                         orient = "n";
   	 	                        }
   	 	                     }
   	 	                 if (x < endx)
   	 	                    {
   	 	                     orient += "e";
   	 	                    }
   	 	                 else{
   	 	                      if (x > endx)
   	 	                        {
   	 	                          orient += "w";
   	 	                        }
   	 	                     }
   	 	                 info.orientation = orient+"/";
   	 	                 if (info.stato.equals(ATTACK) && c==frameAttack) 
   	 	                 {
   	 	                  try{Server.instance.impl.assegnaColpoToPlayer(nemicoFocused.nome, info.location);}catch(RemoteException e){e.printStackTrace();}
   	 	                 }
   	 	                 c++;
   	            	try{Thread.sleep(110);}catch(InterruptedException ex){return;} //controllo in che direzione devo menare xk il nemico puo spostarsi
   	             }
   	            if (!info.stato.equals(DIE)){info.stato=STAND;}
   	            else {return;}
   	            try{Thread.sleep(500);}catch(InterruptedException ex){return;} //attacca ogni mezzo secondo
   	           }
   	        }
   	      }
   	 }
   	 
   	 public boolean segui()
        {
         if ( nemicoFocused!=null && info.location.distance(nemicoFocused.location) > 30)
           {
            cammina(nemicoFocused.location, 30);
           try{Thread.sleep(70);}catch(InterruptedException ex){return false;} // gli do il tempo di farlo incamminare
           while(!info.stato.equals(STAND)) //aspetto che arriva vicino al nemico
           {
            try{Thread.sleep(50);}catch(InterruptedException ex){ return false;} //tempo che aspetta quando arriva prima di attaccare
            if (nemicoFocused.location.distance(punto_destinazione) >10) //se il nemico si  spostato di 5, lo rincorro
                {
                  cammina(nemicoFocused.location, 30);
                }
           }
          } return true;
   	}
   	 
   	 
   	 
   }  
    


  private class Perform_vagabonda extends Thread{
     
     
     public void run(){
      while(!info.stato.equals(DIE))
      {     	  
         info.stato=LOOKING;
         try{sleep(1500);}catch(InterruptedException ex){return;} //non so quando finisce l'animazione di looking.... vado a occhio!
         while (!info.stato.equals(LOOKING))
             {synchronized (this) {try{wait();}catch(InterruptedException ex){return;}}}
    	 double segnox =  Math.random();
         double segnoy =  Math.random();
         int x =  (int)(Math.random() * 50) ;
         int y =  (int)(Math.random() * 50) ;
         if (segnox > 0.5) {x=-x;}
         if (segnoy > 0.5) {y=-y;}
         x = x + info.location.x;
         y = y + info.location.y;
         cammina(new Point (x,y), 0);
         while (!info.stato.equals(STAND))
              {synchronized (this) {try{wait();}catch(InterruptedException ex){return;}}};
         if (info.entityType==EntityType.ENEMY)  
		   {//se  un nemico cammina di piu. gli animali camminano meno e mangiano di piu
		    try{sleep(500);}catch(InterruptedException ex){return;}
		   }
	     else
	       {
		    try{sleep(7000);}catch(Exception ex){return;}
	       }
       }
     }
  }    

      
      
      
      
      
    

     


}
