package GUI;

import Datatypes.Archivo;
import Fabricas.Factory;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JFCargaServidor extends javax.swing.JFrame {
    
    public JFCargaServidor() {
        
        initComponents();
        definirVentana();
        this.setVisible(true);
    
    }
    
    private void definirVentana(){
    
        int X = Toolkit.getDefaultToolkit().getScreenSize().width;
        int Y = Toolkit.getDefaultToolkit().getScreenSize().height;
        int tX = Math.round(getSize().width);
        int tY = Math.round(getSize().height);
        
        X = (X / 2) - (tX / 2);
        Y = (Y / 2) - (tY / 2);
        
        setLocation(X, Y);
        
    }
    
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        JFC_CargaServidor = new javax.swing.JFileChooser();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Seleccione el directorio del servidor");
        setResizable(false);

        JFC_CargaServidor.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);
        JFC_CargaServidor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JFC_CargaServidorActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(JFC_CargaServidor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(JFC_CargaServidor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void JFC_CargaServidorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JFC_CargaServidorActionPerformed
        
        switch (evt.getActionCommand()){
            
            case JFileChooser.APPROVE_SELECTION:
                
                File directorioServidor = JFC_CargaServidor.getSelectedFile();
                String direccionServidor = directorioServidor.getAbsolutePath() + "/Data/Persistencia/Base de Datos/SCDBase.sqlite";
                File confirmar = new File(direccionServidor);
                
                if(confirmar.exists()){
                
                    this.setVisible(false);
                    
                    Factory f = Factory.getInstance(direccionServidor);
                    
                    try{
                        
                        String dirGUI = JIFInicial.getInstance().getDirGUI();
                        File temp = new File(dirGUI + "/Data/dirServidor.obj");
        
                        String linea = directorioServidor.getAbsolutePath();
                        
                        Archivo a = new Archivo(temp);
                        a.escribirObjetoEnArchivo(linea);
                        
                        JIFInicial.getInstance().setFactory(f, directorioServidor.getAbsolutePath());
                        JIFInicial.getInstance().cargarOpciones();
                        JIFInicial.getInstance().setVisible(true);
                
                    }
                    
                    catch(Exception e){
                    
                        JOptionPane.showMessageDialog(this, "<html><body>" + e.getMessage() + "</body></html>", "Error!", JOptionPane.ERROR_MESSAGE);
                        this.dispose();
                        System.exit(0);
                        
                    }
                                                                
                }
                
                else{
                
                    JOptionPane.showMessageDialog(this, "<html><body>El directorio seleccionado no contiene al servidor.</body></html>", "Error!", JOptionPane.ERROR_MESSAGE);
                    this.dispose();
                    System.exit(0);
                    
                }
                        
                break;
            
            case JFileChooser.CANCEL_SELECTION:
                
                this.dispose();
                System.exit(0);
                
                break;
               
        }
        
    }//GEN-LAST:event_JFC_CargaServidorActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFileChooser JFC_CargaServidor;
    // End of variables declaration//GEN-END:variables
}
