package GUI;

import GUILogica.Panel;
import Datatypes.DataPerfil;
import Datatypes.MD5;
import Datatypes.PDate;
import Fabricas.Factory;
import Interfaces.IPerfil;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JIFAltaPerfil extends javax.swing.JInternalFrame{

    private IPerfil ip = null;
    private Boolean continuar = null;
    private File imagen = null;
    private String path = null;
    private Panel pi = null;
    
    public JIFAltaPerfil(Factory f) throws Exception{
        
        ip = f.getIPerfil();
        initComponents();
        configurarCalendario();
                
    }
    
    public void escribirImagen(File archivo, String path) throws Exception{
    
        try{
        
            String nombreImg = path.substring(path.lastIndexOf("/") + 1, path.length());
            path = path.substring(0, path.lastIndexOf("/") + 1);
            String dirservidor = JIFInicial.getInstance().getDirServidor();
            File directorio = new File(dirservidor + "/" + path);
            directorio.mkdirs();
            File img = new File(directorio, nombreImg);
            InputStream in;
            in = new FileInputStream(archivo);
            OutputStream out;
            out = new FileOutputStream(img);
                                
            byte[] buf = new byte[1024];
            int len;
            while ((len = in.read(buf)) > 0){
                
                out.write(buf, 0, len);
            
            }

            in.close();
            out.close();
    
        }
        
        catch(IOException e){
        
            throw e;
        
        }
        
    }
    
    private void configurarCalendario(){
    
       GregorianCalendar gc = new GregorianCalendar();
       gc.setTime(new Date());
       
       Integer año = gc.get(GregorianCalendar.YEAR);
       año = año - 120;
       gc.set(GregorianCalendar.YEAR, año);
       Date min = gc.getTime();
       
       gc.setTime(new Date());
       año = gc.get(GregorianCalendar.YEAR);
       año = año - 18;
       gc.set(GregorianCalendar.YEAR, año);
       Date max = gc.getTime();
       
       JDC_Fecha.setSelectableDateRange(min, max);
       JDC_Fecha.setDate(max);
            
    }
    
    private Boolean passValido(){
    
        Boolean valido;
        char password[] = JPF_Password.getPassword();
        char confirmar[] = JPF_Confirmar.getPassword();
        
        if((password.length > 0) && (confirmar.length > 0) && (Arrays.equals(confirmar, password))){
        
            valido = true;
        
        }
        
        else{
        
            valido = false;
        
        }
        
        return valido;
    
    }
    
    public void habilitarAltaBtn(){
    
        if(JRB_Cliente.isSelected()){
        
            if((JTF_Nombre.getText().length() > 0) && (JTF_Apellido.getText().length() > 0) && (path != null) && passValido()){

                JB_DarAlta.setEnabled(true);

            }
            
            else{
            
                JB_DarAlta.setEnabled(false);
            
            }
            
        }
        
        else{
        
            if((JTF_Nombre.getText().length() > 0) && (JTF_Apellido.getText().length() > 0) && (JTF_Web.getText().length() > 0) && (path != null) && passValido()){

                JB_DarAlta.setEnabled(true);

            }
            
            else{
            
                JB_DarAlta.setEnabled(false);
            
            }
        
        }
        
    }
    
    private void centrarVentana(){
        
        Dimension desktopSize = JIFInicial.getDPInicioDimension();
        Dimension jInternalFrameSize = this.getSize();
        this.setLocation((desktopSize.width - jInternalFrameSize.width)/2,
                                   (desktopSize.height- jInternalFrameSize.height)/2);
        
    }
    
    public void componentesInicio(){
    
        deshabilitarComponentes();
        JTF_Nick.setEnabled(true);
        JTF_Email.setEnabled(true);
        JB_Cancelar.setEnabled(true);
        
    }
    
    public void componentesCliente(){
    
        deshabilitarComponentes();
        JRB_Cliente.setSelected(true);
        JRB_Cliente.setEnabled(true);
        JRB_Desarrollador.setEnabled(true);
        JRB_Desarrollador.setSelected(false);
        JTF_Nombre.setEnabled(true);
        JTF_Apellido.setEnabled(true);
        JB_Subir.setEnabled(true);
        JB_Cancelar.setEnabled(true);
        JDC_Fecha.setEnabled(true);
        JPF_Password.setEnabled(true);
        JL_Nivel.setEnabled(true);
        JPF_Confirmar.setEnabled(true);
        JL_Confirmar.setEnabled(true);
        
    
    }
    
    private Integer nivelSeguridad(char password[]){
    
        Integer nivel = 0;
        
        Integer largo = password.length;
        Boolean cletras = false;
        Boolean cnumeros = false;
        Boolean cmayusculas = false;
        
        for(int i = 0; i < largo; i++){
        
            Character c = password[i];
            
            if((c > 47) && (c < 58)){
            
                cnumeros = true;
            
            }
        
            if((c < 48) || (c > 57)){
            
                cletras = true;
            
            }
            
            if(Character.isUpperCase(c)){
            
                cmayusculas = true;
            
            }
                       
        }
        
        if(largo < 8){
        
            nivel = 0;
        
        }
        
        else if((largo >= 8) && (largo < 10)){
        
            if((cmayusculas == true) && (cnumeros == true) && (cletras == false)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == false) && (cletras == true)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == false) && (cletras == true)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == true) && (cletras == false)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == true) && (cletras == true)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == true) && (cletras == true)){

                nivel = 2;

            }
            
        }
        
        else if(largo >= 10){
        
            if((cmayusculas == true) && (cnumeros == true) && (cletras == false)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == false) && (cletras == true)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == false) && (cletras == true)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == true) && (cletras == false)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == true) && (cletras == true)){
            
                nivel = 3;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == true) && (cletras == true)){
            
                nivel = 2;
            
            }
            
        }
        
        return nivel;
    
    }
    
    public void componentesDesarrollador(){
    
        componentesCliente();
        JRB_Cliente.setSelected(false);
        JRB_Desarrollador.setSelected(true);
        JTF_Web.setEnabled(true);
    
    }
    
    public void deshabilitarComponentes(){
        
        JB_Verificar.setEnabled(false);
        JB_DarAlta.setEnabled(false);
        JB_Subir.setEnabled(false);
        JRB_Desarrollador.setEnabled(false);
        JRB_Cliente.setEnabled(false);
        JTF_Nombre.setEnabled(false);
        JTF_Apellido.setEnabled(false);
        JTF_Web.setEnabled(false);
        JTF_Nick.setEnabled(false);
        JTF_Email.setEnabled(false);
        JB_Cancelar.setEnabled(false);
        JDC_Fecha.setEnabled(false);
        JPF_Password.setEnabled(false);
        JPF_Confirmar.setEnabled(false);
        JL_Nivel.setEnabled(false);
        JL_Nivel.setEnabled(false);
    
    }
    
    private DataPerfil prepareData(){
    
        DataPerfil perfil;
        
        char pass[] = JPF_Password.getPassword();     
        String password = String.valueOf(pass);
        
        MD5 encriptar = new MD5();
        
        try{
        
            password = encriptar.md5(password);
        
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>Error de conversión MD5<br>Mensaje de error: " + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
                    
        }
        
        String nick = JTF_Nick.getText();
        String email = JTF_Email.getText();
        String tipoperfil;
        String sitioweb = null;
        String imgperfil;
        
        if(JRB_Cliente.isSelected()){
        
            imgperfil = "Data/Perfiles/Clientes/" + nick + "/Imagen_Perfil/IMGP_" + nick;
            tipoperfil = "[CLIENTE]";
            
        }
        
        else{
        
            imgperfil = "Data/Perfiles/Desarrolladores/" + nick + "/Imagen_Perfil/IMGP_" + nick;
            tipoperfil = "[DESARROLLADOR]";
            sitioweb = JTF_Web.getText();
            
        }
        
        String nombre = JTF_Nombre.getText();
        String apellido = JTF_Apellido.getText();
        
        Integer dia = JDC_Fecha.getCalendar().get(GregorianCalendar.DATE);
        Integer mes = JDC_Fecha.getCalendar().get(GregorianCalendar.MONTH);
        mes++;
        Integer año = JDC_Fecha.getCalendar().get(GregorianCalendar.YEAR);
        PDate fechanac = new PDate(dia, mes, año);      
                
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());
        
        Integer añoactual = gc.get(GregorianCalendar.YEAR);
        Integer mesactual = gc.get(GregorianCalendar.MONTH);
        Integer diaActual = gc.get(GregorianCalendar.DAY_OF_MONTH);
        
        Integer añoseleccionado = JDC_Fecha.getCalendar().get(GregorianCalendar.YEAR);
        Integer messelect = JDC_Fecha.getCalendar().get(GregorianCalendar.MONTH);
        Integer diaselect = JDC_Fecha.getCalendar().get(GregorianCalendar.DAY_OF_MONTH);
        
        Integer edad;
        
        if(messelect >= mesactual){
        
            if(messelect == mesactual && diaselect == diaActual){
                
                edad = añoactual - añoseleccionado;
                
            }
            
            else{
         
                edad = añoactual - añoseleccionado - 1;
                   
            }   
            
        }
        
        else{
        
            edad = añoactual - añoseleccionado;
        
        }
        
        perfil = new DataPerfil(password, nick, email, tipoperfil, nombre, apellido, fechanac, edad, imgperfil, sitioweb);
        
        return perfil;
    
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        JD_SelectorImagen = new javax.swing.JDialog();
        JFC_Chooser = new javax.swing.JFileChooser();
        jLblNick = new javax.swing.JLabel();
        JTF_Nick = new javax.swing.JTextField();
        jLblEmail = new javax.swing.JLabel();
        JTF_Email = new javax.swing.JTextField();
        JB_Verificar = new javax.swing.JButton();
        JB_Cancelar = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jLblPerfil = new javax.swing.JLabel();
        JRB_Cliente = new javax.swing.JRadioButton();
        JRB_Desarrollador = new javax.swing.JRadioButton();
        jLblNombre = new javax.swing.JLabel();
        JTF_Nombre = new javax.swing.JTextField();
        JLblApellido = new javax.swing.JLabel();
        JTF_Apellido = new javax.swing.JTextField();
        jLblFechaNac = new javax.swing.JLabel();
        JDC_Fecha = new com.toedter.calendar.JDateChooser();
        jLblWebDesarrollador = new javax.swing.JLabel();
        JTF_Web = new javax.swing.JTextField();
        JB_Subir = new javax.swing.JButton();
        JP_Imagen = new javax.swing.JPanel();
        JB_DarAlta = new javax.swing.JButton();
        JPF_Password = new javax.swing.JPasswordField();
        jLabel1 = new javax.swing.JLabel();
        JPF_Confirmar = new javax.swing.JPasswordField();
        jLabel2 = new javax.swing.JLabel();
        JL_Nivel = new javax.swing.JLabel();
        JL_Confirmar = new javax.swing.JLabel();

        JD_SelectorImagen.setTitle("Seleccionar Imágen");
        JD_SelectorImagen.setResizable(false);

        FileNameExtensionFilter JFC_Filtro = new FileNameExtensionFilter("Imágenes", "jpg", "jpeg", "png", "bmp");
        JFC_Chooser.setFileFilter(JFC_Filtro);
        JFC_Chooser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JFC_ChooserActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout JD_SelectorImagenLayout = new javax.swing.GroupLayout(JD_SelectorImagen.getContentPane());
        JD_SelectorImagen.getContentPane().setLayout(JD_SelectorImagenLayout);
        JD_SelectorImagenLayout.setHorizontalGroup(
            JD_SelectorImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_SelectorImagenLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JFC_Chooser, javax.swing.GroupLayout.DEFAULT_SIZE, 752, Short.MAX_VALUE)
                .addContainerGap())
        );
        JD_SelectorImagenLayout.setVerticalGroup(
            JD_SelectorImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_SelectorImagenLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JFC_Chooser, javax.swing.GroupLayout.DEFAULT_SIZE, 544, Short.MAX_VALUE)
                .addContainerGap())
        );

        setClosable(true);
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
        });

        jLblNick.setText("Nick:");

        JTF_Nick.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_NickKeyReleased(evt);
            }
        });

        jLblEmail.setText("Email:");

        JTF_Email.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_EmailKeyReleased(evt);
            }
        });

        JB_Verificar.setText("Verificar");
        JB_Verificar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_VerificarActionPerformed(evt);
            }
        });

        JB_Cancelar.setText("Cancelar");
        JB_Cancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_CancelarActionPerformed(evt);
            }
        });

        jLblPerfil.setText("Tipo de Perfil:");

        JRB_Cliente.setText("Cliente");
        JRB_Cliente.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JRB_ClienteActionPerformed(evt);
            }
        });

        JRB_Desarrollador.setText("Desarrollador");
        JRB_Desarrollador.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JRB_DesarrolladorActionPerformed(evt);
            }
        });

        jLblNombre.setText("Nombre:");

        JTF_Nombre.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_NombreKeyReleased(evt);
            }
        });

        JLblApellido.setText("Apellido:");

        JTF_Apellido.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_ApellidoKeyReleased(evt);
            }
        });

        jLblFechaNac.setText("Fecha de Nacimiento:");

        JDC_Fecha.setDebugGraphicsOptions(javax.swing.DebugGraphics.BUFFERED_OPTION);

        jLblWebDesarrollador.setText("Web del Desarrollador:");

        JTF_Web.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_WebKeyReleased(evt);
            }
        });

        JB_Subir.setText("Subir Imágen");
        JB_Subir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_SubirActionPerformed(evt);
            }
        });

        JP_Imagen.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0), 3));

        javax.swing.GroupLayout JP_ImagenLayout = new javax.swing.GroupLayout(JP_Imagen);
        JP_Imagen.setLayout(JP_ImagenLayout);
        JP_ImagenLayout.setHorizontalGroup(
            JP_ImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 144, Short.MAX_VALUE)
        );
        JP_ImagenLayout.setVerticalGroup(
            JP_ImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 144, Short.MAX_VALUE)
        );

        JB_DarAlta.setText("Dar Alta");
        JB_DarAlta.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_DarAltaActionPerformed(evt);
            }
        });

        JPF_Password.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JPF_PasswordKeyReleased(evt);
            }
        });

        jLabel1.setText("Contraseña:");

        JPF_Confirmar.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JPF_ConfirmarKeyReleased(evt);
            }
        });

        jLabel2.setText("Confirmar:");

        JL_Nivel.setFont(new java.awt.Font("Comic Sans MS", 1, 15)); // NOI18N
        JL_Nivel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        JL_Nivel.setBorder(null);
        JL_Nivel.setOpaque(true);

        JL_Confirmar.setFont(new java.awt.Font("Comic Sans MS", 1, 15)); // NOI18N
        JL_Confirmar.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        JL_Confirmar.setBorder(null);
        JL_Confirmar.setOpaque(true);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(JTF_Web, javax.swing.GroupLayout.PREFERRED_SIZE, 323, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLblWebDesarrollador)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                    .addComponent(jLblFechaNac)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(JDC_Fecha, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                    .addComponent(jLblPerfil)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(JRB_Cliente)
                                    .addGap(18, 18, 18)
                                    .addComponent(JRB_Desarrollador))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addComponent(jLblNombre)
                                        .addComponent(JLblApellido))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(JTF_Apellido)
                                        .addComponent(JTF_Nombre)))))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(JB_DarAlta, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                .addComponent(JB_Subir, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(JP_Imagen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(8, 8, 8))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel1)
                                    .addComponent(jLabel2))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(JPF_Password)
                                    .addComponent(JPF_Confirmar)))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jLblEmail)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JTF_Email))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLblNick)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JTF_Nick)))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(JB_Verificar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(JB_Cancelar, javax.swing.GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE)
                            .addComponent(JL_Nivel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(JL_Confirmar, javax.swing.GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(1, 1, 1)
                        .addComponent(JB_Verificar)
                        .addGap(18, 18, 18)
                        .addComponent(JB_Cancelar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(JL_Nivel, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLblNick)
                            .addComponent(JTF_Nick, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(19, 19, 19)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLblEmail)
                            .addComponent(JTF_Email, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(21, 21, 21)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(JPF_Password, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel1))))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(JPF_Confirmar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jLabel2))
                    .addComponent(JL_Confirmar, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 47, Short.MAX_VALUE)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLblPerfil)
                                    .addComponent(JRB_Cliente)
                                    .addComponent(JRB_Desarrollador))
                                .addGap(18, 18, 18)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                            .addComponent(jLblNombre)
                                            .addComponent(JTF_Nombre, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGap(45, 45, 45))
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(JTF_Apellido, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(JLblApellido)))
                                .addGap(28, 28, 28)
                                .addComponent(jLblFechaNac))
                            .addComponent(JDC_Fecha, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLblWebDesarrollador)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(JTF_Web, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(2, 2, 2)
                        .addComponent(JB_Subir)
                        .addGap(18, 18, 18)
                        .addComponent(JP_Imagen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(29, 29, 29)
                        .addComponent(JB_DarAlta)))
                .addGap(23, 23, 23))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    
    private void JRB_ClienteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JRB_ClienteActionPerformed

        JRB_Cliente.setSelected(true);
        JRB_Desarrollador.setSelected(true);
        componentesCliente();
        habilitarAltaBtn();
        
    }//GEN-LAST:event_JRB_ClienteActionPerformed

    private void JB_DarAltaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_DarAltaActionPerformed

        DataPerfil perfil = prepareData();
        String nick = perfil.getNick();
        String email = perfil.getCorreo();
        String nombre = perfil.getNombre();
        String apellido = perfil.getApellido();
        String fechanac = perfil.getFechaNac().getString();
        Integer edad = perfil.getEdad();
        String weblink = perfil.getSitioWeb();
        Integer opcion;
               
        String mensaje = new String();
        String temp = "<html><b>Los siguientes datos serán dados de alta:<br><br>";
        mensaje = mensaje.concat(temp);
        
        temp = "Nick: " + nick + "<br>";
        mensaje = mensaje.concat(temp);
            
        temp = "Email: " + email + "<br>";
        mensaje = mensaje.concat(temp);
          
        if(weblink != null){
        
            temp = "Perfil: Desarrollador<br>";
            mensaje = mensaje.concat(temp);
        
        }
        
        else{
        
            temp = "Perfil: Cliente<br>";
            mensaje = mensaje.concat(temp);
        
        }
            
        temp = "Nombre: " + nombre + "<br>";
        mensaje = mensaje.concat(temp);
        
        temp = "Apellido: " + apellido + "<br>";
        mensaje = mensaje.concat(temp);

        temp = "Fecha de Nacimiento: " + fechanac + "<br>";
        mensaje = mensaje.concat(temp);

        temp = "Edad: " + edad + "<br>";
        mensaje = mensaje.concat(temp);
        
        if(weblink != null){

            temp = "Web: " + weblink + "<br>";
            mensaje = mensaje.concat(temp);
            
        }
        
        temp = "<br>Desea confirmar?</b></html>";
        mensaje = mensaje.concat(temp);
        
        opcion = JOptionPane.showConfirmDialog(this, mensaje, "Confirmación", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, frameIcon);
        
        if(opcion == 0){
        
            try{
            
                ip.darAltaPerfil(perfil);
                escribirImagen(imagen, perfil.getImagen());
                this.setVisible(false);
                JDesktopPane p = (JDesktopPane)this.getParent();
                p.remove(this);
                p.repaint();
                this.dispose();
                JIFInicial.BloquearJFInicial();
                JOptionPane.showMessageDialog(this, "Operación realizada con exito!", "Mensaje", JOptionPane.INFORMATION_MESSAGE);
                
            }
            
            catch(Exception e){
            
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);
            
            }
                
        }
        
    }//GEN-LAST:event_JB_DarAltaActionPerformed

    private void JB_CancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_CancelarActionPerformed

        this.dispose();
        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_JB_CancelarActionPerformed

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing

        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_formInternalFrameClosing

    private void JTF_NickKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_NickKeyReleased

        if((JTF_Nick.getText().length() > 0) && (JTF_Email.getText().contains("@") && (JTF_Email.getText().contains(".")))){
        
            this.JB_Verificar.setEnabled(true);
        
        }else{
        
            this.JB_Verificar.setEnabled(false);
        
        }
        
    }//GEN-LAST:event_JTF_NickKeyReleased

    private void JTF_EmailKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_EmailKeyReleased

        if((JTF_Nick.getText().length() > 0) && (JTF_Email.getText().contains("@") && (JTF_Email.getText().contains(".")))){
        
            this.JB_Verificar.setEnabled(true);
        
        }else{
        
            this.JB_Verificar.setEnabled(false);
        
        }

    }//GEN-LAST:event_JTF_EmailKeyReleased

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened

        centrarVentana();
        
    }//GEN-LAST:event_formInternalFrameOpened

    private void JB_VerificarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_VerificarActionPerformed

        String nick = JTF_Nick.getText();
        String email = JTF_Email.getText();
        
        try{
        
            continuar = ip.comprobarUsuario(nick, email);

        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
        if(continuar == true){
        
            JB_Verificar.setEnabled(false);
            JRB_Cliente.setEnabled(true);
            JRB_Desarrollador.setEnabled(true);
        
        }
        
        else{
            
            int opt = JOptionPane.showConfirmDialog(this, "El nick " + nick + " o el email " + email + " ya existen en el sistema.", "Advertencia!", JOptionPane.OK_CANCEL_OPTION, JOptionPane.WARNING_MESSAGE, null);
            
            if(opt == 0){ //Aceptar
            
                JB_Verificar.setEnabled(false);
            
            }
            
            else{
            
                JDesktopPane jdp = (JDesktopPane)this.getParent();
                this.setVisible(false);
                jdp.remove(this);
                jdp.repaint();
                this.dispose();
                JIFInicial.BloquearJFInicial();
                
            }
            
        }
        
    }//GEN-LAST:event_JB_VerificarActionPerformed

    private void JRB_DesarrolladorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JRB_DesarrolladorActionPerformed

        JRB_Cliente.setSelected(false);
        JRB_Desarrollador.setSelected(true);
        componentesDesarrollador();
        habilitarAltaBtn();
        
    }//GEN-LAST:event_JRB_DesarrolladorActionPerformed

    private void JB_SubirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_SubirActionPerformed

        JFC_Chooser.setSize(640, 480);
        JD_SelectorImagen.setSize(JFC_Chooser.getSize());
        JD_SelectorImagen.setLocationRelativeTo(this);
        JD_SelectorImagen.setVisible(true);
        deshabilitarComponentes();

    }//GEN-LAST:event_JB_SubirActionPerformed

    private void JFC_ChooserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JFC_ChooserActionPerformed

        if(evt.getActionCommand().equals(JFileChooser.APPROVE_SELECTION)){
        
            this.imagen = JFC_Chooser.getSelectedFile();
            JD_SelectorImagen.setVisible(false);
            
            try{
                
                if(pi == null){

                    pi = new Panel(imagen);
                    pi.setSize(JP_Imagen.getSize());
                    JP_Imagen.add(pi);
                    JP_Imagen.repaint();

                }

                else{

                    pi.cargarImagen(imagen);
                    JP_Imagen.repaint();

                }
        
            }
            
            catch(Exception e){
            
                JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
                    
            }
                
            if(this.JRB_Cliente.isSelected()){
            
                componentesCliente();
                JB_Cancelar.setEnabled(true);
                
            }
            
            else{
            
                componentesDesarrollador();
                JB_Cancelar.setEnabled(true);
            
            }
            
            path = imagen.getAbsolutePath();
            
            habilitarAltaBtn();

        }
        
        if(evt.getActionCommand().equals(JFileChooser.CANCEL_SELECTION)){
        
            JD_SelectorImagen.setVisible(false);
            this.setEnabled(true);
            
            if(this.JRB_Cliente.isSelected()){
            
                componentesCliente();
                
                
            }
            
            else{
            
                componentesDesarrollador();
            
            }
        
        }

    }//GEN-LAST:event_JFC_ChooserActionPerformed

    private void JCB_CalendarioActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JCB_CalendarioActionPerformed
    }//GEN-LAST:event_JCB_CalendarioActionPerformed

    private void JTF_NombreKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_NombreKeyReleased
        
        habilitarAltaBtn();
        
    }//GEN-LAST:event_JTF_NombreKeyReleased

    private void JTF_ApellidoKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_ApellidoKeyReleased

        habilitarAltaBtn();

    }//GEN-LAST:event_JTF_ApellidoKeyReleased

    private void JTF_WebKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_WebKeyReleased

        habilitarAltaBtn();

    }//GEN-LAST:event_JTF_WebKeyReleased

    private void JPF_PasswordKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JPF_PasswordKeyReleased
        
        char password[] = JPF_Password.getPassword();
        
        if(password.length > 7){
        
            JPF_Confirmar.setEnabled(true);
            JL_Nivel.setEnabled(true);
        
        }
        
        else{
        
            JPF_Confirmar.setEnabled(false);
            JL_Nivel.setEnabled(false);
        
        }
              
        if(nivelSeguridad(password) == 1){
        
            JL_Nivel.setText("Nivel Bajo");
            JL_Nivel.setBorder(javax.swing.BorderFactory.createLineBorder(Color.red));
            
        }
        
        else if(nivelSeguridad(password) == 2){
        
            JL_Nivel.setText("Nivel Medio");
            JL_Nivel.setBorder(javax.swing.BorderFactory.createLineBorder(Color.yellow));
            
        }
        
        else if(nivelSeguridad(password) == 3){
        
            JL_Nivel.setText("Nivel Alto");
            JL_Nivel.setBorder(javax.swing.BorderFactory.createLineBorder(Color.green));
            
        }
        
        else{
        
            JL_Nivel.setText("Nivel Nulo");
            JL_Nivel.setBorder(null);
        
        }
        
        char confirmar[] = JPF_Confirmar.getPassword();
        
        if(Arrays.equals(password, confirmar) && (password.length > 7)){
        
            JL_Confirmar.setText("OK!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.green));
        
        }
        
        else{
        
            JL_Confirmar.setText("ERROR!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.red));
        
        }

        habilitarAltaBtn();
        
    }//GEN-LAST:event_JPF_PasswordKeyReleased

    private void JPF_ConfirmarKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JPF_ConfirmarKeyReleased

        char password[] = JPF_Password.getPassword();
        char confirmar[] = JPF_Confirmar.getPassword();
        
        if(Arrays.equals(password, confirmar) && (password.length > 7)){
        
            JL_Confirmar.setText("OK!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.green));
        
        }
        
        else{
        
            JL_Confirmar.setText("ERROR!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.red));
        
        }

        habilitarAltaBtn();
        
    }//GEN-LAST:event_JPF_ConfirmarKeyReleased

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton JB_Cancelar;
    private javax.swing.JButton JB_DarAlta;
    private javax.swing.JButton JB_Subir;
    private javax.swing.JButton JB_Verificar;
    private com.toedter.calendar.JDateChooser JDC_Fecha;
    private javax.swing.JDialog JD_SelectorImagen;
    private javax.swing.JFileChooser JFC_Chooser;
    private javax.swing.JLabel JL_Confirmar;
    private javax.swing.JLabel JL_Nivel;
    private javax.swing.JLabel JLblApellido;
    private javax.swing.JPasswordField JPF_Confirmar;
    private javax.swing.JPasswordField JPF_Password;
    private javax.swing.JPanel JP_Imagen;
    private javax.swing.JRadioButton JRB_Cliente;
    private javax.swing.JRadioButton JRB_Desarrollador;
    private javax.swing.JTextField JTF_Apellido;
    private javax.swing.JTextField JTF_Email;
    private javax.swing.JTextField JTF_Nick;
    private javax.swing.JTextField JTF_Nombre;
    private javax.swing.JTextField JTF_Web;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLblEmail;
    private javax.swing.JLabel jLblFechaNac;
    private javax.swing.JLabel jLblNick;
    private javax.swing.JLabel jLblNombre;
    private javax.swing.JLabel jLblPerfil;
    private javax.swing.JLabel jLblWebDesarrollador;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables

}
