/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package GUI;

import Datatypes.DataCategoria;
import Fabricas.Factory;
import Interfaces.IJuego;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author dalep0
 */
public class JIFBajaJuego extends javax.swing.JInternalFrame {

    private Factory f = null;
    private IJuego ij = null;
    
    /**
     * Creates new form JIFBajaJuego
     */
    public JIFBajaJuego(Factory f) throws Exception{
        
        this.f = f;
        this.ij = f.getIJuego();
        initComponents();
        cargarCategorias();
        bloquearComponentes();

    }
    
    private void bloquearComponentes(){
        
        this.jButtonSiguiente.setEnabled(false);
        
    }
    
    private void cargarCategorias()throws Exception{
        
        
        List<DataCategoria> listaC = ij.listarCategorias();
        DefaultTableModel tm = (DefaultTableModel) jTableCats.getModel();
        int rows = 0;
        
        for (DataCategoria dc : listaC) {

            tm.addRow(new Object[rows]);
            tm.setValueAt(dc.getNombre(), rows, 0);
            rows++;
            
        }
        
        this.jTableCats.setModel(tm);
        
    }
    

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableCats = new javax.swing.JTable();
        jLabel1 = new javax.swing.JLabel();
        jButtonSiguiente = new javax.swing.JButton();
        jButtonCancelar = new javax.swing.JButton();

        jTableCats.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jTableCats.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null}
            },
            new String [] {
                "Categoría"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableCats.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jTableCats.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableCatsMouseClicked(evt);
            }
        });
        jScrollPane2.setViewportView(jTableCats);

        jScrollPane1.setViewportView(jScrollPane2);

        jLabel1.setFont(new java.awt.Font("Ubuntu", 1, 15)); // NOI18N
        jLabel1.setText("Seleccione una categoría");

        jButtonSiguiente.setText("Siguiente");
        jButtonSiguiente.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSiguienteActionPerformed(evt);
            }
        });

        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelarActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(27, 27, 27)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 220, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jButtonCancelar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButtonSiguiente, javax.swing.GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(16, 16, 16)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonSiguiente)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonCancelar))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 270, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(41, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jTableCatsMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableCatsMouseClicked
        int row = this.jTableCats.getSelectedRow();
        Object selection = jTableCats.getValueAt(row, 0);

        if(selection != null){
           
            this.jButtonSiguiente.setEnabled(true);
            
        }
        else{
            
            this.jButtonSiguiente.setEnabled(false);
            
        }
    }//GEN-LAST:event_jTableCatsMouseClicked

    private void jButtonSiguienteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSiguienteActionPerformed
        
        int row = this.jTableCats.getSelectedRow();
        String categoria = this.jTableCats.getValueAt(row, 0).toString();
        try{
            
            JIFBajaJuegoConfirmar JIFBJC = new JIFBajaJuegoConfirmar(this.f, categoria );
            JIFInicial.getJIFInicialjDP().add(JIFBJC);
            JIFInicial.getJIFInicio().setTitle("Eliminar Juego");
            JIFBJC.setVisible(true);
            this.dispose();
        
        }
        catch(Exception e){
            
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);
            
        }
    }//GEN-LAST:event_jButtonSiguienteActionPerformed

    private void jButtonCancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelarActionPerformed
        
        this.dispose();
        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_jButtonCancelarActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancelar;
    private javax.swing.JButton jButtonSiguiente;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTable jTableCats;
    // End of variables declaration//GEN-END:variables
}
