/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package GUI;

import GUILogica.Panel;
import Datatypes.DataPerfil;
import Fabricas.Factory;
import Interfaces.IPerfil;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author chonabook
 */
public class JIFConsultaPerfil extends javax.swing.JInternalFrame {

    /**
     * Creates new form JIFConsultaPerfil
     */
    
    private Factory f = null;
    private IPerfil ip = null;
    private Panel p = null;
    
    public JIFConsultaPerfil(Factory f) throws Exception{
        
        this.f = f;
        this.ip = f.getIPerfil();
        initComponents();
    }
    
    private void centrarVentana(){
        
        Dimension desktopSize = JIFInicial.getDPInicioDimension();
        Dimension jInternalFrameSize = this.getSize();
        this.setLocation((desktopSize.width - jInternalFrameSize.width)/2,
                                   (desktopSize.height- jInternalFrameSize.height)/2);
        //setLocation(55, 55);
        
    }
    
    public void bloquearComponentes(){
    
        jBtnMostrar.setEnabled(!jBtnMostrar.isEnabled());
        jTblDataPerfil.setEnabled(!isEnabled());
    
    }
    
    public void vaciarjTblDataPerfil(){
    
        DefaultTableModel m = (DefaultTableModel) jTblDataPerfil.getModel();
        int filas= jTblDataPerfil.getRowCount();
	for (int i = 0; i < filas; i++) {
            m.removeRow(0);
	}        
    
    }
    
    public void cargarPerfiles()throws Exception{
    
        List<String> listaP = ip.listarPerfiles();
        DefaultTableModel tm = (DefaultTableModel) jTblPerfiles.getModel();
        int rows = 0;
        
        for (String j : listaP) {

            tm.addRow(new Object[rows]);
            tm.setValueAt(j, rows, 0);
            rows++;
        }
        
        this.jTblPerfiles.setModel(tm);
    
    }  
    
    public void cargarDataPerfil(){
        
        try {
            
            int row = jTblPerfiles.getSelectedRow();
            String nick = (String) jTblPerfiles.getValueAt(row, 0);
            DataPerfil dp = ip.obtenerPerfil(nick, false);
            
            //Cargar los datos del perfil en la jTDataPerfil
            DefaultTableModel tm = (DefaultTableModel) jTblDataPerfil.getModel();
       
            int rows = 0;
            tm.addRow(new Object[rows]);
            tm.setValueAt("Nick:", rows, 0);
            tm.setValueAt(dp.getNick(), rows, 1);
            rows++;
            tm.addRow(new Object[rows]);
            tm.setValueAt("Nombre:", rows, 0);
            tm.setValueAt(dp.getNombre(), rows, 1);
            rows++;
            tm.addRow(new Object[rows]);
            tm.setValueAt("Apellido:", rows, 0);
            tm.setValueAt(dp.getApellido(), rows, 1);
            rows++;
            tm.addRow(new Object[rows]);
            tm.setValueAt("Fecha Nacimiento:", rows, 0);
            tm.setValueAt(dp.getFechaNac().getString(), rows, 1);
            rows++;
            tm.addRow(new Object[rows]);
            tm.setValueAt("Edad:", rows, 0);
            tm.setValueAt(dp.getEdad(), rows, 1);
            rows++;
            tm.addRow(new Object[rows]);
            tm.setValueAt("E-mail:", rows, 0);
            tm.setValueAt(dp.getCorreo(), rows, 1);
            rows++;
            if(dp.getSitioWeb() != null){
                
                tm.addRow(new Object[rows]);
                tm.setValueAt("Sitio Web:", rows, 0);
                tm.setValueAt(dp.getSitioWeb(), rows, 1);
                rows++;
                
            }
            /*tm.addRow(new Object[rows]);
            tm.setValueAt("Imagen:", rows, 0);
            tm.setValueAt(dp.getImagen(), rows, 1);
            rows++;*/            
        
            this.jTblDataPerfil.setModel(tm);   
            
            //Cargo Imagen
            try{
                
                String dirservidor = JIFInicial.getInstance().getDirServidor();
                File imagen = new File(dirservidor + "/" + dp.getImagen());
                               
                if(p == null){
                
                    p = new Panel(imagen);
                    p.setSize(jPImagen.getSize());
                    jPImagen.add(p);
                    jPImagen.repaint();
                    
                }else{
                
                    p.cargarImagen(imagen);
                    jPImagen.repaint();
                
                }
                
            }
            
            catch(Exception e){
            
                JOptionPane.showMessageDialog(this, "No se encontro la imágen!", "Error!", JOptionPane.ERROR_MESSAGE);
                        
            }
            
        }
        
        catch (Exception e) {
            
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE);
            
        }
    
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jBtnCancelar = new javax.swing.JButton();
        jBtnMostrar = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTblPerfiles = new javax.swing.JTable();
        jSeparator1 = new javax.swing.JSeparator();
        jPImagen = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTblDataPerfil = new javax.swing.JTable();

        setClosable(true);
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
        });

        jBtnCancelar.setText("Cancelar");
        jBtnCancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnCancelarActionPerformed(evt);
            }
        });

        jBtnMostrar.setText("Mostrar");
        jBtnMostrar.setToolTipText("");
        jBtnMostrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnMostrarActionPerformed(evt);
            }
        });

        jTblPerfiles.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "<html><b>Nick</b></html>"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTblPerfiles.setToolTipText("Lista de todos los nick del sistema.");
        jTblPerfiles.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jTblPerfiles.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTblPerfilesMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(jTblPerfiles);

        jPImagen.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0), 2, true));
        jPImagen.setEnabled(false);

        javax.swing.GroupLayout jPImagenLayout = new javax.swing.GroupLayout(jPImagen);
        jPImagen.setLayout(jPImagenLayout);
        jPImagenLayout.setHorizontalGroup(
            jPImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 135, Short.MAX_VALUE)
        );
        jPImagenLayout.setVerticalGroup(
            jPImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 176, Short.MAX_VALUE)
        );

        jScrollPane2.setAutoscrolls(true);

        jTblDataPerfil.setFont(new java.awt.Font("Ubuntu", 1, 14)); // NOI18N
        jTblDataPerfil.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "<html><b>Datos Personales</b></html>", "<html><b>Descripcion</b><html>"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTblDataPerfil.setToolTipText("Tabla para cargar los datos del perfil.");
        jTblDataPerfil.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(jTblDataPerfil);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSeparator1)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 550, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 307, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jBtnCancelar, javax.swing.GroupLayout.DEFAULT_SIZE, 92, Short.MAX_VALUE)
                            .addComponent(jBtnMostrar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPImagen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPImagen, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(48, 48, 48)
                        .addComponent(jBtnMostrar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jBtnCancelar)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 147, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBtnCancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnCancelarActionPerformed

        this.dispose();
        JIFInicial.BloquearJFInicial();

    }//GEN-LAST:event_jBtnCancelarActionPerformed

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing

        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_formInternalFrameClosing

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened

        try{
        
            bloquearComponentes();
            cargarPerfiles();
            centrarVentana();

        }
            
        catch (Exception e) {
            
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE);
            
        }
        
    }//GEN-LAST:event_formInternalFrameOpened

    private void jTblPerfilesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTblPerfilesMouseClicked

        jBtnMostrar.setEnabled(true);
        
    }//GEN-LAST:event_jTblPerfilesMouseClicked

    private void jBtnMostrarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnMostrarActionPerformed

        vaciarjTblDataPerfil();
        cargarDataPerfil();
        
    }//GEN-LAST:event_jBtnMostrarActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnCancelar;
    private javax.swing.JButton jBtnMostrar;
    private javax.swing.JPanel jPImagen;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTable jTblDataPerfil;
    private javax.swing.JTable jTblPerfiles;
    // End of variables declaration//GEN-END:variables
}
