/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package GUI;

import Datatypes.ArbolComentarios;
import Datatypes.DataComentario;
import java.awt.Dimension;
import Datatypes.DataJuego;
import Datatypes.DataPerfil;
import Datatypes.Nodo;
import Datatypes.NodoRoot;
import Fabricas.Factory;
import Interfaces.IComentario;
import Interfaces.IJuego;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author chonabook
 */
public class JIFDatosJuego extends javax.swing.JInternalFrame {

    private Factory f = null;
    private IJuego ij = null;
    private IComentario ic = null;
    private DataJuego djuego = null;
    private List<DataComentario> lcomentarios = null;
    
    public JIFDatosJuego(Factory f, DataJuego dj) throws Exception{
        
        this.f = f;
        this.djuego = dj;
        this.ij = f.getIJuego();
        this.ic = f.getIComentario();
        
        initComponents();
        cargarArbol();
        
    }
    
    private void centrarVentana(){
        
        Dimension desktopSize = JIFInicial.getDPInicioDimension();
        Dimension jInternalFrameSize = this.getSize();
        this.setLocation((desktopSize.width - jInternalFrameSize.width)/2,
                                   (desktopSize.height- jInternalFrameSize.height)/2);
        
    }
    
    private void cargarArbol(){
    
        try{
        
            lcomentarios = ic.listarComentarios(djuego.getNombre());
            NodoRoot nr = new NodoRoot();
            ArbolComentarios ac = new ArbolComentarios(nr);
            ac.prepareData(lcomentarios);
            JT_ArbolDeComentarios.setModel(ac.getModelo());
            
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
    
    }
    
    public void cargarDataJuego()throws Exception{
    
        jTFNombre.setText(djuego.getNombre());
        jTFDesarrollador.setText(djuego.getDesarrollador());
        jTADesc.setText(djuego.getDescripcion());
        jTFTamanio.setText(djuego.getSize().toString());
        jTFPrecio.setText(djuego.getPrecio().toString());
        
        List<String> listaJ = djuego.getCategorias();
        DefaultTableModel tm = (DefaultTableModel) jTblCategorias.getModel();
        int rows = 0;
        
        for (String dj : listaJ) {

            tm.addRow(new Object[rows]);
            tm.setValueAt(dj, rows, 0);
            rows++;
        }
        
        this.jTblCategorias.setModel(tm);  
        
        List<DataPerfil> listaP = ij.getClientesCompranJuego(djuego.getCodigo());
        DefaultTableModel tmCli = (DefaultTableModel) jTblClientes.getModel();
        rows = 0;
        
        for (DataPerfil dp : listaP) {

            tmCli.addRow(new Object[rows]);
            tmCli.setValueAt(dp.getNick()+" - "+dp.getNombre()+ " " +dp.getApellido() , rows, 0);
            rows++;
        }
        
        this.jTblClientes.setModel(tmCli);
        
    }
    
    public void setReadOnlyDataPerfil(){
    
        jTADesc.setEditable(false);
        jTFDesarrollador.setEditable(false);
        jTFNombre.setEditable(false);
        jTFTamanio.setEditable(false);
        jTADesc.setEditable(false);
        jTFPrecio.setEditable(false);
    
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLblNombre = new javax.swing.JLabel();
        jTFNombre = new javax.swing.JTextField();
        jLblDescripcion = new javax.swing.JLabel();
        jLblTamanio = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTADesc = new javax.swing.JTextArea();
        jTFTamanio = new javax.swing.JTextField();
        jLblDesarrollador = new javax.swing.JLabel();
        jTFDesarrollador = new javax.swing.JTextField();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTblCategorias = new javax.swing.JTable();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTblClientes = new javax.swing.JTable();
        jScrollPane4 = new javax.swing.JScrollPane();
        JT_ArbolDeComentarios = new javax.swing.JTree();
        jLblComentarios = new javax.swing.JLabel();
        jBtnAceptar = new javax.swing.JButton();
        jLblPrecio = new javax.swing.JLabel();
        jTFPrecio = new javax.swing.JTextField();
        jScrollPane5 = new javax.swing.JScrollPane();
        JTA_Comentario = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        btnVersiones = new javax.swing.JButton();

        setClosable(true);
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
        });

        jLblNombre.setText("Nombre:");

        jLblDescripcion.setText("Descripcion:");

        jLblTamanio.setText("Tamaño (KB):");

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setAutoscrolls(true);

        jTADesc.setEditable(false);
        jTADesc.setColumns(20);
        jTADesc.setLineWrap(true);
        jTADesc.setRows(5);
        jScrollPane1.setViewportView(jTADesc);

        jLblDesarrollador.setText("Desarrollador:");

        jTblCategorias.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "<html><b>Categorias</b><html>"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTblCategorias.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(jTblCategorias);

        jTblClientes.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "<html><b>Clientes</b><html>"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane3.setViewportView(jTblClientes);

        JT_ArbolDeComentarios.setRootVisible(false);
        JT_ArbolDeComentarios.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                JT_ArbolDeComentariosValueChanged(evt);
            }
        });
        jScrollPane4.setViewportView(JT_ArbolDeComentarios);

        jLblComentarios.setText("Comentarios:");

        jBtnAceptar.setText("Aceptar");
        jBtnAceptar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAceptarActionPerformed(evt);
            }
        });

        jLblPrecio.setText("Precio (US$):");

        JTA_Comentario.setEditable(false);
        JTA_Comentario.setColumns(20);
        JTA_Comentario.setRows(5);
        jScrollPane5.setViewportView(JTA_Comentario);

        jLabel1.setText("Comentario Selecionado:");

        btnVersiones.setText("Versiones");
        btnVersiones.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnVersionesActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jScrollPane4)
                            .addComponent(jScrollPane1)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(jLblTamanio, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(jTFTamanio, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(jLblPrecio, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(jTFPrecio, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jLblDesarrollador)
                                        .addGap(0, 0, Short.MAX_VALUE))
                                    .addComponent(jTFDesarrollador)))
                            .addComponent(jScrollPane5)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addGroup(layout.createSequentialGroup()
                                            .addComponent(jLblNombre)
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(jTFNombre, javax.swing.GroupLayout.PREFERRED_SIZE, 450, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGroup(layout.createSequentialGroup()
                                            .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 247, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGap(18, 18, 18)
                                            .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)))
                                    .addComponent(jLblComentarios)
                                    .addComponent(jLblDescripcion))
                                .addGap(0, 0, Short.MAX_VALUE))))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel1)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addGap(178, 178, 178)
                .addComponent(jBtnAceptar, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnVersiones)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblNombre)
                    .addComponent(jTFNombre, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLblDescripcion)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLblTamanio)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTFTamanio, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLblPrecio)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jTFPrecio, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTFDesarrollador, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jLblDesarrollador))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLblComentarios)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 138, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jBtnAceptar)
                    .addComponent(btnVersiones))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing

        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_formInternalFrameClosing

    private void jBtnAceptarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAceptarActionPerformed

        this.dispose();
        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_jBtnAceptarActionPerformed

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened

        try{
        
            cargarDataJuego();
            setReadOnlyDataPerfil();
            centrarVentana();
        
        }
            
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_formInternalFrameOpened

    private void JT_ArbolDeComentariosValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_JT_ArbolDeComentariosValueChanged

        if(evt.getNewLeadSelectionPath() != null){
        
            Nodo n = (Nodo)evt.getNewLeadSelectionPath().getLastPathComponent();

            Integer numero = (Integer)n.getValor();

            Iterator<DataComentario> itc = lcomentarios.iterator();

            DataComentario dc = null;

            while(itc.hasNext() && (dc == null)){

                DataComentario temp = itc.next();
                if(temp.getNumero() == numero){

                    dc = temp;

                }

            }

            if(dc != null){

                JTA_Comentario.setText(dc.getTexto());

            }
            
        }

    }//GEN-LAST:event_JT_ArbolDeComentariosValueChanged

    private void btnVersionesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnVersionesActionPerformed
        
        try{
            
            //this.dispose();
            JIFInicial.BloquearJFInicial(); 

            JIFVersionesJuego JIFVersionesJuego = new JIFVersionesJuego(this.f, djuego);
            JIFInicial.getJIFInicialjDP().add(JIFVersionesJuego);
            JIFInicial.getJIFInicio().setTitle("Versiones Aprobadas del Juego.");
            JIFVersionesJuego.show();

            JIFInicial.BloquearJFInicial();            
        
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }        
    }//GEN-LAST:event_btnVersionesActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea JTA_Comentario;
    private javax.swing.JTree JT_ArbolDeComentarios;
    private javax.swing.JButton btnVersiones;
    private javax.swing.JButton jBtnAceptar;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLblComentarios;
    private javax.swing.JLabel jLblDesarrollador;
    private javax.swing.JLabel jLblDescripcion;
    private javax.swing.JLabel jLblNombre;
    private javax.swing.JLabel jLblPrecio;
    private javax.swing.JLabel jLblTamanio;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JTextArea jTADesc;
    private javax.swing.JTextField jTFDesarrollador;
    private javax.swing.JTextField jTFNombre;
    private javax.swing.JTextField jTFPrecio;
    private javax.swing.JTextField jTFTamanio;
    private javax.swing.JTable jTblCategorias;
    private javax.swing.JTable jTblClientes;
    // End of variables declaration//GEN-END:variables
}
