package GUI;

import Datatypes.ArbolComentarios;
import Datatypes.DataComentario;
import Datatypes.Nodo;
import Datatypes.NodoRoot;
import Datatypes.PDate;
import Fabricas.Factory;
import Interfaces.IComentario;
import java.awt.Dimension;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class JIFIngresarComentario extends javax.swing.JInternalFrame {

    private IComentario ic = null;
    private List<DataComentario> lcomentarios = null;
    private Boolean res = false;
    private Integer npadre = null;
    private DataComentario celegido = null;
    
    public JIFIngresarComentario(Factory f) throws Exception{
        
        this.ic = f.getIComentario();
        initComponents();
        cargarJuegos();
        cargarClientes();
        configurarCalendario();
            
    }
    
    private void cargarJuegos() throws Exception{
    
        List<String> listaj = ic.listarNomJuegos();
        Iterator<String> itj = listaj.iterator();
    
        while(itj.hasNext()){
        
            JCB_Juego.addItem(itj.next());
        
        }
        
    }
    
    private void cargarClientes()throws Exception{
    
        List<String> listac = ic.listarNomClientes();
        Iterator<String> itc = listac.iterator();
    
        while(itc.hasNext()){
        
            JCB_Cliente.addItem(itc.next());
        
        }
        
    }
    
    private void cargarArbolDeComentarios() throws Exception{
    
        lcomentarios = ic.listarComentarios((String)JCB_Juego.getSelectedItem());
        NodoRoot root = new NodoRoot();
        ArbolComentarios a = new ArbolComentarios(root);
        a.prepareData(lcomentarios);
        JT_Comentarios.setModel(a.getModelo());
    
    }
    
    private void centrarVentana(){
        
        Dimension desktopSize = JIFInicial.getDPInicioDimension();
        Dimension jInternalFrameSize = this.getSize();
        this.setLocation((desktopSize.width - jInternalFrameSize.width)/2,
                                   (desktopSize.height- jInternalFrameSize.height)/2);
        
    }
    
    private void configurarCalendario(){
    
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());

        Integer año = gc.get(GregorianCalendar.YEAR);
        año = año - 120;
        gc.set(GregorianCalendar.YEAR, año);
        Date min = gc.getTime();

        gc.setTime(new Date());
        año = gc.get(GregorianCalendar.YEAR);
        gc.set(GregorianCalendar.YEAR, año);
        Date max = gc.getTime();

        JDC_Fecha.setSelectableDateRange(min, max);
        JDC_Fecha.setDate(max);
        
        gc.setTime(new Date());

        JS_Hora.setValue(gc.get(GregorianCalendar.HOUR));
        JS_Minutos.setValue(gc.get(GregorianCalendar.MINUTE));
        JS_Segundos.setValue(gc.get(GregorianCalendar.SECOND));

        JS_Hora.setEnabled(!JS_Hora.isEnabled());
        JS_Minutos.setEnabled(!JS_Minutos.isEnabled());
        JS_Segundos.setEnabled(!JS_Segundos.isEnabled());
            
    }
    
    private DataComentario prepareData(){
    
        String texto = JTA_Comentario.getText();
        
        Integer dia = JDC_Fecha.getCalendar().get(GregorianCalendar.DATE);
        Integer mes = JDC_Fecha.getCalendar().get(GregorianCalendar.MONTH);
        Integer año = JDC_Fecha.getCalendar().get(GregorianCalendar.YEAR);
        Integer hora = (Integer)JS_Hora.getValue();
        Integer segundos = (Integer)JS_Segundos.getValue();
        Integer minutos = (Integer)JS_Minutos.getValue();
        PDate fecha = new PDate(dia, mes + 1, año, hora, minutos, segundos);
    
        String nick = (String)JCB_Cliente.getSelectedItem();
        String nomjuego = (String)JCB_Juego.getSelectedItem();
        
        DataComentario dc = new DataComentario(null, texto, fecha, nick, nomjuego, res, npadre);
        
        return dc;
        
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLblNombre = new javax.swing.JLabel();
        JCB_Juego = new javax.swing.JComboBox();
        jSepIngComentario = new javax.swing.JSeparator();
        jScrollPane1 = new javax.swing.JScrollPane();
        JT_Comentarios = new javax.swing.JTree();
        jLblCliente = new javax.swing.JLabel();
        JCB_Cliente = new javax.swing.JComboBox();
        jLblFecha = new javax.swing.JLabel();
        jLblComentario = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        JTA_Comentario = new javax.swing.JTextArea();
        JB_Enviar = new javax.swing.JButton();
        JB_Cancelar = new javax.swing.JButton();
        JDC_Fecha = new com.toedter.calendar.JDateChooser();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        JTA_Seleccion = new javax.swing.JTextArea();
        JCB_Respuesta = new javax.swing.JCheckBox();
        jSepIngComentario1 = new javax.swing.JSeparator();
        jLabel2 = new javax.swing.JLabel();
        JCB_HoraActual = new javax.swing.JCheckBox();
        JS_Hora = new javax.swing.JSpinner();
        JS_Minutos = new javax.swing.JSpinner();
        JS_Segundos = new javax.swing.JSpinner();

        setClosable(true);
        setToolTipText("");
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
        });

        jLblNombre.setText("Juego:");

        JCB_Juego.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JCB_JuegoActionPerformed(evt);
            }
        });

        JT_Comentarios.setRootVisible(false);
        JT_Comentarios.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
            public void valueChanged(javax.swing.event.TreeSelectionEvent evt) {
                JT_ComentariosValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(JT_Comentarios);

        jLblCliente.setText("Cliente:");

        jLblFecha.setText("Fecha:");

        jLblComentario.setText("Comentario:");

        JTA_Comentario.setColumns(20);
        JTA_Comentario.setRows(5);
        JTA_Comentario.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                JTA_ComentarioKeyPressed(evt);
            }
        });
        jScrollPane2.setViewportView(JTA_Comentario);

        JB_Enviar.setText("Enviar");
        JB_Enviar.setEnabled(false);
        JB_Enviar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_EnviarActionPerformed(evt);
            }
        });

        JB_Cancelar.setText("Cancelar");
        JB_Cancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_CancelarActionPerformed(evt);
            }
        });

        jLabel1.setText("Comentario Seleccionado:");

        JTA_Seleccion.setEditable(false);
        JTA_Seleccion.setBackground(new java.awt.Color(254, 254, 254));
        JTA_Seleccion.setColumns(20);
        JTA_Seleccion.setForeground(new java.awt.Color(1, 1, 1));
        JTA_Seleccion.setRows(5);
        jScrollPane4.setViewportView(JTA_Seleccion);

        JCB_Respuesta.setText("Respuesta?");
        JCB_Respuesta.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JCB_RespuestaActionPerformed(evt);
            }
        });

        jLabel2.setText("Hora (hh:mm:ss):");

        JCB_HoraActual.setSelected(true);
        JCB_HoraActual.setText("Hora Actual?");
        JCB_HoraActual.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JCB_HoraActualActionPerformed(evt);
            }
        });

        JS_Hora.setModel(new javax.swing.SpinnerNumberModel(0, 0, 24, 1));

        JS_Minutos.setModel(new javax.swing.SpinnerNumberModel(0, 0, 60, 1));

        JS_Segundos.setModel(new javax.swing.SpinnerNumberModel(0, 0, 60, 1));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane4)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLblNombre)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(JCB_Juego, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jSepIngComentario)
                    .addComponent(jScrollPane2)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLblComentario)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(JCB_Respuesta))
                    .addComponent(jSepIngComentario1, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLblCliente))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(JCB_Cliente, javax.swing.GroupLayout.PREFERRED_SIZE, 333, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(JDC_Fecha, javax.swing.GroupLayout.PREFERRED_SIZE, 170, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLblFecha))
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(20, 20, 20)
                                        .addComponent(jLabel2))
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(18, 18, 18)
                                        .addComponent(JS_Hora, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(JS_Minutos, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(JS_Segundos, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(JCB_HoraActual)))))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(JB_Cancelar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(JB_Enviar, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(22, 22, 22)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblNombre)
                    .addComponent(JCB_Juego, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jSepIngComentario, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 185, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane4, javax.swing.GroupLayout.PREFERRED_SIZE, 79, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jSepIngComentario1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblComentario)
                    .addComponent(JCB_Respuesta))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(JS_Hora, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(JS_Minutos, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(JS_Segundos, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(JCB_HoraActual))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLblCliente)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(JCB_Cliente, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLblFecha)
                            .addComponent(jLabel2))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(JDC_Fecha, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(JB_Enviar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(JB_Cancelar)))
                .addContainerGap(25, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void JB_CancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_CancelarActionPerformed

        this.dispose();
        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_JB_CancelarActionPerformed

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing

        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_formInternalFrameClosing

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened

        centrarVentana();
        
    }//GEN-LAST:event_formInternalFrameOpened

    private void JCB_JuegoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JCB_JuegoActionPerformed

        try{
        
            cargarArbolDeComentarios();

        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
            
    }//GEN-LAST:event_JCB_JuegoActionPerformed

    private void JB_EnviarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_EnviarActionPerformed
        
        DataComentario dc = prepareData();
        
        String texto = dc.getTexto();
        PDate fecha = dc.getFecha();
        String nick = dc.getCliente();
        String juego = dc.getJuego();
        Boolean respuesta = dc.esRespuesta();
        Integer numpadre = dc.getNumpadre();
        
        Integer opcion;
        
        String mensaje = new String();
        String temp = "<html><b>Los siguientes datos serán ingresados:<br><br>";
        mensaje = mensaje.concat(temp);
        
        temp = "Texto: " + texto + "<br>";
        mensaje = mensaje.concat(temp);
        
        temp = "Fecha: " + fecha.getString() + "<br>";
        mensaje = mensaje.concat(temp);
        
        temp = "Nick: " + nick + "<br>";
        mensaje = mensaje.concat(temp);
            
        temp = "Juego: " + juego + "<br>";
        mensaje = mensaje.concat(temp);
        
        if(respuesta == true){
        
            temp = "Numero del comentario a responder: " + numpadre + "<br>";
            mensaje = mensaje.concat(temp);
        
        }
        
        temp = "<br>Desea confirmar?</b></html>";
        mensaje = mensaje.concat(temp);
        
        opcion = JOptionPane.showConfirmDialog(this, mensaje, "Confirmación", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, frameIcon);
        
        if(opcion == 0){
        
            try{
            
                if(respuesta){
                
                    ic.responderComentario(dc);
                
                }
                
                else{
                
                    ic.realizarComentario(dc);
                
                }
               
                this.dispose();
                JOptionPane.showMessageDialog(this, "La operación se realizó con exito!", "Mensaje", JOptionPane.INFORMATION_MESSAGE, null);
                JIFInicial.BloquearJFInicial();
                
            }
            
            catch(Exception e){
        
                JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);

            }
        
        }
        
    }//GEN-LAST:event_JB_EnviarActionPerformed

    private void JTA_ComentarioKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTA_ComentarioKeyPressed

        if(JTA_Comentario.getText().length() > 0){

            JB_Enviar.setEnabled(true);

        }
        
        else{
        
            JB_Enviar.setEnabled(false);
        
        }
        
    }//GEN-LAST:event_JTA_ComentarioKeyPressed

    private void JT_ComentariosValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_JT_ComentariosValueChanged

        if(evt.getNewLeadSelectionPath() != null){
        
            Nodo n = (Nodo)evt.getNewLeadSelectionPath().getLastPathComponent();

            Integer numero = (Integer)n.getValor();

            Iterator<DataComentario> itc = lcomentarios.iterator();

            DataComentario dc = null;

            while(itc.hasNext() && (dc == null)){

                DataComentario temp = itc.next();
                if(temp.getNumero() == numero){

                    dc = temp;

                }

            }

            if(dc != null){

                celegido = dc;
                JTA_Seleccion.setText(dc.getTexto());

            }
            
        }
            
    }//GEN-LAST:event_JT_ComentariosValueChanged

    private void JCB_RespuestaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JCB_RespuestaActionPerformed
               
        res = JCB_Respuesta.isSelected();
        
        if(res == true){
        
            npadre = celegido.getNumero();
        
        }
        
        else{
        
            npadre = null;
        
        }
        
    }//GEN-LAST:event_JCB_RespuestaActionPerformed

    private void JCB_HoraActualActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JCB_HoraActualActionPerformed

        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());
        
        JS_Hora.setValue(gc.get(GregorianCalendar.HOUR));
        JS_Minutos.setValue(gc.get(GregorianCalendar.MINUTE));
        JS_Segundos.setValue(gc.get(GregorianCalendar.SECOND));
        
        JS_Hora.setEnabled(!JS_Hora.isEnabled());
        JS_Minutos.setEnabled(!JS_Minutos.isEnabled());
        JS_Segundos.setEnabled(!JS_Segundos.isEnabled());

    }//GEN-LAST:event_JCB_HoraActualActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton JB_Cancelar;
    private javax.swing.JButton JB_Enviar;
    private javax.swing.JComboBox JCB_Cliente;
    private javax.swing.JCheckBox JCB_HoraActual;
    private javax.swing.JComboBox JCB_Juego;
    private javax.swing.JCheckBox JCB_Respuesta;
    private com.toedter.calendar.JDateChooser JDC_Fecha;
    private javax.swing.JSpinner JS_Hora;
    private javax.swing.JSpinner JS_Minutos;
    private javax.swing.JSpinner JS_Segundos;
    private javax.swing.JTextArea JTA_Comentario;
    private javax.swing.JTextArea JTA_Seleccion;
    private javax.swing.JTree JT_Comentarios;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLblCliente;
    private javax.swing.JLabel jLblComentario;
    private javax.swing.JLabel jLblFecha;
    private javax.swing.JLabel jLblNombre;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JSeparator jSepIngComentario;
    private javax.swing.JSeparator jSepIngComentario1;
    // End of variables declaration//GEN-END:variables
}
