package GUI;

import GUILogica.Panel;
import Datatypes.DataPerfil;
import Datatypes.MD5;
import Datatypes.PDate;
import Fabricas.Factory;
import Interfaces.IPerfil;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JIFModificarPerfil extends javax.swing.JInternalFrame{

    private Factory f = null;
    private IPerfil ip = null;
    private File imagen = null;
    private String path = null;
    private Panel pi = null;
    private DataPerfil pviejo = null;
    private String cnueva = null;
    
    public JIFModificarPerfil(Factory f) throws Exception{
        
        this.f = f;
        ip = f.getIPerfil();
        initComponents();
        configurarCalendario();
        cargarInicio();
        
    }
    
    public void escribirImagen(File archivo, String path) throws Exception{
    
        try{
            
            String nombreImg = path.substring(path.lastIndexOf("/") + 1, path.length());
            path = path.substring(0, path.lastIndexOf("/") + 1);
            String dirservidor = JIFInicial.getInstance().getDirServidor();
            File directorio = new File(dirservidor + "/" + path);
            directorio.mkdirs();
            File img = new File(directorio, nombreImg);
            InputStream in;
            in = new FileInputStream(archivo);
            OutputStream out;
            out = new FileOutputStream(img);
                                
            byte[] buf = new byte[1024];
            int len;
            while ((len = in.read(buf)) > 0){
                
                out.write(buf, 0, len);
            
            }

            in.close();
            out.close();
    
        }
        
        catch(Exception e){
        
            throw new Exception(e.getMessage());
        
        }
        
    }
    
    private void cargarInicio()throws Exception{
    
        JD_ElegirPerfil.setSize(400, 100);
        JD_ElegirPerfil.setLocationRelativeTo(this);
        
        List<String> listap = ip.listarPerfiles();
        Iterator<String> itp = listap.iterator();
        
        while(itp.hasNext()){
        
            String nick = itp.next();
            JCB_Perfil.addItem(nick);
        
        }
        
        JD_ElegirPerfil.setVisible(true);
        deshabilitarComponentes();
    
    }
    
    private void configurarCalendario(){
    
       GregorianCalendar gc = new GregorianCalendar();
       gc.setTime(new Date());
       
       Integer año = gc.get(GregorianCalendar.YEAR);
       año = año - 120;
       gc.set(GregorianCalendar.YEAR, año);
       Date min = gc.getTime();
       
       gc.setTime(new Date());
       año = gc.get(GregorianCalendar.YEAR);
       año = año - 18;
       gc.set(GregorianCalendar.YEAR, año);
       Date max = gc.getTime();
       
       JDC_Fecha.setSelectableDateRange(min, max);
       JDC_Fecha.setDate(max);
            
    }
    
    private void bloquearContraseña(){
    
        JPF_Actual.setText(null);
        JPF_Nueva.setText(null);
        JPF_Confirmar.setText(null);
        JL_Nivel.setBorder(null);
        JL_Confirmar.setBorder(null);
        
        JL_Actual.setEnabled(true);
        JPF_Actual.setEnabled(true);
        JPF_Nueva.setEnabled(false);
        JPF_Confirmar.setEnabled(false);
        JL_Nueva.setEnabled(false);
        JL_Confirm.setEnabled(false);
        JB_AceptarPassword.setEnabled(false);
        JB_ComprobarPassword.setEnabled(false);
    
    }
    
    public void habilitarModificarBtn(){
    
        if(pviejo.getTipoPerfil().equals("[CLIENTE]")){
        
            if((JTF_Nombre.getText().length() > 0) && (JTF_Apellido.getText().length() > 0) && (path != null) &&
               (JTF_Nick.getText().length() > 0) && (JTF_Email.getText().contains("@") && (JTF_Email.getText().contains(".")))){

                JB_Modificar.setEnabled(true);

            }
            
            else{
            
                JB_Modificar.setEnabled(false);
            
            }
            
        }
        
        else{
        
            if((JTF_Nombre.getText().length() > 0) && (JTF_Apellido.getText().length() > 0) && (JTF_Web.getText().length() > 0) && (path != null)
               && (JTF_Nick.getText().length() > 0) && (JTF_Email.getText().contains("@") && (JTF_Email.getText().contains(".")))){

                JB_Modificar.setEnabled(true);

            }
            
            else{
            
                JB_Modificar.setEnabled(false);
            
            }
        
        }
        
    }
    
    private void centrarVentana(){
        
        Dimension desktopSize = JIFInicial.getDPInicioDimension();
        Dimension jInternalFrameSize = this.getSize();
        this.setLocation((desktopSize.width - jInternalFrameSize.width)/2,
                                   (desktopSize.height- jInternalFrameSize.height)/2);
        
    }
    
    public void componentesCliente(){
    
        JTF_Nick.setEnabled(true);
        JTF_Email.setEnabled(true);
        JTF_Nombre.setEnabled(true);
        JTF_Apellido.setEnabled(true);
        JB_Cambiar.setEnabled(true);
        JB_Cancelar.setEnabled(true);
        JDC_Fecha.setEnabled(true);
        JB_CambiarContraseña.setEnabled(true);
    
    }
    
    private Integer nivelSeguridad(char password[]){
    
        Integer nivel = 0;
        
        Integer largo = password.length;
        Boolean cletras = false;
        Boolean cnumeros = false;
        Boolean cmayusculas = false;
        
        for(int i = 0; i < largo; i++){
        
            Character c = password[i];
            
            if((c > 47) && (c < 58)){
            
                cnumeros = true;
            
            }
        
            if((c < 48) || (c > 57)){
            
                cletras = true;
            
            }
            
            if(Character.isUpperCase(c)){
            
                cmayusculas = true;
            
            }
                       
        }
        
        if(largo < 8){
        
            nivel = 0;
        
        }
        
        else if((largo >= 8) && (largo < 10)){
        
            if((cmayusculas == true) && (cnumeros == true) && (cletras == false)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == false) && (cletras == true)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == false) && (cletras == true)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == true) && (cletras == false)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == true) && (cletras == true)){
            
                nivel = 2;
            
            }
            
        }
        
        else if(largo >= 10){
        
            if((cmayusculas == true) && (cnumeros == true) && (cletras == false)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == false) && (cletras == true)){
            
                nivel = 2;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == false) && (cletras == true)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == true) && (cletras == false)){
            
                nivel = 1;
            
            }
            
            else if((cmayusculas == true) && (cnumeros == true) && (cletras == true)){
            
                nivel = 3;
            
            }
            
            else if((cmayusculas == false) && (cnumeros == true) && (cletras == true)){
            
                nivel = 2;
            
            }
            
        }
        
        return nivel;
    
    }
    
    public void componentesDesarrollador(){
    
        componentesCliente();
        JTF_Web.setEnabled(true);
    
    }
    
    public void deshabilitarComponentes(){
        
        JB_Modificar.setEnabled(false);
        JB_Cambiar.setEnabled(false);
        JTF_Nombre.setEnabled(false);
        JTF_Apellido.setEnabled(false);
        JTF_Web.setEnabled(false);
        JTF_Nick.setEnabled(false);
        JTF_Email.setEnabled(false);
        JB_Cancelar.setEnabled(false);
        JDC_Fecha.setEnabled(false);
        JB_CambiarContraseña.setEnabled(false);
    
    }
    
    public void componentesModificar(){
            
        if(pviejo.getTipoPerfil().equals("[CLIENTE]")){
        
            componentesCliente();
            JB_Modificar.setEnabled(true);
            JTF_Nick.setEnabled(true);
            JTF_Email.setEnabled(true);
        
        }
        
        else{
        
            componentesDesarrollador();
            JB_Modificar.setEnabled(true);
            JTF_Nick.setEnabled(true);
            JTF_Email.setEnabled(true);
        
        }
        
        JB_CambiarContraseña.setEnabled(true);
    
    }
    
    private DataPerfil prepareData(){
    
        DataPerfil perfil;
        
        String password;
        
        if(cnueva != null){
        
            password = cnueva;
        
        }
        
        else{
        
            password = pviejo.getPassWord();
        
        }
        
        MD5 encriptar = new MD5();
        
        try{
        
            password = encriptar.md5(password);
        
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>Error de conversión MD5<br>Mensaje de error: " + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
                    
        }
        
        String nick = JTF_Nick.getText();
        String email = JTF_Email.getText();
        String tipoperfil = pviejo.getTipoPerfil();
        String sitioweb = null;
        
        String nombre = JTF_Nombre.getText();
        String apellido = JTF_Apellido.getText();
        
        Integer dia = JDC_Fecha.getCalendar().get(GregorianCalendar.DATE);
        Integer mes = JDC_Fecha.getCalendar().get(GregorianCalendar.MONTH);
        mes++;
        Integer año = JDC_Fecha.getCalendar().get(GregorianCalendar.YEAR);
        PDate fechanac = new PDate(dia, mes, año);
        
        String imgperfil;
        
        if(pviejo.getTipoPerfil().equals("[DESARROLLADOR]")){
        
            imgperfil = "Data/Perfiles/Desarrolladores/" + nick + "/Imagen_Perfil/IMGP_" + nick;
            sitioweb = JTF_Web.getText();
        
        }
        
        else{
        
            imgperfil = "Data/Perfiles/Clientes/" + nick + "/Imagen_Perfil/IMGP_" + nick;
        
        }
                        
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());
        
        Integer añoactual = gc.get(GregorianCalendar.YEAR);
        Integer mesactual = gc.get(GregorianCalendar.MONTH);
        Integer diaActual = gc.get(GregorianCalendar.DAY_OF_MONTH);
        
        Integer añoseleccionado = JDC_Fecha.getCalendar().get(GregorianCalendar.YEAR);
        Integer messelect = JDC_Fecha.getCalendar().get(GregorianCalendar.MONTH);
        Integer diaselect = JDC_Fecha.getCalendar().get(GregorianCalendar.DAY_OF_MONTH);
        
        Integer edad;
        
        if(messelect >= mesactual){
        
            if(messelect == mesactual && diaselect == diaActual){
                
                edad = añoactual - añoseleccionado;
                
            }
            
            else{
         
                edad = añoactual - añoseleccionado - 1;
                   
            }   
            
        }
        
        else{
        
            edad = añoactual - añoseleccionado;
        
        }
        
        perfil = new DataPerfil(password, nick, email, tipoperfil, nombre, apellido, fechanac, edad, imgperfil, sitioweb);
        
        return perfil;
    
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        JD_SelectorImagen = new javax.swing.JDialog();
        JFC_Chooser = new javax.swing.JFileChooser();
        JD_ElegirPerfil = new javax.swing.JDialog();
        JCB_Perfil = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        JB_ElegirCancelar = new javax.swing.JButton();
        JB_ElegirAceptar = new javax.swing.JButton();
        JD_CambiarContraseña = new javax.swing.JDialog();
        JL_Actual = new javax.swing.JLabel();
        JPF_Actual = new javax.swing.JPasswordField();
        JB_ComprobarPassword = new javax.swing.JButton();
        JL_Nueva = new javax.swing.JLabel();
        JPF_Nueva = new javax.swing.JPasswordField();
        JL_Confirm = new javax.swing.JLabel();
        JPF_Confirmar = new javax.swing.JPasswordField();
        JB_AceptarPassword = new javax.swing.JButton();
        JB_CancelarPassword = new javax.swing.JButton();
        JL_Nivel = new javax.swing.JLabel();
        JL_Confirmar = new javax.swing.JLabel();
        jLblNick = new javax.swing.JLabel();
        jLblEmail = new javax.swing.JLabel();
        JTF_Nick = new javax.swing.JTextField();
        JTF_Email = new javax.swing.JTextField();
        JB_Cancelar = new javax.swing.JButton();
        jLblNombre = new javax.swing.JLabel();
        JTF_Nombre = new javax.swing.JTextField();
        JLblApellido = new javax.swing.JLabel();
        JTF_Apellido = new javax.swing.JTextField();
        jLblFechaNac = new javax.swing.JLabel();
        JP_Imagen = new javax.swing.JPanel();
        JB_Cambiar = new javax.swing.JButton();
        JB_Modificar = new javax.swing.JButton();
        jLblWebDesarrollador = new javax.swing.JLabel();
        JTF_Web = new javax.swing.JTextField();
        JDC_Fecha = new com.toedter.calendar.JDateChooser();
        JL_Perfil = new javax.swing.JLabel();
        JB_CambiarContraseña = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();

        JD_SelectorImagen.setTitle("Seleccionar Imágen");
        JD_SelectorImagen.setResizable(false);

        FileNameExtensionFilter JFC_Filtro = new FileNameExtensionFilter("Imagenes", "jpg", "jpeg", "png", "bmp");
        JFC_Chooser.setFileFilter(JFC_Filtro);
        JFC_Chooser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JFC_ChooserActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout JD_SelectorImagenLayout = new javax.swing.GroupLayout(JD_SelectorImagen.getContentPane());
        JD_SelectorImagen.getContentPane().setLayout(JD_SelectorImagenLayout);
        JD_SelectorImagenLayout.setHorizontalGroup(
            JD_SelectorImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_SelectorImagenLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JFC_Chooser, javax.swing.GroupLayout.DEFAULT_SIZE, 752, Short.MAX_VALUE)
                .addContainerGap())
        );
        JD_SelectorImagenLayout.setVerticalGroup(
            JD_SelectorImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_SelectorImagenLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JFC_Chooser, javax.swing.GroupLayout.DEFAULT_SIZE, 544, Short.MAX_VALUE)
                .addContainerGap())
        );

        JD_ElegirPerfil.setTitle("Elegir Perfil");
        JD_ElegirPerfil.setResizable(false);

        JCB_Perfil.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JCB_PerfilActionPerformed(evt);
            }
        });

        jLabel1.setText("Perfil:");

        JB_ElegirCancelar.setText("Cancelar");
        JB_ElegirCancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_ElegirCancelarActionPerformed(evt);
            }
        });

        JB_ElegirAceptar.setText("Aceptar");
        JB_ElegirAceptar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_ElegirAceptarActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout JD_ElegirPerfilLayout = new javax.swing.GroupLayout(JD_ElegirPerfil.getContentPane());
        JD_ElegirPerfil.getContentPane().setLayout(JD_ElegirPerfilLayout);
        JD_ElegirPerfilLayout.setHorizontalGroup(
            JD_ElegirPerfilLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_ElegirPerfilLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(JD_ElegirPerfilLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(JD_ElegirPerfilLayout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(JCB_Perfil, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(JD_ElegirPerfilLayout.createSequentialGroup()
                        .addComponent(JB_ElegirCancelar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 235, Short.MAX_VALUE)
                        .addComponent(JB_ElegirAceptar)))
                .addContainerGap())
        );
        JD_ElegirPerfilLayout.setVerticalGroup(
            JD_ElegirPerfilLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_ElegirPerfilLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(JD_ElegirPerfilLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(JCB_Perfil, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(JD_ElegirPerfilLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(JB_ElegirCancelar)
                    .addComponent(JB_ElegirAceptar))
                .addContainerGap())
        );

        JD_CambiarContraseña.setTitle("Cambiar Contraseña");
        JD_CambiarContraseña.setResizable(false);

        JL_Actual.setText("Contraseña actual:");

        JPF_Actual.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JPF_ActualKeyReleased(evt);
            }
        });

        JB_ComprobarPassword.setText("Comprobar");
        JB_ComprobarPassword.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_ComprobarPasswordActionPerformed(evt);
            }
        });

        JL_Nueva.setText("Contraseña nueva:");

        JPF_Nueva.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JPF_NuevaKeyReleased(evt);
            }
        });

        JL_Confirm.setText("Confirmar:");

        JPF_Confirmar.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JPF_ConfirmarKeyReleased(evt);
            }
        });

        JB_AceptarPassword.setText("Aceptar");
        JB_AceptarPassword.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_AceptarPasswordActionPerformed(evt);
            }
        });

        JB_CancelarPassword.setText("Cancelar");
        JB_CancelarPassword.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_CancelarPasswordActionPerformed(evt);
            }
        });

        JL_Nivel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        JL_Nivel.setBorder(null);
        JL_Nivel.setOpaque(true);

        JL_Confirmar.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        JL_Confirmar.setBorder(null);
        JL_Confirmar.setOpaque(true);

        javax.swing.GroupLayout JD_CambiarContraseñaLayout = new javax.swing.GroupLayout(JD_CambiarContraseña.getContentPane());
        JD_CambiarContraseña.getContentPane().setLayout(JD_CambiarContraseñaLayout);
        JD_CambiarContraseñaLayout.setHorizontalGroup(
            JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_CambiarContraseñaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(JD_CambiarContraseñaLayout.createSequentialGroup()
                        .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(JL_Actual)
                            .addComponent(JL_Nueva)
                            .addComponent(JL_Confirm))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(JD_CambiarContraseñaLayout.createSequentialGroup()
                        .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(JPF_Confirmar)
                            .addComponent(JPF_Nueva)
                            .addComponent(JPF_Actual, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(JD_CambiarContraseñaLayout.createSequentialGroup()
                                .addComponent(JB_CancelarPassword)
                                .addGap(0, 313, Short.MAX_VALUE)))
                        .addGap(18, 18, 18)
                        .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                .addComponent(JB_ComprobarPassword, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(JL_Confirmar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(JL_Nivel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addComponent(JB_AceptarPassword, javax.swing.GroupLayout.Alignment.TRAILING))))
                .addContainerGap())
        );
        JD_CambiarContraseñaLayout.setVerticalGroup(
            JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JD_CambiarContraseñaLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JL_Actual)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(JPF_Actual, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(JB_ComprobarPassword))
                .addGap(18, 18, 18)
                .addComponent(JL_Nueva)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(JL_Nivel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(JPF_Nueva))
                .addGap(18, 18, 18)
                .addComponent(JL_Confirm)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(JL_Confirmar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(JPF_Confirmar))
                .addGap(18, 18, 18)
                .addGroup(JD_CambiarContraseñaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(JB_CancelarPassword)
                    .addComponent(JB_AceptarPassword))
                .addContainerGap(13, Short.MAX_VALUE))
        );

        setClosable(true);
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
        });

        jLblNick.setText("Nick:");

        jLblEmail.setText("E-mail:");

        JTF_Nick.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_NickKeyReleased(evt);
            }
        });

        JTF_Email.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_EmailKeyReleased(evt);
            }
        });

        JB_Cancelar.setText("Cancelar");
        JB_Cancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_CancelarActionPerformed(evt);
            }
        });

        jLblNombre.setText("Nombre:");

        JTF_Nombre.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_NombreKeyReleased(evt);
            }
        });

        JLblApellido.setText("Apellido:");

        JTF_Apellido.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_ApellidoKeyReleased(evt);
            }
        });

        jLblFechaNac.setText("Fecha de Nacimiento:");

        JP_Imagen.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0), 3));

        javax.swing.GroupLayout JP_ImagenLayout = new javax.swing.GroupLayout(JP_Imagen);
        JP_Imagen.setLayout(JP_ImagenLayout);
        JP_ImagenLayout.setHorizontalGroup(
            JP_ImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 197, Short.MAX_VALUE)
        );
        JP_ImagenLayout.setVerticalGroup(
            JP_ImagenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 194, Short.MAX_VALUE)
        );

        JB_Cambiar.setText("Cambiar Imágen");
        JB_Cambiar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_CambiarActionPerformed(evt);
            }
        });

        JB_Modificar.setText("Modificar");
        JB_Modificar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_ModificarActionPerformed(evt);
            }
        });

        jLblWebDesarrollador.setText("Web del Desarrollador:");

        JTF_Web.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                JTF_WebKeyReleased(evt);
            }
        });

        JDC_Fecha.setDebugGraphicsOptions(javax.swing.DebugGraphics.BUFFERED_OPTION);

        JL_Perfil.setText("Perfil:");

        JB_CambiarContraseña.setText("Cambiar");
        JB_CambiarContraseña.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JB_CambiarContraseñaActionPerformed(evt);
            }
        });

        jLabel2.setText("Contraseña:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                .addComponent(jLblNick)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JTF_Nick, javax.swing.GroupLayout.PREFERRED_SIZE, 492, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                .addComponent(jLblEmail)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JTF_Email)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(JB_Cancelar, javax.swing.GroupLayout.PREFERRED_SIZE, 97, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(JLblApellido)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JTF_Apellido, javax.swing.GroupLayout.PREFERRED_SIZE, 257, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLblFechaNac)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JDC_Fecha, javax.swing.GroupLayout.PREFERRED_SIZE, 168, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLblNombre)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JTF_Nombre, javax.swing.GroupLayout.PREFERRED_SIZE, 256, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(JTF_Web, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 329, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(layout.createSequentialGroup()
                                    .addComponent(jLblWebDesarrollador)
                                    .addGap(170, 170, 170)))
                            .addComponent(JL_Perfil)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(JB_CambiarContraseña)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 34, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(JB_Cambiar, javax.swing.GroupLayout.PREFERRED_SIZE, 142, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(27, 27, 27))
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(JP_Imagen, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                    .addComponent(JB_Modificar, javax.swing.GroupLayout.PREFERRED_SIZE, 143, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGap(28, 28, 28))))
                        .addGap(32, 32, 32))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblNick)
                    .addComponent(JTF_Nick, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(JB_Cancelar))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(JTF_Email, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLblEmail))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 77, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(JB_Cambiar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(JP_Imagen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(JB_Modificar)
                        .addContainerGap(42, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2)
                            .addComponent(JB_CambiarContraseña))
                        .addGap(18, 18, 18)
                        .addComponent(JL_Perfil)
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLblNombre)
                            .addComponent(JTF_Nombre, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(JLblApellido)
                            .addComponent(JTF_Apellido, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLblFechaNac)
                            .addComponent(JDC_Fecha, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLblWebDesarrollador)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(JTF_Web, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(24, 24, 24))))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    
    private void JB_ModificarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_ModificarActionPerformed

        DataPerfil perfil = prepareData();
        String nick = perfil.getNick();
        String email = perfil.getCorreo();
        String nombre = perfil.getNombre();
        String apellido = perfil.getApellido();
        String fechanac = perfil.getFechaNac().getString();
        Integer edad = perfil.getEdad();
        String imagenp = perfil.getImagen();
        String weblink = perfil.getSitioWeb();
        Integer opcion;
        
        String mensaje = new String();
        Boolean cambio = false;
        Boolean copiarImagen = false;
        
        String temp = "<html><b>Los siguientes datos serán modificados:<br><br>";
        mensaje = mensaje.concat(temp);
        
        if(cnueva != null){
        
            temp = "Se ha modificado la contraseña.<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            
        }
        
        if(!(nick.equals(pviejo.getNick()))){
        
            temp = "Nick: " + nick + "<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            
        }
                       
        if(!(email.equals(pviejo.getCorreo()))){
        
            temp = "Email: " + email + "<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            
        }
        
        if(!(nombre.equals(pviejo.getNombre()))){
        
            temp = "Nombre: " + nombre + "<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            
        }
        
        if(!(apellido.equals(pviejo.getApellido()))){
        
            temp = "Apellido: " + apellido + "<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            
        }
        
        if(!(fechanac.equals(pviejo.getFechaNac().getString()))){
        
            temp = "Fecha de Nacimiento: " + fechanac + "<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            
        }
        
        if(edad != pviejo.getEdad()){
        
            temp = "Edad: " + edad + "<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            
        }
        
        if(path != null){
        
            temp = "La imágen del perfil ha sido modificada" + "<br>";
            mensaje = mensaje.concat(temp);
            cambio = true;
            copiarImagen = true;
            
        }
        
        if(weblink != null){
        
            if(!(weblink.equals(pviejo.getSitioWeb()))){

                temp = "Web: " + weblink + "<br>";
                mensaje = mensaje.concat(temp);
                cambio = true;
                
            }
        
        }
        
        temp = "<br>Desea confirmar?</b></html>";
        mensaje = mensaje.concat(temp);
        
        if(cambio == true){
        
            opcion = JOptionPane.showConfirmDialog(this, mensaje, "Confirmación", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, frameIcon);
        
            if(opcion == 0){

                try{
                                        
                    ip.modificarPerfil(pviejo.getNick(), pviejo.getCorreo(), perfil);
                    
                    if(copiarImagen){
                    
                        escribirImagen(imagen, perfil.getImagen());
                                            
                    }
                    
                    this.setVisible(false);
                    JDesktopPane p = (JDesktopPane)this.getParent();
                    p.remove(this);
                    p.repaint();
                    this.dispose();
                    JIFInicial.BloquearJFInicial();
                    JOptionPane.showMessageDialog(this, "Operación realizada con exito!", "Mensaje", JOptionPane.INFORMATION_MESSAGE);
                
                }

                catch(Exception e){

                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);

                }

            }
        
        }
        
        else{
        
            opcion = JOptionPane.showConfirmDialog(this, "<html></p>No se realizaron cambios, desea volver a modificar?</p></hmtl>", "Confirmación", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, frameIcon);
                 
            if(opcion != 0){
            
                this.dispose();
                JIFInicial.BloquearJFInicial();
                            
            }
            
        }
            
    }//GEN-LAST:event_JB_ModificarActionPerformed

    private void JB_CancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_CancelarActionPerformed

        this.dispose();
        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_JB_CancelarActionPerformed

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing

        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_formInternalFrameClosing

    private void JTF_NickKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_NickKeyReleased

        habilitarModificarBtn();
        
    }//GEN-LAST:event_JTF_NickKeyReleased

    private void JTF_EmailKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_EmailKeyReleased

        habilitarModificarBtn();

    }//GEN-LAST:event_JTF_EmailKeyReleased

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened

        centrarVentana();
        
    }//GEN-LAST:event_formInternalFrameOpened

    private void JB_CambiarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_CambiarActionPerformed

        JFC_Chooser.setSize(640, 480);
        JD_SelectorImagen.setSize(JFC_Chooser.getSize());
        JD_SelectorImagen.setLocationRelativeTo(this);
        JD_SelectorImagen.setVisible(true);
        deshabilitarComponentes();

    }//GEN-LAST:event_JB_CambiarActionPerformed

    private void JFC_ChooserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JFC_ChooserActionPerformed

        if(evt.getActionCommand().equals(JFileChooser.APPROVE_SELECTION)){
        
            this.imagen = JFC_Chooser.getSelectedFile();
            JD_SelectorImagen.setVisible(false);
            
            try{
            
                if(pi == null){

                    pi = new Panel(imagen);
                    pi.setSize(JP_Imagen.getSize());
                    JP_Imagen.add(pi);
                    JP_Imagen.repaint();

                }

                else{

                    pi.cargarImagen(imagen);
                    JP_Imagen.repaint();

                }
        
            }
            
            catch(Exception e){
            
                JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
                    
            }
        
            if(pviejo.getTipoPerfil().equals("[CLIENTE]")){
            
                componentesCliente();
                JB_Cancelar.setEnabled(true);
                
            }
            
            else{
            
                componentesDesarrollador();
                JB_Cancelar.setEnabled(true);
            
            }
            
            path = imagen.getAbsolutePath();
            
            if(pviejo.getTipoPerfil().equals("[CLIENTE]")){
        
                if((JTF_Nombre.getText().length() > 0) && (JTF_Apellido.getText().length() > 0) && (path != null)){

                    JB_Modificar.setEnabled(true);

                }

                else{

                    JB_Modificar.setEnabled(false);

                }

            }

            else{

                if((JTF_Nombre.getText().length() > 0) && (JTF_Apellido.getText().length() > 0) && (JTF_Web.getText().length() > 0) && (path != null)){

                    JB_Modificar.setEnabled(true);

                }

                else{

                    JB_Modificar.setEnabled(false);

                }

            }

        }
        
        if(evt.getActionCommand().equals(JFileChooser.CANCEL_SELECTION)){
        
            JD_SelectorImagen.setVisible(false);
            this.setEnabled(true);
            
            if(pviejo.getTipoPerfil().equals("[CLIENTE]")){
            
                componentesCliente();
                JB_Cancelar.setEnabled(true);
                
            }
            
            else{
            
                componentesDesarrollador();
                JB_Cancelar.setEnabled(true);
            
            }
        
        }

    }//GEN-LAST:event_JFC_ChooserActionPerformed

    private void JCB_CalendarioActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JCB_CalendarioActionPerformed
    }//GEN-LAST:event_JCB_CalendarioActionPerformed

    private void JTF_NombreKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_NombreKeyReleased
        
        habilitarModificarBtn();
        
    }//GEN-LAST:event_JTF_NombreKeyReleased

    private void JTF_ApellidoKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_ApellidoKeyReleased

        habilitarModificarBtn();

    }//GEN-LAST:event_JTF_ApellidoKeyReleased

    private void JTF_WebKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JTF_WebKeyReleased

        habilitarModificarBtn();

    }//GEN-LAST:event_JTF_WebKeyReleased

    private void JB_ElegirCancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_ElegirCancelarActionPerformed

        JD_ElegirPerfil.setVisible(false);
        this.dispose();
        JIFInicial.BloquearJFInicial();

    }//GEN-LAST:event_JB_ElegirCancelarActionPerformed

    private void JCB_PerfilActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JCB_PerfilActionPerformed

        JB_ElegirAceptar.setEnabled(true);

    }//GEN-LAST:event_JCB_PerfilActionPerformed

    private void JB_ElegirAceptarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_ElegirAceptarActionPerformed

        try{
        
            DataPerfil dp = ip.obtenerPerfil((String)JCB_Perfil.getSelectedItem(), false);
            pviejo = dp;
            JTF_Nick.setText(dp.getNick());
            JTF_Email.setText(dp.getCorreo());
            JTF_Nombre.setText(dp.getNombre());
            JTF_Apellido.setText(dp.getApellido());
            path = pviejo.getImagen();
            
            if(dp.getTipoPerfil().equals("[CLIENTE]")){
            
                JL_Perfil.setText("Perfil: Cliente");
            
            }
            
            else{
            
                JL_Perfil.setText("Perfil: Desarrollador");
                JTF_Web.setText(dp.getSitioWeb());
                
            }
            
            GregorianCalendar gc = new GregorianCalendar();
            gc.set(GregorianCalendar.DATE, Integer.parseInt(dp.getFechaNac().getDay()));
            gc.set(GregorianCalendar.MONTH, (Integer.parseInt(dp.getFechaNac().getMonth()) - 1));
            gc.set(GregorianCalendar.YEAR, Integer.parseInt(dp.getFechaNac().getYear()));
            
            JDC_Fecha.setCalendar(gc);
                
            JD_ElegirPerfil.setVisible(false);
            componentesModificar();
            this.show();
            
            try{
            
                String dirServidor = JIFInicial.getInstance().getDirServidor();
                this.imagen = new File(dirServidor + "/" + path);
                pi = new Panel(imagen);
                pi.setSize(JP_Imagen.getSize());
                JP_Imagen.add(pi);
                JP_Imagen.repaint();
                
            }
            
            catch(Exception e){

                JOptionPane.showMessageDialog(this, "<html><b>No se pudo cargar la imágen del perfil.</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);

            }
            
        }
        
        catch(Exception e){
        
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_JB_ElegirAceptarActionPerformed

    private void JB_CambiarContraseñaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_CambiarContraseñaActionPerformed

        JD_CambiarContraseña.setSize(520, 265);
        JD_CambiarContraseña.setResizable(false);
        JD_CambiarContraseña.setLocationRelativeTo(this);
        bloquearContraseña();
        JD_CambiarContraseña.setVisible(true);
        deshabilitarComponentes();

    }//GEN-LAST:event_JB_CambiarContraseñaActionPerformed

    private void JB_CancelarPasswordActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_CancelarPasswordActionPerformed

        JD_CambiarContraseña.setVisible(false);
        componentesModificar();
        JD_CambiarContraseña.dispose();

    }//GEN-LAST:event_JB_CancelarPasswordActionPerformed

    private void JPF_ActualKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JPF_ActualKeyReleased

        char password[] = JPF_Actual.getPassword();
        
        if(password.length > 7){
        
            JB_ComprobarPassword.setEnabled(true);
        
        }
        
        else{
        
            JB_ComprobarPassword.setEnabled(false);
        
        }

    }//GEN-LAST:event_JPF_ActualKeyReleased

    private void JB_ComprobarPasswordActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_ComprobarPasswordActionPerformed

        char pass[] = JPF_Actual.getPassword();     
        String password = String.valueOf(pass);
        
        try{
        
            MD5 md = new MD5();
            password = md.md5(password);
        
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>Error de conversión MD5<br>Mensaje de error: " + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
        if(password.equals(pviejo.getPassWord())){
        
            JB_ComprobarPassword.setEnabled(false);
            JPF_Actual.setEnabled(false);
            JL_Actual.setEnabled(false);
            JPF_Nueva.setEnabled(true);
            JL_Nueva.setEnabled(true);
            JPF_Confirmar.setEnabled(true);
            JL_Confirm.setEnabled(true);
        
        }

        else{
        
            JOptionPane.showMessageDialog(this, "<html><b>Contraseña incorrecta!</b></html>", "Advertencia!", JOptionPane.WARNING_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_JB_ComprobarPasswordActionPerformed

    private void JPF_NuevaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JPF_NuevaKeyReleased

        char password[] = JPF_Nueva.getPassword();
        
        if(password.length > 7){
        
            JPF_Confirmar.setEnabled(true);
            JL_Nivel.setEnabled(true);
        
        }
        
        else{
        
            JPF_Confirmar.setEnabled(false);
            JL_Nivel.setEnabled(false);
        
        }
              
        if(nivelSeguridad(password) == 1){
        
            JL_Nivel.setText("Nivel Bajo");
            JL_Nivel.setBorder(javax.swing.BorderFactory.createLineBorder(Color.red));
            
        }
        
        else if(nivelSeguridad(password) == 2){
        
            JL_Nivel.setText("Nivel Medio");
            JL_Nivel.setBorder(javax.swing.BorderFactory.createLineBorder(Color.yellow));
            
        }
        
        else if(nivelSeguridad(password) == 3){
        
            JL_Nivel.setText("Nivel Alto");
            JL_Nivel.setBorder(javax.swing.BorderFactory.createLineBorder(Color.green));
            
        }
        
        else{
        
            JL_Nivel.setText("Nivel Nulo");
            JL_Nivel.setBorder(null);
        
        }
        
        char confirmar[] = JPF_Confirmar.getPassword();
        
        if(Arrays.equals(password, confirmar) && (password.length > 7)){
        
            JL_Confirmar.setText("OK!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.green)); 
            JB_AceptarPassword.setEnabled(true);
        
        }
        
        else{
        
            JL_Confirmar.setText("ERROR!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.red));                   
            JB_AceptarPassword.setEnabled(false);
        
        }
        
    }//GEN-LAST:event_JPF_NuevaKeyReleased

    private void JPF_ConfirmarKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_JPF_ConfirmarKeyReleased

        char password[] = JPF_Nueva.getPassword();
        char confirmar[] = JPF_Confirmar.getPassword();
        
        if(Arrays.equals(password, confirmar) && (password.length > 7)){
        
            JL_Confirmar.setText("OK!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.green)); 
            JB_AceptarPassword.setEnabled(true);
        
        }
        
        else{
        
            JL_Confirmar.setText("ERROR!");
            JL_Confirmar.setBorder(javax.swing.BorderFactory.createLineBorder(Color.red));                   
            JB_AceptarPassword.setEnabled(false);
        
        }

    }//GEN-LAST:event_JPF_ConfirmarKeyReleased

    private void JB_AceptarPasswordActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JB_AceptarPasswordActionPerformed

        cnueva = String.valueOf(JPF_Nueva.getPassword());
        JD_CambiarContraseña.setVisible(false);
        JD_CambiarContraseña.dispose();
        componentesModificar();

    }//GEN-LAST:event_JB_AceptarPasswordActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton JB_AceptarPassword;
    private javax.swing.JButton JB_Cambiar;
    private javax.swing.JButton JB_CambiarContraseña;
    private javax.swing.JButton JB_Cancelar;
    private javax.swing.JButton JB_CancelarPassword;
    private javax.swing.JButton JB_ComprobarPassword;
    private javax.swing.JButton JB_ElegirAceptar;
    private javax.swing.JButton JB_ElegirCancelar;
    private javax.swing.JButton JB_Modificar;
    private javax.swing.JComboBox JCB_Perfil;
    private com.toedter.calendar.JDateChooser JDC_Fecha;
    private javax.swing.JDialog JD_CambiarContraseña;
    private javax.swing.JDialog JD_ElegirPerfil;
    private javax.swing.JDialog JD_SelectorImagen;
    private javax.swing.JFileChooser JFC_Chooser;
    private javax.swing.JLabel JL_Actual;
    private javax.swing.JLabel JL_Confirm;
    private javax.swing.JLabel JL_Confirmar;
    private javax.swing.JLabel JL_Nivel;
    private javax.swing.JLabel JL_Nueva;
    private javax.swing.JLabel JL_Perfil;
    private javax.swing.JLabel JLblApellido;
    private javax.swing.JPasswordField JPF_Actual;
    private javax.swing.JPasswordField JPF_Confirmar;
    private javax.swing.JPasswordField JPF_Nueva;
    private javax.swing.JPanel JP_Imagen;
    private javax.swing.JTextField JTF_Apellido;
    private javax.swing.JTextField JTF_Email;
    private javax.swing.JTextField JTF_Nick;
    private javax.swing.JTextField JTF_Nombre;
    private javax.swing.JTextField JTF_Web;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLblEmail;
    private javax.swing.JLabel jLblFechaNac;
    private javax.swing.JLabel jLblNick;
    private javax.swing.JLabel jLblNombre;
    private javax.swing.JLabel jLblWebDesarrollador;
    // End of variables declaration//GEN-END:variables

}
