package GUILogica;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public final class Panel extends JPanel{
  
    private BufferedImage Blur;
    private Image BlurScaled;
    private File imagen;
    
    public Panel(File imagen) throws Exception{
    
        this.imagen = imagen;
        cargarImagenes();
    
    }
    
    public void cargarImagenes() throws Exception{
    
        try{
        
            Blur = ImageIO.read(imagen);
            
        }
        
        catch(Exception e){
        
            throw new Exception(e.getMessage());
        
        }
    
    }
        
    public void cargarImagen(File imagen) throws Exception{
    
        this.imagen = imagen;
        cargarImagenes();
    
    }
    
    @Override
    public void paintComponent(Graphics g){
    
        super.paintComponent(g);
        BlurScaled = Blur.getScaledInstance(getSize().width, getSize().height, Image.SCALE_SMOOTH);
        g.drawImage(BlurScaled, 0, 0, null);
    
    }
    
}
