

import java.util.List;
import java.util.Collection;
import java.util.Iterator;

public class JugadorPoker extends Jugador {

	/**
	 * @uml.property  name="mano"
	 */
	private List mano;

	/**
	 * Getter of the property <tt>mano</tt>
	 * @return  Returns the mano.
	 * @uml.property  name="mano"
	 */
	public List getMano() {
		return mano;
	}

	/**
	 * Setter of the property <tt>mano</tt>
	 * @param mano  The mano to set.
	 * @uml.property  name="mano"
	 */
	public void setMano(List mano) {
		this.mano = mano;
	}

	/**
	 * @uml.property  name="posicion"
	 */
	private int posicion;

	/**
	 * Getter of the property <tt>posicion</tt>
	 * @return  Returns the posicion.
	 * @uml.property  name="posicion"
	 */
	public int getPosicion() {
		return posicion;
	}

	/**
	 * Setter of the property <tt>posicion</tt>
	 * @param posicion  The posicion to set.
	 * @uml.property  name="posicion"
	 */
	public void setPosicion(int posicion) {
		this.posicion = posicion;
	}

	/** 
	 * @uml.property name="apuesta"
	 */
	private int apuesta;

	/** 
	 * Getter of the property <tt>apuesta</tt>
	 * @return  Returns the apuesta.
	 * @uml.property  name="apuesta"
	 */
	public int getApuesta() {
		return apuesta;
	}

	/** 
	 * Setter of the property <tt>apuesta</tt>
	 * @param apuesta  The apuesta to set.
	 * @uml.property  name="apuesta"
	 */
	public void setApuesta(int apuesta) {
		this.apuesta = apuesta;
	}

		
		/**
		 * @uml.property  name="nombre"
		 */
		private String nombre = "";

		/**
		 * Getter of the property <tt>nombre</tt>
		 * @return  Returns the nombre.
		 * @uml.property  name="nombre"
		 */
		public String getNombre() {
			return nombre;
		}

		/**
		 * Setter of the property <tt>nombre</tt>
		 * @param nombre  The nombre to set.
		 * @uml.property  name="nombre"
		 */
		public void setNombre(String nombre) {
			this.nombre = nombre;
		}

		/**
		 * @uml.property  name="dealer"
		 */
		private boolean dealer;

		/**
		 * Getter of the property <tt>dealer</tt>
		 * @return  Returns the dealer.
		 * @uml.property  name="dealer"
		 */
		public boolean isDealer() {
			return dealer;
		}

		/**
		 * Setter of the property <tt>dealer</tt>
		 * @param dealer  The dealer to set.
		 * @uml.property  name="dealer"
		 */
		public void setDealer(boolean dealer) {
			this.dealer = dealer;
		}

		/**
		 * @uml.property  name="accionPoker"
		 * @uml.associationEnd  multiplicity="(0 -1)" inverse="jugadorPoker:AccionPoker"
		 */
		private Collection accionPoker;

		/**
		 * Getter of the property <tt>accionPoker</tt>
		 * @return  Returns the accionPoker.
		 * @uml.property  name="accionPoker"
		 */
		public Collection getAccionPoker() {
			return accionPoker;
		}

		/**
		 * Returns an iterator over the elements in this collection. 
		 * @return  an <tt>Iterator</tt> over the elements in this collection
		 * @see java.util.Collection#iterator()
		 * @uml.property  name="accionPoker"
		 */
		public Iterator accionPokerIterator() {
			return accionPoker.iterator();
		}

		/**
		 * Returns <tt>true</tt> if this collection contains no elements.
		 * @return  <tt>true</tt> if this collection contains no elements
		 * @see java.util.Collection#isEmpty()
		 * @uml.property  name="accionPoker"
		 */
		public boolean isAccionPokerEmpty() {
			return accionPoker.isEmpty();
		}

		/**
		 * Returns <tt>true</tt> if this collection contains the specified element. 
		 * @param element  whose presence in this collection is to be tested.
		 * @see java.util.Collection#contains(Object)
		 * @uml.property  name="accionPoker"
		 */
		public boolean containsAccionPoker(AccionPoker accionPoker) {
			return this.accionPoker.contains(accionPoker);
		}

		/**
		 * Returns <tt>true</tt> if this collection contains all of the elements in the specified collection.
		 * @param elements  collection to be checked for containment in this collection.
		 * @see java.util.Collection#containsAll(Collection)
		 * @uml.property  name="accionPoker"
		 */
		public boolean containsAllAccionPoker(Collection accionPoker) {
			return this.accionPoker.containsAll(accionPoker);
		}

		/**
		 * Returns the number of elements in this collection.
		 * @return  the number of elements in this collection
		 * @see java.util.Collection#size()
		 * @uml.property  name="accionPoker"
		 */
		public int accionPokerSize() {
			return accionPoker.size();
		}

		/**
		 * Returns all elements of this collection in an array.
		 * @return  an array containing all of the elements in this collection
		 * @see java.util.Collection#toArray()
		 * @uml.property  name="accionPoker"
		 */
		public AccionPoker[] accionPokerToArray() {
			return (AccionPoker[]) accionPoker
					.toArray(new AccionPoker[accionPoker.size()]);
		}

		/**
		 * Returns an array containing all of the elements in this collection;  the runtime type of the returned array is that of the specified array.
		 * @param a  the array into which the elements of this collection are to be stored.
		 * @return  an array containing all of the elements in this collection
		 * @see java.util.Collection#toArray(Object[])
		 * @uml.property  name="accionPoker"
		 */
		public AccionPoker[] accionPokerToArray(AccionPoker[] accionPoker) {
			return (AccionPoker[]) this.accionPoker.toArray(accionPoker);
		}

		/**
		 * Ensures that this collection contains the specified element (optional operation). 
		 * @param element  whose presence in this collection is to be ensured.
		 * @see java.util.Collection#add(Object)
		 * @uml.property  name="accionPoker"
		 */
		public boolean addAccionPoker(AccionPoker accionPoker) {
			return this.accionPoker.add(accionPoker);
		}

		/**
		 * Setter of the property <tt>accionPoker</tt>
		 * @param accionPoker  the accionPoker to set.
		 * @uml.property  name="accionPoker"
		 */
		public void setAccionPoker(Collection accionPoker) {
			this.accionPoker = accionPoker;
		}

		/**
		 * Removes a single instance of the specified element from this collection, if it is present (optional operation).
		 * @param element  to be removed from this collection, if present.
		 * @see java.util.Collection#add(Object)
		 * @uml.property  name="accionPoker"
		 */
		public boolean removeAccionPoker(AccionPoker accionPoker) {
			return this.accionPoker.remove(accionPoker);
		}

		/**
		 * Removes all of the elements from this collection (optional operation).
		 * @see java.util.Collection#clear()
		 * @uml.property  name="accionPoker"
		 */
		public void clearAccionPoker() {
			this.accionPoker.clear();
		}

		
}
