package ing.lightDogs.turetJson;

import javax.persistence.Entity;
import javax.persistence.Id;

@Entity
public class Turet {
	@Id
	String geohash;
	String address;
	String description;
	Double latitude;
	Double longitude;
	Boolean confirmed;
	String addedby;

	public Turet() {
	}
	
	public Turet(String address,String description, Double latitude, Double longitude,Boolean confirmed,String addedby) {
		this.address = address;
		this.description = description;
		this.latitude = latitude;
		this.longitude = longitude;
		this.confirmed = confirmed;
		this.addedby = addedby;
		Geohash gh = new Geohash();
		this.geohash = gh.encode(latitude,longitude);
		//System.out.println("geohash: "+geohash);
	}

	public String getAddedby() {
		return addedby;
	}

	public void setAddedby(String addedby) {
		this.addedby = addedby;
	}

	public String getGeohash() {
		return geohash;
	}

	public void setGeohash(String geohash) {
		this.geohash = geohash;
	}
	
	public Boolean getConfirmed() {
		return confirmed;
	}

	public void setConfirmed(Boolean confirmed) {
		this.confirmed = confirmed;
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public Double getLatitude() {
		return latitude;
	}

	public Double getLongitude() {
		return longitude;
	}

	public void setLatitude(Double latitude) {
		this.latitude = latitude;
	}

	public void setLongitude(Double longitude) {
		this.longitude = longitude;
	}

	public void setCoordinates(String coord) {
		String[] separated = coord.split(",");
		setLatitude(Double.parseDouble(separated[1]));
		setLongitude(Double.parseDouble(separated[0]));
		Geohash gh = new Geohash();
		setGeohash(gh.encode(Double.parseDouble(separated[1]),Double.parseDouble(separated[0])));
	}
	
	public String toJson() {
	    return String.format("{\"address\"=\"%s\", \"description\"=\"%s\", \"latitude\"=\"%s\", \"longitude\"=\"%s\", \"addedby\"=\"%s\", \"confirmed\"=\"%s\", \"geohash\"=\"%s\" }", address,description,latitude,longitude,addedby,confirmed,geohash);
	}
}
