package multimidia;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

import org.junit.Test;

import functionalCore.AlgoritmoDijkstra;

import beans.Aresta;
import beans.Grafo;
import beans.No;

public class Principal {
	
	private List<No> nos;
	private List<Aresta> arestas;

	@Test
	public void Executar() {
		nos = new ArrayList<No>();
		arestas = new ArrayList<Aresta>();
		for (int i = 0; i < 5; i++) {
			int j = i+1;
			No location = new No("No_" + j, "No_" + j);
			nos.add(location);
		}

		addLinha("Aresta_0", 0, 1, 3);
		addLinha("Aresta_1", 0, 3, 5);
		addLinha("Aresta_2", 1, 2, 7);
		addLinha("Aresta_3", 1, 3, 2);
		addLinha("Aresta_4", 2, 4, 2);
		addLinha("Aresta_5", 3, 1, 1);
		addLinha("Aresta_6", 3, 2, 4);
		addLinha("Aresta_7", 3, 4, 7);
		addLinha("Aresta_8", 4, 0, 3);
		addLinha("Aresta_9", 4, 2, 7);

		Grafo grafo = new Grafo(nos, arestas);
		AlgoritmoDijkstra dijkstra = new AlgoritmoDijkstra(grafo);
		Scanner sc = new Scanner(System.in);
		
		System.out.println("\tDigite um numero de 1 a 5");
		
		System.out.print("\tDigite o numero do no inicial: ");
		int begin = sc.nextInt()-1;
		
		System.out.print("\tDigite o numero do no final: ");
		int finish = sc.nextInt()-1;
		
		dijkstra.executar(nos.get(begin));
		LinkedList<No> caminho = dijkstra.getCaminho(nos.get(finish));
		
		assertNotNull(caminho);
		assertTrue(caminho.size() > 0);
		
		List<String> caminhoFinal = new ArrayList<String>();
		String seta = "->";
		
		for (No no : caminho) {
			caminhoFinal.add(no.getDescricao());
			caminhoFinal.add(seta);
		}
		String menorCaminho = caminhoFinal.get(0);
		for(int i=1; i < caminhoFinal.size()-1; i++)
		{
			menorCaminho += caminhoFinal.get(i);
		}
		System.out.println("O menor caminho entre " + nos.get(begin) + " e " + nos.get(finish) + "  " + menorCaminho);
	}

	private void addLinha(String linhaId, int noFonte, int noDestino,
			int peso) {
		Aresta linha = new Aresta(linhaId, nos.get(noFonte), nos.get(noDestino), peso );
		arestas.add(linha);
	}

}
