package br.com.frbb.ugvbr.robot;

import java.util.Properties;

import br.com.frbb.ugvbr.R;
import br.com.frbb.ugvbr.image.ImageProcessor;
import br.com.frbb.ugvbr.image.ImageProcessorFactory;
import android.content.Context;
import android.graphics.Bitmap;

public class Robot {
	
	private ImageProcessor imageProcessor;
	
	private Motor leftMotor;
	private Motor rightMotor;
	
	private Properties powers;
	
	Robot(Context context) {

		// Carrega instancias dos motores
		leftMotor = MotorFactory.getLeftMotor();
		rightMotor = MotorFactory.getRightMotor();
		
		// Carrega processador de imagens
		imageProcessor = ImageProcessorFactory.getImageProcessor(context);
		
		// Carrega lista de velocidades
		powers = new Properties();
		try {
			powers.load(context.getResources().openRawResource(R.raw.power));
		}
		catch (Exception e) {
		}
	}

	public Motor getLeftMotor() {
		return leftMotor;
	}

	public Motor getRightMotor() {
		return rightMotor;
	}
	
	public void moveByImage(Bitmap bitmap) {
		String command;
		String[] p;
		int speed;
		
		// Resgata informaes do comando
		command = imageProcessor.recognize(bitmap);
		if(command != null) {
			p = powers.getProperty(command).split(";");		
		
			// Executa comandos
			speed = Integer.parseInt(p[0]);
			leftMotor.move(speed);
			
			speed = Integer.parseInt(p[1]);
			rightMotor.move(speed);
		}
	}
}
