/**
 * 
 */
package com.vishudha.timer.domain;

import java.io.Serializable;

/**
 * VishudhaAlert.java
 * @author Anish Jain
 * @since 2011
 * @version 1.0
 */
@SuppressWarnings("serial")
public class VishudhaAlert implements Serializable {
	private long time;
	private VishudhaAlertType type;

	public VishudhaAlert() {
		this(0, VishudhaAlertType.NONE);
	}
	
	public VishudhaAlert(long time) {
		this(time, VishudhaAlertType.ONCE);
	}

	public VishudhaAlert(long time, VishudhaAlertType type) {
		this.time = time;
		this.type = type;
	}

	public boolean isValid() {
		if(type != VishudhaAlertType.NONE && time <= 0) 
			throw new IllegalArgumentException("Alert can not be negitive, Please provide positive value");
		return true;
	}

	/**
	 * @return the time
	 */
	public long getTime() {
		return time;
	}

	/**
	 * @param time the time to set
	 */
	public void setTime(long time) {
		this.time = time;
	}

	/**
	 * @return the type
	 */
	public VishudhaAlertType getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(VishudhaAlertType type) {
		this.type = type;
	}

	public boolean isAlertAllowed(long value) {
		if(value == time && type != VishudhaAlertType.NONE) {
			if(type.getTimeType() != null) 
				time -= type.getTimeType().getDivisionFactor();
			return true;
		}
		return false;
	}
}
