package com.vishudha.timer.domain;

import java.io.Serializable;

import com.vishudha.timer.VishudhaHelper;

@SuppressWarnings("serial")
@Deprecated
public class VishudhaTime implements Serializable, Cloneable {
	private long years;
	private long months;
	private long days;
	private long hours;
	private long minutes;
	private long seconds;
	private long tenthOfASecond;
	private long miliSeconds;

	/**
	 * Vishudha Time in Year, Month, Day, Minute, Seconds and Tenth Of A Second
	 * @param years
	 * @param months
	 * @param days
	 * @param hours
	 * @param minutes
	 * @param seconds
	 * @param tenthOfASecond
	 * @param miliSeconds
	 */
	public VishudhaTime(long years, long months, long days, long hours, long minutes, long seconds, long tenthOfASecond, long miliSeconds) {
		setYears(years);
		setMonths(months);
		setDays(days);
		setHours(hours);
		setMinutes(minutes);
		setSeconds(seconds);
		setTenthOfASecond(tenthOfASecond);
		setMiliSeconds(miliSeconds);
	}

	public String formatedTime(String message) {
		return VishudhaHelper.getMessage(message, this);
	}

	public long getYears() {
		return years;
	}

	public void setYears(long years) {
		this.years = years;
	}

	public long getMonths() {
		return months;
	}

	public void setMonths(long months) {
		long years = VishudhaHelper.convertToTime(months, VishudhaTimeType.MONTH, VishudhaTimeType.YEAR);
		setYears(getYears() + years);
		this.months = VishudhaHelper.remaningTime(months, years, VishudhaTimeType.MONTH, VishudhaTimeType.YEAR);
	}

	public long getDays() {
		return days;
	}

	public void setDays(long days) {
		long months = VishudhaHelper.convertToTime(days, VishudhaTimeType.DAYS, VishudhaTimeType.MONTH);
		setMonths(getMonths() + months);
		this.days = VishudhaHelper.remaningTime(days, months, VishudhaTimeType.DAYS, VishudhaTimeType.MONTH);
	}

	public long getHours() {
		return hours;
	}

	public void setHours(long hours) {
		long days = VishudhaHelper.convertToTime(hours, VishudhaTimeType.HOURS, VishudhaTimeType.DAYS);
		setDays(getDays() + days);
		this.hours = VishudhaHelper.remaningTime(hours, days, VishudhaTimeType.HOURS, VishudhaTimeType.DAYS);
	}

	public long getMinutes() {
		return minutes;
	}

	public void setMinutes(long minutes) {
		long hours = VishudhaHelper.convertToTime(minutes, VishudhaTimeType.MINUTES, VishudhaTimeType.HOURS);
		setHours(getHours() + hours);
		this.minutes = VishudhaHelper.remaningTime(minutes, hours, VishudhaTimeType.MINUTES, VishudhaTimeType.HOURS);
	}

	public long getSeconds() {
		return seconds;
	}

	public void setSeconds(long seconds) {
		long minutes = VishudhaHelper.convertToTime(seconds, VishudhaTimeType.SECONDS, VishudhaTimeType.MINUTES);
		setMinutes(getMinutes() + minutes);
		this.seconds = VishudhaHelper.remaningTime(seconds, minutes, VishudhaTimeType.SECONDS, VishudhaTimeType.MINUTES);
	}

	public long getTenthOfASecond() {
		return tenthOfASecond;
	}

	public void setTenthOfASecond(long tenthOfASecond) {
		long seconds = VishudhaHelper.convertToTime(tenthOfASecond, VishudhaTimeType.TENTH_OF_A_SECONDS, VishudhaTimeType.SECONDS);
		setSeconds(getSeconds() + seconds);
		this.tenthOfASecond = VishudhaHelper.remaningTime(tenthOfASecond, seconds, VishudhaTimeType.TENTH_OF_A_SECONDS, VishudhaTimeType.SECONDS);
	}
	
	public long getMiliSeconds() {
		return miliSeconds;
	}

	public void setMiliSeconds(long miliSeconds) {
		setMiliSeconds(miliSeconds, false);
	}

	public void setMiliSeconds(long miliSeconds, boolean reset) {
		if(reset) {
			setYears(0);
			setMonths(0);
			setDays(0);
			setHours(0);
			setMinutes(0);
			setSeconds(0);
			setTenthOfASecond(0);
		}

		long tenthOfASecond = VishudhaHelper.convertToTime(miliSeconds, VishudhaTimeType.MILI_SECONDS, VishudhaTimeType.TENTH_OF_A_SECONDS);
		setTenthOfASecond(getTenthOfASecond() + tenthOfASecond);
		this.miliSeconds = VishudhaHelper.remaningTime(miliSeconds, tenthOfASecond, VishudhaTimeType.MILI_SECONDS, VishudhaTimeType.TENTH_OF_A_SECONDS);
	}
	
	@Override
	public VishudhaTime clone() throws CloneNotSupportedException {
		return (VishudhaTime) super.clone();
	}
}
