package com.vishudha.timer.task;

import java.util.List;

import com.vishudha.concurrent.asynchronous.AsynchronousVishudhaWorker;
import com.vishudha.concurrent.asynchronous.VishudhaCallable;
import com.vishudha.timer.domain.VishudhaAlert;
import com.vishudha.timer.domain.VishudhaTimeType;
import com.vishudha.timer.event.VishudhaEvent;
import com.vishudha.timer.listner.VishudhaListner;

public class AsynchronousVishudhaTask extends VishudhaTask {
	private AsynchronousVishudhaWorker <VishudhaTask> worker;

	public AsynchronousVishudhaTask(long time, VishudhaAlert alert) {
		super(time, alert);
		worker = new AsynchronousVishudhaWorker <VishudhaTask>();
	}

	public AsynchronousVishudhaTask(long time, VishudhaAlert alert, VishudhaTimeType timeType) {
		super(time, alert, timeType);
		worker = new AsynchronousVishudhaWorker <VishudhaTask>();
	}

	@Override
	protected void raiseEvent(VishudhaEvent<VishudhaTask> event) {
		List<VishudhaListner <VishudhaTask>> listners = getListners();
		for (VishudhaListner<VishudhaTask> listner : listners) {
			VishudhaCallable <VishudhaTask> callable = new VishudhaCallable <VishudhaTask> (listner, event);
			worker.call(callable);
		}
	}
}
