package com.vishudha.timer.task;

import java.util.List;

import com.vishudha.timer.domain.VishudhaAlert;
import com.vishudha.timer.domain.VishudhaTimeType;
import com.vishudha.timer.event.VishudhaEvent;
import com.vishudha.timer.listner.VishudhaListner;


public final class SynchronousVishudhaTask extends VishudhaTask {

	public SynchronousVishudhaTask(long time, VishudhaAlert alert) {
		super(time, alert);
	}
	
	public SynchronousVishudhaTask(long time, VishudhaAlert alert, VishudhaTimeType timeType) {
		super(time, alert, timeType);
	}

	@Override
	protected void raiseEvent(VishudhaEvent<VishudhaTask> event) {
		List<VishudhaListner <VishudhaTask>> listners = getListners();
		for (VishudhaListner<VishudhaTask> listner : listners) {
			listner.onVishudhaEvent(event);
		}
	}
	
}
