package com.vishudha.timer.task;

import java.util.Date;

import junit.framework.TestCase;

import com.vishudha.timer.VishudhaHelper;
import com.vishudha.timer.domain.VishudhaAlert;
import com.vishudha.timer.domain.VishudhaAlertType;
import com.vishudha.timer.event.VishudhaEvent;
import com.vishudha.timer.event.VishudhaEventType;
import com.vishudha.timer.listner.VishudhaListner;

@SuppressWarnings("serial")
public class VishudhaTaskTest extends TestCase implements VishudhaListner <VishudhaTask> {
	
	public static void main(String[] args) {
		VishudhaTaskTest taskTest = new VishudhaTaskTest();
		taskTest.testExecuteTime();
	}
	
	public void testExecute(){
		VishudhaTask task = new SynchronousVishudhaTask(3000, new VishudhaAlert(1500));
		task.addListner(this);
		task.executeTask();
	}
	
	public void testExecuteTime(){
		VishudhaTask task = new SynchronousVishudhaTask(7000, new VishudhaAlert(3000, VishudhaAlertType.EVERY_SECOND));
		task.addListner(this);
		task.executeTask();
	}
	
	@Override
	public void onVishudhaEvent(VishudhaEvent<VishudhaTask> event) {
		if(event.getEventType() != VishudhaEventType.UPDATE) { 
			System.out.println("----------------------------------------------------------------");
			System.out.println(event.getEventType().getDisplayName() +  " on " + new Date());
		}
		
		System.out.println(event.getMessage(VishudhaHelper.defaultMessage));
		
		if(event.getEventType() != VishudhaEventType.UPDATE) 
			System.out.println("----------------------------------------------------------------");

	}
}
