/*
 * Copyright (c) 2004-2005, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package com.volatileengine;

/**
 * <code>VolatileEngineException</code> is thrown whenever an unexpected event
 * occurs and the user needs to know about it. Methods that throw
 * VolatileEngineException will be documented
 * 
 * @author Ahmed
 */
public class VolatileEngineException extends RuntimeException {
	private static final long serialVersionUID = 8160766660999561389L;

	/**
	 * Creates a new <code>VolatileEngineException</code> without a description
	 * of the cause
	 */
	public VolatileEngineException() {
		super();
	}

	/**
	 * Creates a new <code>VolatileEngineException</code> with a description of
	 * the problem that caused this exception to be thrown
	 * 
	 * @param message
	 */
	public VolatileEngineException(String message) {
		super(message);
	}

	/**
	 * Create a new <code>VolatileEngineException</code> with a description and
	 * a nested <code>Throwable</code> to provide the trace stack
	 * 
	 * @param message
	 * @param throwable
	 */
	public VolatileEngineException(String message, Throwable throwable) {
		super(message, throwable);
	}

	/**
	 * Encapsulate another <code>Throwable</code> inside
	 * <code>VolatileEngineException</code>
	 * 
	 * @param throwable
	 */
	public VolatileEngineException(Throwable throwable) {
		super(throwable);
	}

}
