/*
 * Copyright (c) 2004-2005, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
package com.volatileengine.datatypes;

import java.nio.Buffer;

/**
 * TODO: Document me
 * 
 * @author ChaosDeathFish
 * @param <T>
 *             the underlying buffer type.
 */
public abstract class Array<T extends Buffer> extends AbstractArray<T> {

	protected byte chunkSize;
	protected int length;
	protected T buffer;

	public Array(int chunkSize, int length) {
		if (chunkSize <= 0 || chunkSize > 127) {
			throw new IllegalArgumentException("Expected 0 < chunkSize <= 127");
		}
		this.chunkSize = (byte) chunkSize;

		if (length > 0) {
			setLength(length);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.volatileEngine.datatypes.Array#getElementSize()
	 */
	@Override
	public int getChunkSize() {
		return chunkSize;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.volatileEngine.datatypes.Array#getBufferIndex(int)
	 */
	@Override
	public int getBufferIndex(int index) {
		return index * chunkSize;
	}

	@Override
	public void createBuffer() {
		createBuffer(length, null);
	}

	@Override
	public void clearBuffer() {
		buffer = null;
	}

	@Override
	public T getBuffer() {
		return buffer;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.volatileEngine.datatypes.Array#setLength(int)
	 */
	@Override
	public void setLength(int length) {
		this.length = length;
		int elem = chunkSize * length;

		if (buffer != null) {
			if (buffer.capacity() < elem) {
				buffer.rewind();
				T nf = createBuffer(elem, buffer);
				nf.rewind();
				buffer = nf;
			} else {
				buffer.limit(elem);
			}
		} else {
			buffer = createBuffer(elem, null);
		}
	}

	protected abstract T createBuffer(int length, T oldBuffer);

	@Override
	public int getStride() {
		return chunkSize;
	}

	@Override
	public int getOffset() {
		return 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.volatileEngine.datatypes.Array#getLength()
	 */
	@Override
	public int getLength() {
		return length;
	}
}
