/*
 * Copyright (c) 2004-2005, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package com.volatileengine.datatypes;

import java.nio.Buffer;
import java.nio.ByteBuffer;

import javax.vecmath.Color4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;

/**
 * TODO: Document me
 * 
 * @author ChaosDeathFish
 * @param <T>
 *             the underlying buffer type.
 */
public class ArrayElement<T extends Buffer> extends AbstractArray<T> {
	private AbstractArray<T> array;
	private int offset;
	private int elementSize;

	public ArrayElement(AbstractArray<T> array, int offset, int size) {
		this.array = array;
		this.offset = offset;
		elementSize = size;
	}

	@Override
	public T getBuffer() {
		return array.getBuffer();
	}

	@Override
	public void createBuffer() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void clearBuffer() {
		throw new UnsupportedOperationException();
	}

	@Override
	public int getBufferIndex(int index) {
		return array.getBufferIndex(index) + offset;
	}

	@Override
	public int getStride() {
		return array.getStride();
	}

	@Override
	public int getChunkSize() {
		return elementSize;
	}

	@Override
	public int getLength() {
		return array.getLength();
	}

	@Override
	public void setLength(int length) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AbstractArray<T> getParentArray() {
		return array;
	}

	@Override
	public DataType getType() {
		return array.getType();
	}

	@Override
	public int getOffset() {
		return offset;
	}

	@Override
	public Color4f getColor4f(int index, int offset, Color4f target) {
		return array.getColor4f(index, this.offset + offset, target);
	}

	@Override
	public Quat4f getQuat4f(int index, int offset, Quat4f target) {
		return array.getQuat4f(index, this.offset + offset, target);
	}

	@Override
	public Tuple2f getTuple2f(int index, int offset, Tuple2f target) {
		return array.getTuple2f(index, this.offset + offset, target);
	}

	@Override
	public Tuple3f getTuple3f(int index, int offset, Tuple3f target) {
		return array.getTuple3f(index, this.offset + offset, target);
	}

	@Override
	public void setColor4f(int index, int offset, Color4f source) {
		array.setColor4f(index, this.offset, source);
	}

	@Override
	public void setQuat4f(int index, int offset, Quat4f source) {
		array.setQuat4f(index, this.offset, source);
	}

	@Override
	public void setTuple2f(int index, int offset, Tuple2f source) {
		array.setTuple2f(index, this.offset, source);
	}

	@Override
	public void setTuple3f(int index, int offset, Tuple3f source) {
		array.setTuple3f(index, this.offset, source);
	}

	@Override
	public byte getByte(int index, int offset) {
		return array.getByte(index, this.offset + offset);
	}

	@Override
	public float getFloat(int index, int offset) {
		return array.getFloat(index, this.offset + offset);
	}

	@Override
	public int getInt(int index, int offset) {
		return array.getInt(index, this.offset + offset);
	}

	@Override
	public void setByte(int index, int offset, byte value) {
		array.setByte(index, this.offset + offset, value);
	}

	@Override
	public void setFloat(int index, int offset, float value) {
		array.setFloat(index, this.offset + offset, value);
	}

	@Override
	public void setInt(int index, int offset, int value) {
		array.setInt(index, this.offset + offset, value);
	}

	@Override
	public void copyFrom(ByteBuffer buffer) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void copyInto(ByteBuffer buffer) {
		throw new UnsupportedOperationException();
	}
}
