/*
 * Copyright (c) 2004-2005, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
package com.volatileengine.datatypes;

/**
 * TODO: Document me
 * 
 * @author ChaosDeathFish
 */
public enum DataType {
	Float('f', 4) {
		@Override
		public AbstractArray<?> createArray(int chunkSize) {
			return new ArrayFloat(chunkSize);
		}

		@Override
		public AbstractArray<?> createInterleavedArray(int[] sizes) {
			return new InterleavedArrayFloat(sizes);
		}
	},
	Int('i', 4) {
		@Override
		public AbstractArray<?> createArray(int chunkSize) {
			return new ArrayInt(chunkSize);
		}

		@Override
		public AbstractArray<?> createInterleavedArray(int[] sizes) {
			throw new UnsupportedOperationException();
		}
	},
	Byte('b', 1) {
		@Override
		public AbstractArray<?> createArray(int chunkSize) {
			return new ArrayByte(chunkSize);
		}

		@Override
		public AbstractArray<?> createInterleavedArray(int[] sizes) {
			throw new UnsupportedOperationException();
		}
	};

	private char typeChar;
	private int dataSize;

	DataType(char typeChar, int dataSize) {
		this.typeChar = typeChar;
		this.dataSize = dataSize;
	}

	public char getTypeChar() {
		return typeChar;
	}

	public int getDataSize() {
		return dataSize;
	}

	public abstract AbstractArray<?> createArray(int chunkSize);

	public abstract AbstractArray<?> createInterleavedArray(int[] sizes);
}