/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.image;

import com.volatileengine.datatypes.ArrayByte;
import com.volatileengine.platform.CreateMipmapReadCommand;
import com.volatileengine.platform.GPUChannel;
import com.volatileengine.platform.PlatformManager;
import com.volatileengine.platform.RenderingContext;
import com.volatileengine.resources.references.Handle;
import com.volatileengine.scene.Surface;

/**
 * 
 * @author Administrator
 */
public abstract class Mipmap extends Surface {

	public enum ImageType {
		RGBA, DXT1A, DXT1, DXT3, DXT5;
	}

	private Texture parentTexture;

	private int mipmapLevel;
	private ArrayByte pixels;

	private int width, height;

	private Handle<?> handle;

	public Mipmap(Texture parent, int mipmapLevel, int width, int height, ArrayByte pixels) {
		this.mipmapLevel = mipmapLevel;
		this.width = width;
		this.pixels = pixels;
		this.height = height;
		this.parentTexture = parent;

		GPUChannel channel = new GPUChannel();
		PlatformManager.instance().openChannel(channel);
		CreateMipmapReadCommand command = new CreateMipmapReadCommand(this);
		channel.put(command);
		channel.sync();
		PlatformManager.instance().closeChannel(channel);
	}

	public abstract boolean isCompressed();

	public abstract ImageType imageType();

	/**
	 * @return the pixels
	 */
	public ArrayByte getPixels() {
		return pixels;
	}

	public Texture getParentTexture() {
		return parentTexture;
	}

	public int getMipmapLevel() {
		return mipmapLevel;
	}

	@Override
	public RenderingContext getGraphicsContext() {
		return new RenderingContext(this);
	}

	public Handle<?> getHandle() {
		return handle;
	}

	/**
	 * @return the width
	 */
	@Override
	public int getWidth() {
		return width;
	}

	/**
	 * @return the height
	 */
	@Override
	public int getHeight() {
		return height;
	}
}
