/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.volatileengine.image;

import com.volatileengine.platform.CreateTextureReadCommand;
import com.volatileengine.platform.GPUChannel;
import com.volatileengine.platform.PlatformManager;
import com.volatileengine.resources.references.Handle;
import com.volatileengine.resources.references.Resource;

/**
 * 
 * @author Administrator
 */
public class Texture implements Resource {

	public enum ImageFilter {
		LINEAR, NEAREST;
	}

	private String name;
	private Mipmap[] mipmaps;

	private Handle<?> handle;

	public Texture(String name, int mipmapLevels) {
		this.name = name;
		this.mipmaps = new Mipmap[mipmapLevels];

		GPUChannel channel = new GPUChannel();
		PlatformManager.instance().openChannel(channel);
		CreateTextureReadCommand command = new CreateTextureReadCommand(this);
		channel.put(command);
		channel.sync();
		PlatformManager.instance().closeChannel(channel);
	}

	public Mipmap[] getMipmaps() {
		return mipmaps;
	}

	public String getName() {
		return name;
	}

	public Handle<?> getHandle() {
		return handle;
	}

}
