/*
 * Copyright (c) 2004-2005, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
package com.volatileengine.material.shader;

import java.nio.ByteBuffer;

import com.volatileengine.platform.CreateShaderObjectReadCommand;
import com.volatileengine.platform.GPUChannel;
import com.volatileengine.platform.PlatformManager;
import com.volatileengine.resources.references.Handle;
import com.volatileengine.resources.references.Resource;

/**
 * TODO: Document me
 * 
 * @author Chaosdeathfish
 * @author Ahmed - removed gl constants only
 */
public class ShaderObject implements Resource {

	private Handle<?> handle;
	private ShaderType shaderType;
	private ByteBuffer shader;

	/**
	 * ShaderObject constructor.
	 * 
	 * @param objectid
	 *             the ID of the shader object.
	 * @param shaderType
	 *             the type of the shader.
	 */
	public ShaderObject(ByteBuffer shader, ShaderType shaderType) {
		this.shaderType = shaderType;
		this.shader = shader;

		GPUChannel channel = new GPUChannel();
		PlatformManager.instance().openChannel(channel);
		CreateShaderObjectReadCommand command = new CreateShaderObjectReadCommand(this);
		channel.put(command);
		channel.sync();
		PlatformManager.instance().closeChannel(channel);
	}

	public ShaderType getShaderType() {
		return shaderType;
	}

	public Handle<?> getHandle() {
		return handle;
	}

	public ByteBuffer getShader() {
		return shader;
	}

}
