/**
 * 
 */
package com.volatileengine.material.shader.variable;

import java.lang.reflect.Field;

/**
 * @author Ahmed
 * 
 */
public class PrimitiveShaderVariable<T> extends ShaderVariable<T> {

	private Field reflectField;
	private Object instance;

	/**
	 * @param name
	 */
	public PrimitiveShaderVariable(String name) {
		this(name, null, null);
	}

	public PrimitiveShaderVariable(String name, Field field, Object instance) {
		super(name);
		reflectField = field;
		this.instance = instance;
	}

	/**
	 * @param reflectField
	 *             the reflectField to set
	 */
	public void setReflectField(Field reflectField) {
		this.reflectField = reflectField;
	}

	/**
	 * @param instance
	 *             the instance to set
	 */
	public void setReflectInstance(Object instance) {
		this.instance = instance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@SuppressWarnings("unchecked")
	@Override
	public int hashCode() {

		if (reflectField != null && instance != null) {
			try {
				value = (T) reflectField.get(instance);
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}

		return value.hashCode();
	}

}
