/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * 
 */
package com.volatileengine.material.states;

import com.volatileengine.VolatileEngineException;

/**
 * @author darkprophet
 * 
 */
public class StencilRenderState extends RenderState {

	public enum StencilOp {
		KEEP, ZERO, REPLACE, INCR, DECR, INVERT;
	}

	private CompareFunc[] compareFunc;
	private int[] referenceValue;
	private int[] maskValue;

	private StencilOp[] stencilFail;
	private StencilOp[] stencilPassDepthFail;
	private StencilOp[] stencilPassDepthPass;

	protected StencilRenderState() {
		super();
		compareFunc = new CompareFunc[2];
		referenceValue = new int[2];
		maskValue = new int[2];

		stencilFail = new StencilOp[2];
		stencilPassDepthFail = new StencilOp[2];
		stencilPassDepthPass = new StencilOp[2];
	}

	public void setStencilFunc(ApplyFace face, CompareFunc func, int reference, int mask) {
		if (face == ApplyFace.FRONT_AND_BACK) {
			setStencilFunc(ApplyFace.FRONT, func, reference, mask);
			setStencilFunc(ApplyFace.BACK, func, reference, mask);
			return;
		}

		compareFunc[face.ordinal()] = func;
		referenceValue[face.ordinal()] = reference;
		maskValue[face.ordinal()] = mask;
	}

	public void setStencilOp(ApplyFace face, StencilOp fail, StencilOp dfail, StencilOp dpass) {
		if (face == ApplyFace.FRONT_AND_BACK) {
			setStencilOp(ApplyFace.FRONT, fail, dfail, dpass);
			setStencilOp(ApplyFace.BACK, fail, dfail, dpass);
			return;
		}

		stencilFail[face.ordinal()] = fail;
		stencilPassDepthFail[face.ordinal()] = dfail;
		stencilPassDepthPass[face.ordinal()] = dpass;
	}

	public CompareFunc getCompareFunc(ApplyFace face) {
		checkFace(face);
		return compareFunc[face.ordinal()];
	}

	public int getReferenceValue(ApplyFace face) {
		checkFace(face);
		return referenceValue[face.ordinal()];
	}

	public int getMaskValue(ApplyFace face) {
		checkFace(face);
		return maskValue[face.ordinal()];
	}

	public StencilOp getStencilFail(ApplyFace face) {
		checkFace(face);
		return stencilFail[face.ordinal()];
	}

	public StencilOp getStencilPassDepthFail(ApplyFace face) {
		checkFace(face);
		return stencilPassDepthFail[face.ordinal()];
	}

	public StencilOp getStencilPassDepthPass(ApplyFace face) {
		checkFace(face);
		return stencilPassDepthPass[face.ordinal()];
	}

	private void checkFace(ApplyFace face) {
		if (face == ApplyFace.FRONT_AND_BACK) {
			throw new VolatileEngineException(
					"Cannot obtain both values at the same time, please obtain 1 at a time");
		}
	}
}
