/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.material.xml;

import com.volatileengine.material.Pass;
import com.volatileengine.material.shader.xml.ShaderProgramXMLElement;
import com.volatileengine.material.states.DepthRenderState;
import com.volatileengine.material.states.xml.DepthRenderStateXMLElement;
import com.volatileengine.xml.IFileLoader;
import com.volatileengine.xml.XMLParsingException;
import com.volatileengine.xml.elements.Element;
import com.volatileengine.xml.elements.SimpleXMLElement;

/**
 * 
 * @author Administrator
 */
public class PassXMLElement extends SimpleXMLElement<Pass> {

	private DepthRenderState depthState;

	public String getAssociatedTag() {
		return "pass";
	}

	public Element<?> instantiateChild(String tagName, IFileLoader<?> loader) {
		if ("shaderprogram".equalsIgnoreCase(tagName)) {
			return new ShaderProgramXMLElement();
		} else if ("depthRenderState".equalsIgnoreCase(tagName)) {
			return new DepthRenderStateXMLElement();
		}
		throw new XMLParsingException(getAssociatedTag() + " does not have " + tagName + " as a child");
	}

	public void endElement(IFileLoader<?> loader) {
		if (value == null) {
			throw new XMLParsingException(getAssociatedTag() + " block must declare a ShaderProgram block");
		}
		value.setDepthRenderState(depthState);
	}

	public void processChild(Element<?> child, IFileLoader<?> loader) {
		if ("shaderprogram".equalsIgnoreCase(child.getAssociatedTag())) {
			value = new Pass(((ShaderProgramXMLElement) child).getValue());
		} else if ("depthRenderState".equalsIgnoreCase(child.getAssociatedTag())) {
			depthState = ((DepthRenderStateXMLElement) child).getValue();
		}
	}
}
