/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
package com.volatileengine.scene;

import java.util.List;

import com.volatileengine.material.SceneMaterial;

public class SceneMesh extends SceneObject {

	private SceneMaterial sceneMaterial;
	private Geometry encapsulatedGeometry;

	public SceneMesh(Geometry geo) {
		encapsulatedGeometry = geo;
	}

	public Geometry getEncapsulatedGeometry() {
		return encapsulatedGeometry;
	}

	public SceneMaterial getSceneMaterial() {
		return sceneMaterial;
	}

	public void setSceneMaterial(SceneMaterial sceneMaterial) {
		this.sceneMaterial = sceneMaterial;
	}

	@Override
	public int draw(List<SceneMesh> list, Frustum frustum, SceneNode parent, int parentCheck) {
		if (sceneMaterial == null) {
			return 2;
		} else if (sceneMaterial.getPasses().size() == 0) {
			return 2;
		}

		int result = 1;
		if (parentCheck == 3) {
			result = super.draw(list, frustum, parent, parentCheck);
		}

		if (result == 1 || result == 3) {
			list.add(this);
		}

		return result;
	}
}
