/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.scene;

import java.util.List;

import javax.vecmath.Matrix4f;

/**
 * 
 * @author Owner
 */
public class TransformSceneNode extends SceneNode {

	protected Matrix4f localTransform;
	protected final Matrix4f worldTransform = new Matrix4f();

	@Override
	public int draw(List<SceneMesh> list, Frustum frustum, SceneNode parent, int parentCheck) {
		// no parent, this is the root
		if (parent == null) {
			if (localTransform != null) {
				worldTransform.set(localTransform);
			}
		} // this has a parent, so just set the worldtransform to the world
		// transform of the
		// parent and multiply by the local
		else {
			worldTransform.set(parent.getWorldTransform());
			if (localTransform != null) {
				worldTransform.mul(localTransform);
			}
		}

		int check = super.draw(list, frustum, parent, parentCheck);

		return check;
	}

	@Override
	public Matrix4f getLocalTransform() {
		return localTransform;
	}

	@Override
	public Matrix4f getWorldTransform() {
		return worldTransform;
	}

	@Override
	public void setLocalTransform(Matrix4f localTransform) {
		this.localTransform = localTransform;
	}
}
