/*
 * Copyright (c) 2004-2006, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 * 
 */
package com.volatileengine.xml.elements;

import java.util.StringTokenizer;

import javax.vecmath.Matrix4f;

import com.volatileengine.xml.IFileLoader;
import com.volatileengine.xml.XMLParsingException;

/**
 * @author Administrator
 * 
 */
public class Matrix4fXMLElement extends SimpleXMLElement<Matrix4f> {

	public String getAssociatedTag() {
		return "matrix4f";
	}

	public Element<?> instantiateChild(String tagName, IFileLoader<?> loader) {
		throw new XMLParsingException(getAssociatedTag() + " element does not have any type of child.");
	}

	public void processChild(Element<?> child, IFileLoader<?> loader) {
		throw new XMLParsingException(getAssociatedTag() + " element does not have any type of child.");

	}

	public void endElement(IFileLoader<?> loader) {
		StringTokenizer tokenizer = new StringTokenizer(text.toString(), " ");

		float[] values = new float[16];
		// set the buffer
		for (int i = 0; i < 16; i++) {
			String token = tokenizer.nextToken();
			float fvalue = Float.parseFloat(token);
			values[i] = fvalue;
		}

		value = new Matrix4f(values);
	}

}
