/**
 * 
 */
package com.volatileengine.xml.elements;

import com.volatileengine.xml.IFileLoader;
import com.volatileengine.xml.XMLParsingException;

/**
 * @author darkprophet
 * 
 */
public class ResourceXMLElement extends SimpleXMLElement<String> {

	@Override
	public void processChild(Element<?> child, IFileLoader<?> loader) {
		if (child != null) {
			throw new XMLParsingException(getAssociatedTag() + " must be a leaf element");
		}
	}

	@Override
	public String getAssociatedTag() {
		return "resource";
	}

	@Override
	public Element<?> instantiateChild(String tagName, IFileLoader<?> loader) {
		throw new XMLParsingException(getAssociatedTag() + " element does not have any type of child.");
	}

	@Override
	public void endElement(IFileLoader<?> loader) {
		value = text.toString();
	}

}
