package org.wggds.webservices;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.wggds.webservices.io.WggdsResultException;
import org.wggds.webservices.io.WggdsResultUtilXml;
import org.wggds.webservices.io.data.BiologicalContext;
import org.wggds.webservices.io.data.QueryResult;
import org.wggds.webservices.io.query.CompositionSearchQuery;
import org.wggds.webservices.io.query.IdListQuery;
import org.wggds.webservices.io.query.ListOperationQuery;
import org.wggds.webservices.io.query.MassSearchQuery;
import org.wggds.webservices.io.query.SubstructureQuery;

public class BasicHttpServletExample extends AbstractBasicHttpServletExample{	
	private static final long serialVersionUID=-7969025733898900464L;

	@Override
	public List<QueryResult> runSubStructureQuery(SubstructureQuery query, HttpServletRequest req, HttpServletResponse resp, WggdsResultUtilXml xmlWriter) throws WggdsResultException{
		
        xmlWriter.startRecordResult("listId1");
        // create a complete query result
        QueryResult t_result = new QueryResult();
        t_result.setId("id1");
        String t_sequence = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
            + "\n<GlydeII>"
            + "\n  <molecule subtype=\"glycan\" id=\"From_GlycoCT_Translation\">"
            + "\n    <residue subtype=\"base_type\" partid=\"1\" ref=\"http://www.monosaccharideDB.org/GLYDE-II.jsp?G=a-dgal-HEX-1:5\" />"
            + "\n    <residue subtype=\"substituent\" partid=\"2\" ref=\"http://www.monosaccharideDB.org/GLYDE-II.jsp?G=n-acetyl\" />"
            + "\n    <residue_link from=\"2\" to=\"1\">"
            + "\n      <atom_link from=\"N1H\" to=\"C2\" to_replace=\"O2\" bond_order=\"1\" />"
            + "\n    </residue_link>"
            + "\n  </molecule>"
            + "\n</GlydeII>";
        t_result.setSequence(t_sequence);
        t_result.setUrl("http://www.glycome-db.org/database/showstructure.action?structureId=id1");
        // create a biological context
        List<BiologicalContext> t_list = new ArrayList<BiologicalContext>();
        BiologicalContext t_context = new BiologicalContext();
        t_context.setNcbiTaxonomyId("9606");
        t_context.setTaxonomyName("Homo sapiens");
        t_context.setTissueMeshId("abcde");
        t_context.setTissueName("Liver");
        t_list.add(t_context);
        t_result.setBiologicalSource(t_list);
        xmlWriter.addResult(t_result, true);
        
		return null;
	}
	
	@Override
	public List<QueryResult> runCompositionSearchQuery(CompositionSearchQuery query, HttpServletRequest req, HttpServletResponse resp, WggdsResultUtilXml xmlWriter){
		return null;
	}
	
	@Override
	public List<QueryResult> runMassSearchQuery(MassSearchQuery query, HttpServletRequest req, HttpServletResponse resp, WggdsResultUtilXml xmlWriter){
		return null;
	}
	
	@Override
	public List<QueryResult> runListOperationQuery(ListOperationQuery query, HttpServletRequest req, HttpServletResponse resp, WggdsResultUtilXml xmlWriter){
		return null;
	}
	
	@Override
	public List<QueryResult> runIdListQuery(IdListQuery query, HttpServletRequest req, HttpServletResponse resp, WggdsResultUtilXml xmlWriter){
		return null;
	}

	@Override
	public String getNamespace(){
		return "wggds";
	}

	@Override
	public String getGlydeVersion(){
		return "2";
	}
}
