package org.wggds.webservices.io;

import java.util.List;

import org.wggds.webservices.io.data.QueryResult;
import org.wggds.webservices.io.data.WggdsError;

public interface IWggdsResultUtil
{

    public abstract String createResult(List<QueryResult> a_resultList,
            String a_listId, boolean a_completeInformation,
            String a_glydeVersion) throws WggdsResultException;

    public abstract String createResult(List<QueryResult> a_resultList,
            List<WggdsError> a_error, String a_listId, boolean a_completeInformation,
            String a_glydeVersion) throws WggdsResultException;

    public abstract String createError(List<WggdsError> a_error)
            throws WggdsResultException;

    public abstract void startRecordResult(String a_listId)
            throws WggdsResultException;

    public abstract void startRecordResult(String a_listId,
            String a_glydeVersion) throws WggdsResultException;

    public abstract String finishRecordResult() throws WggdsResultException;

    public abstract void addResult(QueryResult a_result,
            boolean a_completeInformation) throws WggdsResultException;

    public abstract void addError(WggdsError a_error)
            throws WggdsResultException;

}