package org.wggds.webservices.io.query;

import java.io.IOException;
import java.util.List;

import org.wggds.webservices.io.UnknownWggdsQuerySubClass;
import org.wggds.webservices.io.WggdsQueryExcpetion;
import org.wggds.webservices.io.WggdsQueryOutputUtil;
import org.wggds.webservices.io.data.CompleteInformation;
import org.wggds.webservices.io.data.OutputFormat;
import org.wggds.webservices.io.data.QueryResult;

public abstract class WggdsQuery
{
    private OutputFormat m_format = null;
    private CompleteInformation m_completeInformation = CompleteInformation.None;

    public OutputFormat getFormat()
    {
        return m_format;
    }
    public void setFormat(OutputFormat a_format)
    {
        m_format = a_format;
    }
    public CompleteInformation isCompleteInformation()
    {
        return m_completeInformation;
    }
    public void setCompleteInformation(CompleteInformation a_completeInformation)
    {
        m_completeInformation = a_completeInformation;
    }
    
    public List<QueryResult> runQuery(String uri) throws WggdsQueryExcpetion, UnknownWggdsQuerySubClass{
    	return WggdsQueryOutputUtil.runQuery(this, uri);
    }
    
    abstract public String getName();
}
