package ControlLayer;

import ModelLayer.*;
import DBLayer.*;

import java.util.ArrayList; 

public class OrderCtr {

	// creates a new instance of OrderCtr
	public OrderCtr() {
		
	}
	
	// initiates a new order
	public void startNewOrder(Customer customer, String deliveryDate, ArrayList<SaleLine> lineList) {
		SalesOrder saleObj = new SalesOrder();
		Invoice invoice = new Invoice();
		int nextInvoiceNo = GetMax.getMaxID("select max(InvoiceNO) from INVOICE;");
		nextInvoiceNo = nextInvoiceNo + 1;
		
		saleObj.getOrderID();
		saleObj.setTimeStamp();
		saleObj.setCustomer(customer);
		saleObj.setInvoice(invoice);
		boolean deliveryStatus = false;
		saleObj.setDeliveryStatus(deliveryStatus);
		saleObj.setDeliveryDate(deliveryDate);
		saleObj.setLineList(lineList);
		
		invoice.setInvoiceNo(nextInvoiceNo);
		invoice.setAmount(saleObj.getAmount());
		invoice.setPaymentDate("not going to happen");
		
        try{
	         DBConnection.startTransaction();
	         
	         IFInvoice dbInvoice = new DBInvoice();
	         dbInvoice.insertInvoice(invoice);
	         
	         IFSalesOrder dbSale = new DBSalesOrder();
	         dbSale.insert(saleObj);
	         
	         DBConnection.commitTransaction();
        }
        catch(Exception e)
        {
        	System.out.println("error while creating order in OrderCtr");
            DBConnection.rollbackTransaction();
            e.getMessage();
            e.printStackTrace();
        }
	}
	
	// finds an order by orderID
	public SalesOrder findOrder(int productID) {
		IFSalesOrder dbOrder = new DBSalesOrder();
        return dbOrder.findSalesOrder(productID, true);
	}
	
	// retrieves all orders
	public ArrayList<SalesOrder> getAllOrders() {
		IFSalesOrder dbOrder = new DBSalesOrder();
	    ArrayList<SalesOrder> allOrders = new ArrayList<SalesOrder>();
	    allOrders = dbOrder.getAllOrders(false);
	    return allOrders;
	}

	// updates an order
	public int updateOrder(int orderID, String timeStamp, double amount, boolean deliveryStatus, String deliveryDate, Customer customer, Invoice invoice, ArrayList<SaleLine> lineList) {
		IFSalesOrder dbOrder = new DBSalesOrder();
        SalesOrder order = new SalesOrder();
        order.setOrderID(orderID);
        order.setTimeStamp(timeStamp);
        order.setAmount(amount);
        order.setDeliveryStatus(deliveryStatus);
        order.setDeliveryDate(deliveryDate);
        order.setCustomer(customer);
        order.setInvoice(invoice);
        order.setLineList(lineList);
        return dbOrder.update(order);
	}
	
	// deletes an order
	public int deleteOrder(int orderID) {
		IFSalesOrder dbOrder = new DBSalesOrder();
		return dbOrder.delete(orderID);
	}
	
	
}
