package DBLayer;

import java.sql.*;
import java.util.ArrayList;

import ModelLayer.Supplier;
import ModelLayer.Equipment;

public class DBEquipment implements IFEquipment {

	private Connection con;
	
	// constructor
	public DBEquipment() {
		con = DBConnection.getInstance().getDBCon();
	}
	
	@Override
	// returns array list of all Equipment
	public ArrayList<Equipment> getAllEquipment(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}

	@Override
	// returns single Equipment
	public Equipment findEquipment(int productID, boolean retrieveAssociation) {
		String wClause = " ProductID = '" + productID + "'";
		return singleWhere(wClause, retrieveAssociation);
	}

	// search Equipment whose name matches the pattern
	@Override
	public Equipment searchEquipmentByName(String name, boolean retrieveAssociation) {
		String wClause = "Name like '%" + name + "%'";
		System.out.println("SearchEquipment " + wClause);
		return singleWhere(wClause, retrieveAssociation);
	}

	// insert object fields into database
	@Override
	public int insert(Equipment equip) throws Exception {
		int nextProductID = GetMax.getMaxProductID();
		nextProductID = nextProductID + 1;
		System.out.println("Next ProductID = " + nextProductID);
		int rc = -1;
				
		String query = "insert into EQUIPMENT(ProductID, Name, PurchasePrice, RentPrice, CountryOfOrigin, MinStock, Type, Description) values(" +
				nextProductID + ",'"  +
				equip.getName() + "'," +
				equip.getPurchasePrice() + "," +
				equip.getRentPrice() + ",'" +
				equip.getCountryOfOrigin() + "'," +
				equip.getMinStock() + "," +
				equip.getType() + ",'" + 
				equip.getDescription() + "'" +
				equip.getSupplier().getName() + "'):";
		System.out.println("Insert query : " + query);
				
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} 
		catch (Exception e) {
			System.out.println("Equipment was not put into database");
			e.getMessage();
			throw new Exception ("Error while entering Equipment data into database");
		}
		return rc;
	}

	// update fields in database
	@Override
	public int update(Equipment equip) {
		Equipment equipObj = equip;
		int rc = -1;
		
		String query = "update EQUIPMENT set" +
				// "ProductID = " + equipObj.getProductID() + "," + 
				"Name = '" + equipObj.getName() + "'," +
				"PurchasePrice = " + equipObj.getPurchasePrice() + "," +
				"RentPrice = " + equipObj.getRentPrice() + "," + 
				"CountryOfOrigin = '" + equipObj.getCountryOfOrigin() + "'," +
				"MinStock = " + equipObj.getMinStock() + "," +
				"Type= " + equipObj.getType() + "," +
				"Description = '" + equipObj.getDescription() + "'" +
				"SupplierName = '" + equipObj.getSupplier().getName() + "'" +
				"where ProductID = " + equipObj.getProductID() + ";";
		System.out.println("Update query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Equipment was not updated");
			e.getMessage();
		}
		return rc;
	}

	// delete object fields from database
	@Override
	public int delete(int productID) {
		int rc = -1;
				
		String query = "delete from EQUIPMENT where ProductID = " + productID + ";" ;
		System.out.println("Delete query : " + query);
				
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Equipment was not deleted");
			e.getMessage();
		}
		return rc;
	}
	
	// private methods
	
	// used when creating only one Equipment object
	private Equipment singleWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		Equipment equipObj = new Equipment();
		String query = buildQuery(wClause);
		System.out.println(query);
		
		// try reading Equipment from database
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			
			if (results.next()) {
				equipObj = buildEquipment(results);
				stmt.close();
				if (retrieveAssociation) {
					IFSupplier dbSupplier = new DBSupplier();
					String suppName = equipObj.getSupplier().getName();
					Supplier supp = dbSupplier.searchSupplierByName(suppName, false);
					equipObj.setSupplier(supp);
				}
			} else {
				// no Equipment was found
				equipObj = null;
			}
		}
		catch (Exception e) {
			System.out.println("Query exception: "+e);
			e.getMessage();
		}
		return equipObj;
	}

	// used when creating more than one Equipment object
	private ArrayList<Equipment> miscWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		ArrayList<Equipment> list = new ArrayList<Equipment>();
		String query = buildQuery(wClause);
		
		// try to get multiple rows and store them in ArrayList of Equipment object
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			// create each object and add it to the list
			while (results.next()) {
				Equipment equipObj = new Equipment();
				equipObj = buildEquipment(results);
				list.add(equipObj);
			}
			stmt.close();
			if (retrieveAssociation) {
				IFSupplier dbSupplier = new DBSupplier();
				for (Equipment equip : list) {
					String suppName = equip.getSupplier().getName();
					Supplier supp = dbSupplier.searchSupplierByName(suppName, false);
					equip.setSupplier(supp);
				}
		}
	}
		catch (Exception e) {
			System.out.println("Query exception - select: "+e);
			e.getMessage();
		}
		return list;
}

	// build Equipment object out of data fetched from database
	private Equipment buildEquipment(ResultSet results) {
		Equipment equipObj = new Equipment();
		// try to fill Equipment object fields with data from database
		try {
			equipObj.setProductID(results.getInt("ProductID"));
			equipObj.setName(results.getString("Name"));
			equipObj.setPurchasePrice(results.getInt("PurchasePrice"));
			equipObj.setRentPrice(results.getInt("RentPrice"));
			equipObj.setCountryOfOrigin(results.getString("CountryOfOrigin"));
			equipObj.setMinStock(results.getInt("MinStock"));
			equipObj.setType(results.getString("Type"));
			equipObj.setDescription(results.getString("Description"));
			}
		catch (Exception e) {
			System.out.println("Error in building the Equipment object");
			e.getMessage();
		}
		return equipObj;
	}

	private String buildQuery(String wClause) {
		String query = "SELECT * FROM EQUIPMENT";
		if (wClause.length()>0)
			query = query+" WHERE "+ wClause;
		return query;
	}
}