package DBLayer;

import java.sql.*;
import java.util.ArrayList;

import ModelLayer.*;

public class DBEquipmentSaleLine implements IFEquipmentSaleLine {

	private Connection con;
	
	public DBEquipmentSaleLine() {
		con = DBConnection.getInstance().getDBCon();
	}
	
	@Override
	public ArrayList<SaleLine> getAllEquipmentSaleLines(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}

	@Override
	public SaleLine findEquipmentSaleLine(int productID, boolean retrieveAssociation) {
		String wClause = " ProductID = '" + productID + "'";
		return singleWhere(wClause, retrieveAssociation);
	}

	@Override
	public ArrayList<SaleLine> getAllLinesByOrderID(int orderID, boolean retrieveAssociation) {
		String wClause = " OrderID = '" + orderID + "'";	
		return miscWhere(wClause, retrieveAssociation);
	}
	
	@Override
	public int insert(SaleLine equipSale) throws Exception{
		int rc = -1;
		
		String query = "insert into EQUIPMENT_SALE_LINE(ProductID, Quantity) values(" +
				equipSale.getSalesOrder().getOrderID() + "," +
				equipSale.getProduct().getProductID() + "," +
				equipSale.getQuantity() + ");";	
		System.out.println("Insert query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} 
		catch (Exception e) {
			System.out.println("Equipment sale line was not put into database");
			e.getMessage();
			throw new Exception ("Error while entering Equipment sale line data into database");
		}
		return rc;
	}

	@Override
	public int update(SaleLine equipSale) {
		SaleLine equipSaleObj = equipSale;
		int rc = -1;
		
		String query = "update EQUIPMENT_SALE_LINE set" +
				"OrderID = " + equipSaleObj.getSalesOrder().getOrderID() + "," +
				"ProductID = " + equipSaleObj.getProduct().getProductID() + "," + 
				"Quantity = '" + equipSaleObj.getQuantity() + ";" ;
		System.out.println("Update query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Equipment sale line was not updated");
			e.getMessage();
		}
		return rc;
	}

	@Override
	public int delete(int productID) {
		int rc = -1;
		
		String query = "delete from EQUIPMENT_SALE_LINE where ProductID = " + productID + ";" ;
		System.out.println("Delete query : " + query);
		
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();
		} catch (Exception e) {
			System.out.println("Equipment sale line was not deleted");
			e.getMessage();
		}
		return rc;
	}
	
	// used when only one SaleLine object is to be built
	private SaleLine singleWhere(String wClause, boolean retrieveAssociation) {
				
		ResultSet results;
		SaleLine saleLineObj = new SaleLine();
		String query = buildQuery(wClause);
		System.out.println(query);
				
		// try reading SaleLine from database
		try {
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			results = stmt.executeQuery(query);
			if (results.next()) {
				saleLineObj = buildSaleLine(results);
				stmt.close();
				if (retrieveAssociation) {
					IFSalesOrder dbSalesOrder = new DBSalesOrder();
					int salesOrderID = saleLineObj.getSalesOrder().getOrderID();
					SalesOrder salesOrder = dbSalesOrder.findSalesOrder(salesOrderID, false);
					saleLineObj.setSalesOrder(salesOrder);
					
					IFEquipment dbEquip = new DBEquipment();
					int equipID = saleLineObj.getProduct().getProductID();
					Equipment equip = dbEquip.findEquipment(equipID, false);
					saleLineObj.setProduct(equip);
				}
			}	
		} 
		catch (Exception e) {
				System.out.println("Query exception: "+e);
				e.getMessage();
			}
			return saleLineObj;
		}
			
	// used when more than one SaleLine is created
		private ArrayList<SaleLine> miscWhere(String wClause, boolean retrieveAssociation) {
			ResultSet results;
			ArrayList<SaleLine> list = new ArrayList<SaleLine>();
			String query = buildQuery(wClause);
				
		// try to get multiple rows and store them in an ArrayList of SaleLine object 
			try {
				// getting all the results, based on the query
				Statement stmt = con.createStatement();
				stmt.setQueryTimeout(5);
				results = stmt.executeQuery(query);
				// create each SaleLine object and add it to the list 
				while (results.next()) {
					SaleLine saleLineObj = new SaleLine();
					saleLineObj = buildSaleLine(results);
					list.add(saleLineObj);
				}
				stmt.close();
				if (retrieveAssociation) {
					IFSalesOrder dbSalesOrder = new DBSalesOrder();
					IFEquipment dbEquipment = new DBEquipment();
					for (SaleLine saleLine : list) {
						int salesOrderID = saleLine.getSalesOrder().getOrderID();
						SalesOrder salesOrder = dbSalesOrder.findSalesOrder(salesOrderID, false);
						saleLine.setSalesOrder(salesOrder);
						
						int equipID = saleLine.getProduct().getProductID();
						Equipment equip = dbEquipment.findEquipment(equipID, false);
						saleLine.setProduct(equip);
					}
				}
			} 
			catch (Exception e) {
				System.out.println("Query exception - select: "+e);
				e.getMessage();
			}
			return list;
		}
			
	// build SaleLine object out of data fetched from database
		private SaleLine buildSaleLine(ResultSet results) {
			Equipment equip = new Equipment();
			SalesOrder salesOrder = new SalesOrder();
			SaleLine saleLineObj = new SaleLine();
			saleLineObj.setProduct(equip);
			saleLineObj.setSalesOrder(salesOrder);
			// try to fill SaleLine object fields with data from database
			try {
				equip.setProductID(results.getInt("ProductID"));
				salesOrder.setOrderID(results.getInt("OrderID"));
				saleLineObj.setQuantity(results.getInt("Quantity"));
			} 
			catch (Exception e) {
				System.out.println("Error in building the SaleLine object");
				e.getMessage();
			}	
			return saleLineObj;
		}
			
		private String buildQuery(String wClause) {
			String query="SELECT * FROM SALELINE";
				
			if (wClause.length()>0)
				query=query+" WHERE "+ wClause;
					
			return query;
		}

}
