package DBLayer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import ModelLayer.Invoice;

public class DBInvoice implements IFInvoice {

	private Connection con;
	
	// constructor makes new database connection on object creation.
	public DBInvoice() {
		con = DBConnection.getInstance().getDBCon();
	}

	// returns array list of all Invoices, wClause is empty means no 'where' is used, see buildQuery()
	@Override
	public ArrayList<Invoice> getAllInvoices(boolean retrieveAssociation) {
		 return miscWhere("", retrieveAssociation);
	}

	// returns single Invoice, where invNo is used for wClause see buildQuery()
	@Override
	public Invoice searchInvoiceNo(int invNo, boolean retrieveAssociation) {
		 String wClause = " InvoiceNo = " + invNo;
	        return singleWhere(wClause, retrieveAssociation);
	}
	
	// insert object fields into database
	@Override
	public int insertInvoice(Invoice inv) throws Exception {  
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing   
		int rc = -1;
		
		// constructing query
		String query="insert into INVOICE(InvoiceNo, PaymentDate, Amount) values ("+ 
				inv.getInvoiceNo()  + ",'"  +
			    inv.getPaymentDate()  + "',"  +
			    inv.getAmount() + ");";      
	    System.out.println("insert : " + query);
	    // creating statement and executing query
	    try{ // insert new invoice
	        Statement stmt = con.createStatement();
	        stmt.setQueryTimeout(5);
	     	rc = stmt.executeUpdate(query);
	        stmt.close();
	        }//end try
	       catch(SQLException ex){
	          System.out.println("invoice has not been created");
	          // throw new Exception ("invoice is not inserted correctly");
	       }
	       return(rc);
	}

	
	//update fields in database
	@Override
	public int updateInvoice(Invoice inv) {
		Invoice invObj  = inv;
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing
		int rc=-1;
		
		//constructing query
		String query="update INVOICE set "+
		 	  "PaymentDate ='"+ invObj.getPaymentDate()+"', "+
		 	  "Amount = "+ invObj.getAmount() + ", " +
		      " where InvoiceNo = "+ invObj.getInvoiceNo() + ";";
        System.out.println("Update query:" + query);
  		try{ // update invoice
	 		Statement stmt = con.createStatement();
	 		stmt.setQueryTimeout(5);
	 	 	rc = stmt.executeUpdate(query);

	 	 	stmt.close();
		}//end try
	 	catch(Exception ex){
	 	 	System.out.println("Update exception in invoice db: "+ex);
	  	}
		return(rc);
	}
	
	//DELETE from database
	@Override
	public int deleteInvoice(int invoiceNo) {
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing
        int rc=-1;
    	
        // constructing query
        String query="delete from INVOICE where InvoiceNo = " + invoiceNo + ";";
        System.out.println(query);
	
      // creating statement and executing query
        try{ // delete from invoice
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
		  	rc = stmt.executeUpdate(query);
		  	stmt.close();
        } catch (Exception ex) {
        	System.out.println("Delete exception in invoice db: "+ex);
        }
	return(rc);
	}
	
	//private methods
    //miscWere is used whenever we want to select more than one Invoice
	private ArrayList<Invoice> miscWhere(String wClause, boolean retrieveAssociation)
	{
		// preparing objects that are going to be used
        ResultSet results;
	    ArrayList<Invoice> list = new ArrayList<Invoice>();	
		
	    String query =  buildQuery(wClause);
  
	    // try to get multiple rows and store it in ArrayList of Invoice object
        try{ // read the Invoice from the database
		Statement stmt = con.createStatement();
	 	stmt.setQueryTimeout(5);
	 	results = stmt.executeQuery(query);
	 	
	
		while( results.next() ){
	     	 Invoice invObj = new Invoice();
		 invObj = buildInvoice(results);	
                 list.add(invObj);	
		}//end while
                 stmt.close();                     
		}//end try	
	 	catch(Exception e){
	 		System.out.println("Query exception - select: "+e);
			e.printStackTrace();
	 	}
		return list;
	}
	private Invoice singleWhere(String wClause, boolean retrieveAssociation)
	{
		// preparing objects that are going to be used
		ResultSet results;
		Invoice invObj = new Invoice();
                
	    String query =  buildQuery(wClause);
        System.out.println(query);
        
        // try reading Invoice from database
        try{ // read the Invoice from the database
	 		Statement stmt = con.createStatement();
	 		stmt.setQueryTimeout(5);
	 		results = stmt.executeQuery(query);
	 		
	 		if( results.next() ){
                            invObj = buildInvoice(results);
                            //Association is to be build
                            stmt.close();
			}
                        else{ //no Invoice was found
                            invObj = null;
                        }
		}//end try	
	 	catch(Exception e){
	 		System.out.println("Query exception: ");
	 		e.getMessage();
	 	}
		return invObj;
	}
	//method to build the query
	private String buildQuery(String wClause)
	{
	    String query="select * from INVOICE";
		
		if (wClause.length()>0)
			query=query+" where "+ wClause;
			
		return query;
	}
	//method to build an Invoice object
	private Invoice buildInvoice(ResultSet results){   
		
		Invoice invObj = new Invoice();
      	
		// try to fill invoice object fields with data from database
          try{ // the columns from the table Invoice  are used
                invObj.setInvoiceNo(results.getInt("InvoiceNo"));
                invObj.setPaymentDate(results.getString("PaymentDate"));
                invObj.setAmount(results.getDouble("Amount"));
          }
         catch(Exception e)
         {
             System.out.println("error in building the Invoice object");
         }
         return invObj;
      }
}
