package DBLayer;

import java.sql.Connection; //establishes the connection to the database, when initialized;
import java.sql.ResultSet; //store all data fetched from the database in one place;
import java.sql.SQLException; //required in order to handle the exception calls;
import java.sql.Statement; //the query executor;

import java.util.ArrayList; //needed to get all SalesOrder from the Database;
import ModelLayer.*; //needed to store the fetched data from the database;

public class DBSalesOrder implements IFSalesOrder {
	
	private  Connection con; //The reference is needed for building a connection with the Database;
	
    /** Creates a new instance of DBSalesOrder */
    public DBSalesOrder() {
      con = DBConnection.getInstance().getDBCon(); //Makes a connection to the Database;
    }
    
	//PUBLIC METHODS
	@Override
	/** retrieves all SalesOrders; */
	public ArrayList<SalesOrder> getAllOrders(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation); //Note: wClause is empty, because we want to get all SalesOrders, so no condition(clause) is needed;
	}

	@Override
	/** retrieves a single SalesOrder, found by its ID, note wCluase is being used this time; */
	public SalesOrder findSalesOrder(int orderID, boolean retrieveAssociation) {
		String wClause = "OrderID = " + orderID; //Creates a search criteria, this will make to get that SalesOrder, which fulfills the clause;
		return singleWhere(wClause, retrieveAssociation);   
	}

	@Override
	/** Inserts a new SalesOrder into the database; */
	public int insert(SalesOrder sOrder) throws Exception {
		int orderID = getMaxSalesOrderID("Select max(OrderID) from SALESORDER") + 1; //initializes the orderID; 
        int rc = -1; //row count, it is set to -1, to guarantee nothing will happen, in case the method fails to fulfill the task;
        
        int deliveryStatus;
        if (sOrder.getDeliveryStatus()) {
        	deliveryStatus = 1;
        } else {
        	deliveryStatus = 0;
        }
        //creates a query for data insertion;
        String query = "insert into SALESORDER(OrderID, InvoiceNo, PurchaseDate, Amount, DeliveryStatus, DeliveryDate, CustomerCpr) values(" +
				orderID + ","  +
				sOrder.getInvoice().getInvoiceNo() + ",'" +
				sOrder.getTimeStamp() + "'," +
				sOrder.getAmount() + "," +
				deliveryStatus + ",'" +
				sOrder.getDeliveryDate() + "','" +
				sOrder.getCustomer().getCPR() + "');";
		System.out.println("Insert query : " + query); 
		
		try{ //creating a statement and inserting SalesOrder in database;
         
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query); //tries to get row count number;
			stmt.close();
		}//try ends;
		
       catch(SQLException ex){ //error, exception call;
          System.out.println("SalesOrder was inserted in the database");
          // commenting out this exception fixed an error
          // throw new Exception ("Error: Entering Salesorder data into database fails");
       }
       return rc; //returns the row count to controller;
    }

	@Override
	/** Updates the fields of a selected SalesOrder; */
	public int update(SalesOrder sOrder)  {
		int rc = -1; //row count, it is set to -1, to guarantee nothing will happen, in case the method fails to fulfill the task;
		
		int deliveryStatus;
        if (sOrder.getDeliveryStatus()) {
        	deliveryStatus = 1;
        } else {
        	deliveryStatus = 0;
        }
		
		//creates update data query;
		String query = "update SALESORDER set " +
				"InvoiceNo = " + sOrder.getInvoice().getInvoiceNo() + "," +
				"PurchaseDate = '" + sOrder.getTimeStamp() + "'," +
				// quick fix double to int
				// "Amount = " + (int) Math.round(sOrder.getAmount()) + "," +
				"Amount = " + sOrder.getAmount() + "," +
				"DeliveryStatus = " + deliveryStatus + "," + 
				"DeliveryDate = '" + sOrder.getDeliveryDate() + "'," +
				"CustomerCpr = '" + sOrder.getCustomer().getCPR() + "'" +
				" where OrderID = " + sOrder.getOrderID() + ";";
		System.out.println("Update query : " + query);
	
		try { //creating a statement and modifying a selected SalesOrder's data in database;
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query); //tries to get row count number;
			stmt.close();
		}//try ends;
		catch (Exception e) { //error, exception call;
			System.out.println("SalesOrder update fails");
			e.getMessage();
		}
		return rc; //returns the row count to controller;
	}
	
	@Override
	/** Deletes a selected SalesOrder from the database; */
	public int delete(int orderID) {
		int rc = -1; //row count, it is set to -1, to guarantee nothing will happen, in case the method fails to fulfill the task;
		
		//creates a deletion query;
		String query = "delete from SALESORDER where OrderID = " + orderID + ";" ;
		System.out.println("Delete query : " + query);
		
		try { //creating a statement and deleting a selected SalesOrder from database;
			Statement stmt = con.createStatement();
			stmt.setQueryTimeout(5);
			rc = stmt.executeUpdate(query);
			stmt.close();	
		}
		catch (Exception e) { //error, exception call;
			System.out.println("SalesOrder deletion fails");
			e.getMessage();
		}
		return rc; //returns the row count to controller;
	}
	
	//PRIVATE METHODS
	/** miscWere method allows a retrieval of more than one SalesOrder, it results in an ArrayList after call; */
	private ArrayList<SalesOrder> miscWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results; //the results retrieved from the database will be stored here;
		ArrayList<SalesOrder> orderList = new ArrayList<SalesOrder>(); //here SalesOrder instances will be stored;	
			
		String query =  buildQuery(wClause);
	  
	    try { // fetching the SalesOrder data from the database;
			Statement stmt = con.createStatement(); //Creates a statement, that will be executed;
		 	stmt.setQueryTimeout(5);
		 	results = stmt.executeQuery(query); //Storing the results from the statement execution;
		 	
			while(results.next()) { //there is another row;
				SalesOrder sOrder = new SalesOrder(); //creates an empty salesOrder instance, which will be populated with retrieved data;
				sOrder = buildSalesOrder(results);	//calls a method which will populate SalesOrder the instance with data;
	            orderList.add(sOrder); //adding the built object to the list;
			}//while loop ends, because there are no more rows;
	        stmt.close();                     	
	        if (retrieveAssociation) {
	        	IFCustomer dbCust = new DBCustomer();
				IFInvoice dbInvoice = new DBInvoice();
				for (SalesOrder sOrder : orderList) {
					int invNo = sOrder.getInvoice().getInvoiceNo();
					Invoice inv = dbInvoice.searchInvoiceNo(invNo, false);
					sOrder.setInvoice(inv);
					
					String custCPR = sOrder.getCustomer().getCPR();
					Customer cust = dbCust.findCustomer(custCPR, false);
					sOrder.setCustomer(cust);
				}
	        }
	    }//try ends;
	    
	    catch(Exception e) { //e.g. no SalesOrder are found in the database, this will result in an empty OrderList;
		 		System.out.println("Query exception - select: "+e);
				e.printStackTrace();
		 	}
	    
	    return orderList; //returns the OrderList;	    
	}
	
	/**retrieves data for only one SalesOrder instance; */
	private SalesOrder singleWhere(String wClause, boolean retrieveAssociation) {
		ResultSet results;
		SalesOrder sOrder = new SalesOrder();
                
	    String query = buildQuery(wClause);
        // System.out.println(query);
		try { //fetching the SalesOrder data from the database;
	 		Statement stmt = con.createStatement(); //Creates a statement, that will be executed;
	 		stmt.setQueryTimeout(5);
	 		results = stmt.executeQuery(query); //Storing the results from the statement execution;
	 		
	 		if(results.next()) { //checks if there are any SalesOrder in the database at all;
	 			sOrder = buildSalesOrder(results);
                stmt.close();
                if(retrieveAssociation) {
                	IFCustomer dbCust = new DBCustomer();
                	String custCPR = sOrder.getCustomer().getCPR();
                	Customer cust = dbCust.findCustomer(custCPR, false);
                	sOrder.setCustomer(cust);
                	
                	IFInvoice dbInv = new DBInvoice();
                	int invNo = sOrder.getInvoice().getInvoiceNo();
                	Invoice invoice = dbInv.searchInvoiceNo(invNo, false);
                	sOrder.setInvoice(invoice);
                }
			} else { //nothing was found
				sOrder = null;
			}
		}//try ends;
		
	 	catch(Exception e) {
	 		System.out.println("Query exception: "+e);
	 	}
		return sOrder;
	}

	/** builds a query for getting all data of a SalesOrder instance; */
	private String buildQuery(String wClause)
	{
	    String query="SELECT OrderID, InvoiceNo, PurchaseDate, Amount, DeliveryStatus, DeliveryDate, CustomerCpr FROM SALESORDER"; //query statement that will be executed;
		
	    if (wClause.length()>0) {
			query = query+" WHERE "+ wClause; //this query will retrieve that SalesOrder's instance data, which fulfills a specified condition;
		}
		
		return query; //returns the built query;
	}
	
	/** populates single SalesOrder with the fetched data; */
	private SalesOrder buildSalesOrder(ResultSet results) {
		SalesOrder sOrder = new SalesOrder(); //storage;
		Invoice invoice = new Invoice();
		Customer cust = new Customer();
		sOrder.setInvoice(invoice);
		sOrder.setCustomer(cust);
		
		try { //retrieving data from the SalesOrder table, by using the columns;
			sOrder.setOrderID(results.getInt("OrderID"));
			invoice.setInvoiceNo(results.getInt("InvoiceNo"));
			sOrder.setTimeStamp(results.getString("PurchaseDate"));
			sOrder.setAmount(results.getDouble("Amount"));
			sOrder.setDeliveryStatus(results.getBoolean("DeliveryStatus"));
			sOrder.setDeliveryDate(results.getString("DeliveryDate"));
			cust.setCPR(results.getString("CustomerCpr"));
			
		}
		catch(Exception e) {
			System.out.println("error in building the employee object"); 
		}
         return sOrder;
      }	

	/** Retrieves maxSalesOrderID */
	public static int getMaxSalesOrderID(String query) {
		ResultSet results;
		int maxSalesOrderID = -1; //sets it to -1, in case no SalesOrder is found in the database;
		try {
			Statement stmt = DBConnection.getInstance().getDBCon().createStatement();
		    results = stmt.executeQuery(query);
		    if( results.next() ) {
		    	maxSalesOrderID = results.getInt(1);	
		    }    
		}//try ends;	
		
		catch(Exception e) {
		    System.out.println("Query exception: Error in reading maxSalesOrderID" + e);
		}
		
		return maxSalesOrderID;
	}
}
