package DBLayer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import ModelLayer.Location;
import ModelLayer.Supplier;

public class DBSupplier implements IFSupplier {

	private Connection con;
	
	// constructor makes new database connection on object creation.
	public DBSupplier() {
		con = DBConnection.getInstance().getDBCon();
	}

	// returns array list of all Suppliers, wClause is empty means no 'where' is used, see buildQuery()
	@Override
	public ArrayList<Supplier> getAllSupplier(boolean retrieveAssociation) {
		return miscWhere("", retrieveAssociation);
	}
	
	// returns single Supplier, where name is used for wClause see buildQuery()
	@Override
	public Supplier searchSupplierByName(String name, boolean retrieveAssociation) {
		 String wClause = " Name = '" + name + "'";
	        return singleWhere(wClause, retrieveAssociation);
	}
	
	// returns single Supplier, where email is used for wClause see buildQuery()
	@Override
	public Supplier searchSupplierByEmail(String email,	boolean retrieveAssociation) {
		 String wClause = " Email = '" + email + "'";
	        return singleWhere(wClause, retrieveAssociation);
	}

	// insert object fields into database
	@Override
	public int insert(Supplier sup) throws Exception {
		
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing   
	    int rc = -1;
		
	    // constructing query
	    String query="insert into SUPPLIER(Name, Address, ZipCode, PhoneNo, Email) values ('"+
		  		sup.getName()  + "','"  +
			    sup.getAddress()  + "',"  +
			    sup.getLocation().getZipCode()  + ",'"  +
			    sup.getPhoneNr()  + "','"  +
			    sup.getEmail() + "');";
	       System.out.println("insert : " + query);
	       
	       // creating statement and executing query
	      try{ // insert new supplier
	          Statement stmt = con.createStatement();
	          stmt.setQueryTimeout(5);
	     	  rc = stmt.executeUpdate(query);
	          stmt.close();
	      }//end try
	       catch(SQLException ex){
	          System.out.println("Supplier is not created");
	          throw new Exception ("supplier is not inserted correctly");
	       }
	       return(rc);
	}

	//update fields in database
	@Override
	public int update(Supplier sup) {
		Supplier supObj  = sup;
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing
		int rc=-1;
		
		// constructing query
		String query="update SUPPLIER set "+
		 	  "Email = '" + supObj.getEmail() + "', "+
		 	  "Address ='" + supObj.getAddress() + "', " +
              "ZipCode = " + supObj.getLocation().getZipCode() + ", " +
              "PhoneNo ='"+ supObj.getPhoneNr() + "' " +
		      " where Name = '" + supObj.getName() + "';";
              System.out.println("Update query:" + query);
         
         // creating statement and executing query
         try{ // update supplier
	 		Statement stmt = con.createStatement();
	 		stmt.setQueryTimeout(5);
	 	 	rc = stmt.executeUpdate(query);

	 	 	stmt.close();
		}//end try
	 	catch(Exception ex){
	 	 	System.out.println("Update exception in supplier db: "+ex);
	  	}
		return(rc);
	}
	
	//DELETE from database
	@Override
	public int delete(String name) {
		// return value of method
		// either (1) the row count for SQL Data Manipulation Language (DML) statements or (2) 0 for SQL statements that return nothing
        int rc=-1;
      
        //constructing query  
        String query="delete from SUPPLIER where Name = '" + name + "'";
        System.out.println(query);
         
         // creating statement and executing query
         try{ // delete from supplier
        	 Statement stmt = con.createStatement();
        	 stmt.setQueryTimeout(5);
        	 rc = stmt.executeUpdate(query);
        	 stmt.close();
	}//end try	
        catch(Exception ex){
	  	System.out.println("Delete exception in supplier db: "+ex);
        }
	return(rc);
	}

	
	//private methods
    //miscWere is used whenever we want to select more than one supplier
	private ArrayList<Supplier> miscWhere(String wClause, boolean retrieveAssociation)
	{
		// preparing objects that are going to be used
        ResultSet results;
	    ArrayList<Supplier> list = new ArrayList<Supplier>();	
		
	    String query =  buildQuery(wClause);
	    
	    // try to get multiple rows and store it in ArrayList of Supplier object
        try{ // read the Supplier from the database
        	Statement stmt = con.createStatement();
        	stmt.setQueryTimeout(5);
        	results = stmt.executeQuery(query);
	 	
		while( results.next() ){
	     	 Supplier supObj = new Supplier();
	     	 supObj = buildSupplier(results);	
             list.add(supObj);	
		}//end while
        stmt.close();
        if (retrieveAssociation) {
        	IFLocation dbLocation = new DBLocation();
        	for (Supplier sup : list) {
        		int locZipCode = sup.getLocation().getZipCode();
            	Location loc = dbLocation.findLocation(locZipCode, false);
            	sup.setLocation(loc);
        	}
        }
		}//end try	
	 	catch (Exception e){
	 		System.out.println("Query exception - select: "+e);
			e.printStackTrace();
	 	}
		return list;
	}
	private Supplier singleWhere(String wClause, boolean retrieveAssociation)
	{
		// preparing objects that are going to be used
		ResultSet results;
		Supplier supObj = new Supplier();
                
	    String query =  buildQuery(wClause);
        System.out.println(query);
        
        // try reading Supplier from database
		try{ // read the Supplier from the database
	 		Statement stmt = con.createStatement();
	 		stmt.setQueryTimeout(5);
	 		results = stmt.executeQuery(query);
	 		
	 		if( results.next() ){
	 			supObj = buildSupplier(results);
	 			stmt.close();
	 			//Association is to be build
                if (retrieveAssociation) {
                	IFLocation dbLocation = new DBLocation();
                	int locZipCode = supObj.getLocation().getZipCode();
                	Location loc = dbLocation.findLocation(locZipCode, false);
                	supObj.setLocation(loc);
                }
			} else { //no Supplier was found
				supObj = null;
            }
		}//end try	
	 	catch(Exception e){
	 		System.out.println("Query exception: "+e);
	 	}
		return supObj;
	}
	//method to build the query
	private String buildQuery(String wClause)
	{
	    String query="select * from SUPPLIER";
		
		if (wClause.length()>0)
			query=query+" WHERE "+ wClause;
			
		return query;
	}
	//method to build an Supplier object
	private Supplier buildSupplier(ResultSet results){
        Location loc = new Location();
		Supplier supObj = new Supplier();
        // make reference to Location
		supObj.setLocation(loc);
		// try to fill invoice object fields with data from database
		try{ // the columns from the table supplier  are used
                supObj.setName(results.getString("Name"));
                supObj.setAddress(results.getString("Address"));
                // supObj.setCountry(results.getString("Country"));
                supObj.setPhoneNr(results.getString("PhoneNo"));
                supObj.setEmail(results.getString("Email"));
                loc.setZipCode(results.getInt("ZipCode"));
          }
         catch(Exception e)
         {
             System.out.println("error in building the Supplier object");
         }
         return supObj;
      }

	
 

}
