package DBLayer;

import java.util.ArrayList; //needed to get all SalesOrder from the Database;
import ModelLayer.SalesOrder; //needed in order to be able to execute insert, update, delete;

/** Interface of the DBSalesOrder class
 *  TO see how the methods are implemented see DBSalesOrder */
public interface IFSalesOrder {
	//gets all SalesOrders, placed in an ArrayList
    public ArrayList<SalesOrder> getAllOrders(boolean retrieveAssociation);
    
    //searches SalesOrder by orderID    
    public SalesOrder findSalesOrder(int orderID, boolean retrieveAssociation);
    
    //inserts new SalesOrder
    public int insert(SalesOrder sOrder) throws Exception;
    
    //updates SalesOrder 
    public int update(SalesOrder sOrder);
    
    //deletes SalesOrder 
    public int delete(int orderID);
}
