package GUILayer;

import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import ControlLayer.OrderCtr;
import DBLayer.DBClothing;
import DBLayer.DBCustomer;
import DBLayer.DBEquipment;
import DBLayer.DBGunReplicas;
import DBLayer.IFClothing;
import DBLayer.IFCustomer;
import DBLayer.IFEquipment;
import DBLayer.IFGunReplicas;
import ModelLayer.Clothing;
import ModelLayer.Customer;
import ModelLayer.Equipment;
import ModelLayer.GunReplicas;
import ModelLayer.Product;
import ModelLayer.SaleLine;
import ModelLayer.SalesOrder;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.factories.FormFactory;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JFormattedTextField;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.JScrollPane;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JComboBox;
import javax.swing.DefaultComboBoxModel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class CreateOrderGUI extends JFrame {

	private JPanel contentPane; //content Pane
	private JLabel lblProductId;
	private JLabel lblCpr;
	private JTextField textField;
	private JFormattedTextField formattedTextField;
	private JLabel lblQuantity;
	private JButton btnAdd;
	private JTextField textField_1;
	private JButton btnSave;
	private JTable table;
	private JLabel lblDeliveryDate;
	private JFormattedTextField frmtdtxtfldMmddyyyy;
	private JComboBox comboBox;
	private JButton btnRemove;
	private JScrollPane scrollPane; // ↑components 
	private ArrayList<SaleLine> items; // list of sale line items ordered by a customer
	private Customer cust; // customer for the order
	private DefaultTableModel dtm; // model for the table
	private IFGunReplicas ifg;
	private IFClothing ifc;
	private IFEquipment ife; //↑database access objects
	private OrderCtr ordCtr; //controller object
	private static CreateOrderGUI frame; // frame
	private JLabel lblTotal;
	

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					frame = new CreateOrderGUI();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	@SuppressWarnings("serial")
	public CreateOrderGUI() {
		
		//when the window is closed, ordergui is going to be opened
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosed(WindowEvent arg0) {
				OrderGUI frame = new OrderGUI();
				frame.show();
			}
		});
		
		setTitle("Create Order");//of the frame
		
		//model for the table
				dtm = new DefaultTableModel(
						new Object[][] {
						},
						new String[] {
							"", "ID", "Name", "Description", "Price", "Quantity", "Total"
						}
					) {
						Class[] columnTypes = new Class[] {
							Boolean.class, Integer.class, String.class, String.class, Double.class, Integer.class, Double.class
						};
						boolean[] columnEditables = new boolean[] {
								true, false, false, false, false, false, false
							};
						public Class getColumnClass(int columnIndex) {
							return columnTypes[columnIndex];
						}
					};
		
		//Initialise variables
		ordCtr = new OrderCtr();
		ife = new DBEquipment();
		ifg = new DBGunReplicas();
		ifc = new DBClothing();
		cust = new Customer();
		items = new ArrayList<SaleLine>();
		
		//basic operations and layout
		setDefaultCloseOperation(CreateOrderGUI.DISPOSE_ON_CLOSE);
		
		setBounds(100, 100, 539, 519);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(new FormLayout(new ColumnSpec[] {
				ColumnSpec.decode("27px"),
				ColumnSpec.decode("85px"),
				FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("86px"),
				FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("57px"),
				FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("24px"),
				FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("104px"),
				FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("70px"),},
			new RowSpec[] {
				RowSpec.decode("36px"),
				RowSpec.decode("23px"),
				FormFactory.RELATED_GAP_ROWSPEC,
				RowSpec.decode("20px"),
				FormFactory.RELATED_GAP_ROWSPEC,
				RowSpec.decode("23px"),
				FormFactory.RELATED_GAP_ROWSPEC,
				RowSpec.decode("282px"),
				FormFactory.RELATED_GAP_ROWSPEC,
				FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC,
				RowSpec.decode("23px"),}));
		
		//components
		lblProductId = new JLabel("Product ID:");
		contentPane.add(lblProductId, "2, 2, right, center");
		
		textField = new JTextField();
		contentPane.add(textField, "4, 2, left, center");
		textField.setColumns(10);
		
		lblQuantity = new JLabel("Quantity:");
		contentPane.add(lblQuantity, "6, 2, right, center");
		
		formattedTextField = new JFormattedTextField();
		contentPane.add(formattedTextField, "8, 2, fill, center");
		
		comboBox = new JComboBox();
		comboBox.setModel(new DefaultComboBoxModel(new String[] {"Choose Type", "Gun Replica", "Clothing", "Equipment"}));
		contentPane.add(comboBox, "10, 2, left, center");
		
		//add button with action listener
		btnAdd = new JButton("Add");
		btnAdd.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				try{// to add the product
					int iD = Integer.parseInt(textField.getText()); // id of the product
					int quantity = Integer.parseInt(formattedTextField.getText()); // quantity of the product
					Product pro = new Product();
					SalesOrder saleO = new SalesOrder();
					pro.setProductID(iD);
					SaleLine saleLine = new SaleLine(pro, saleO, quantity); // create new sale line
					items.add(saleLine); // add to shopping cart
					String type = (String) comboBox.getSelectedItem(); // type of the product
				
				//variables for the table
				String name = "";
				String description = "";
				double price = 0;
				double total = 0;
				
				
				//action performed according to the type of product
				switch(type){
				case "Gun Replica":	{
					
					//find gun replica in database, get data
					GunReplicas gun = new GunReplicas();
					gun = ifg.findGunReplica(iD, false);
					name = gun.getName();
					description = gun.getCalibre() + ", " + gun.getFabric();
					price = gun.getPurchasePrice();
					total = price * quantity;
					
					//add to the table
					Object[] rowData = {Boolean.FALSE,iD,name,description,price,quantity,total};
					dtm.addRow(rowData);
					
				}
					break;
				case "Clothing": {
					
					//find clothing in database, get data
					Clothing clo = new Clothing();
					clo = ifc.findClothing(iD, false);
					name = clo.getName();
					description = clo.getSize() + ", " + clo.getColour();
					price = clo.getPurchasePrice();
					total = price * quantity;
					
					//add to the table
					Object[] rowData = {Boolean.FALSE,iD,name,description,price,quantity,total};
					dtm.addRow(rowData);
					
			
				}
					break;
				case "Equipment": {
					
					//find equipment in database, get data
					Equipment equip = new Equipment();
					equip = ife.findEquipment(iD, false);
					name = equip.getName();
					description = equip.getDescription() + ", " + equip.getType();
					price = equip.getPurchasePrice();
					total = price * quantity;
					
					//add to the table
					Object[] rowData = {Boolean.FALSE,iD,name,description,price,quantity,total};
					dtm.addRow(rowData);
					
				}
					break;
				// in case is forgotten to select type
				case "Choose Type": JOptionPane.showInternalMessageDialog(contentPane, "Choose Type of Product!");
				}
				addTotal();
				}
				catch(NullPointerException npe){//if product doesn't exist
					JOptionPane.showInternalMessageDialog(contentPane, "           Product doesn't exist! \nTry to choose another product type!");
				}
				catch(Exception e){//if nothing has been entered, or in bad formatting
					JOptionPane.showInternalMessageDialog(contentPane, "Enter valid information!");
				}
					
			}
		});
		contentPane.add(btnAdd, "12, 2, fill, top");
		
		//components
		lblCpr = new JLabel("CPR:");
		contentPane.add(lblCpr, "2, 4, right, center");
		
		textField_1 = new JTextField();
		textField_1.setText("000000-0001");
		contentPane.add(textField_1, "4, 4, left, top");
		textField_1.setColumns(10);
		
		lblDeliveryDate = new JLabel("Delivery Date:");
		contentPane.add(lblDeliveryDate, "2, 6, right, center");
		
		
		DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		frmtdtxtfldMmddyyyy = new JFormattedTextField(df);
		frmtdtxtfldMmddyyyy.setText("20/04/2013");
		contentPane.add(frmtdtxtfldMmddyyyy, "4, 6, fill, center");
		
		
		//button for saving order and closing the window
		btnSave = new JButton("Save");
		btnSave.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				if(items.size()>0){
					int option = JOptionPane.showConfirmDialog(contentPane, "Save order?", "Request", 2);//user chooses if want to proceed or check the data again
					if (option == 0){String cPR = textField_1.getText();//if yes data is saved in the database else nothing happens
					IFCustomer ifc = new DBCustomer();
					
						cust = ifc.findCustomer(cPR, false);
					if(cust!=null){ //if customer is created in the database
					String deliveryDate = frmtdtxtfldMmddyyyy.getText();
						ordCtr.startNewOrder(cust, deliveryDate , items);	//start new order			
						closeApplication(); // close the application, which automatically opens the order gui, see window closed event above
					}
					else JOptionPane.showMessageDialog(contentPane, "Customer doesn't exist!");
					}
				}
				else JOptionPane.showMessageDialog(contentPane, "Add Items!");
			}
		});
		contentPane.add(btnSave, "12, 6, fill, top");
		
		
		
		scrollPane = new JScrollPane();
		contentPane.add(scrollPane, "2, 8, 11, 1, fill, fill");
		
		table = new JTable();
		scrollPane.setViewportView(table);
		table.setModel(dtm);
		/*
		 * action performed, when any cell values has been changed
		 */
		Action action = new AbstractAction() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				System.out.println("");
				TableCellListener tcl = (TableCellListener)e.getSource();
		 
		        if(tcl.getColumn()==0){//only for the first column, makes sure that only one check box is selected in the whole table
		        	int row = tcl.getRow();
		        	int rowCount = table.getRowCount();
		        	if((boolean) table.getModel().getValueAt(row, 0)){
		        		for(int i = 0; i<rowCount; i++)table.getModel().setValueAt(false, i, 0);
		        		table.getModel().setValueAt(true, row, 0);
		        	}
		        }
				
			}
		};
		TableCellListener tcl = new TableCellListener(table, action);
		table.getColumnModel().getColumn(0).setPreferredWidth(30);
		table.getColumnModel().getColumn(3).setPreferredWidth(90);
		dtm.addTableModelListener(new TableModelListener() {
			
			@Override
			public void tableChanged(TableModelEvent arg0) {
				if(arg0.getType()==TableModelEvent.INSERT)btnRemove.setEnabled(true);
				if(table.getRowCount()==0)btnRemove.setEnabled(false);
				
			}
		});
		
		/**
		 * remove button
		 * user can remove products by selecting the checkbox on the left side of the table and clicking on the button
		 * 
		 */
		btnRemove = new JButton("Remove");
		btnRemove.setEnabled(false);
		btnRemove.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				boolean removed = false;
				int rowCount = table.getRowCount(); // number of rows in the table
				int option = JOptionPane.showConfirmDialog(contentPane, "Remove selected product?", "Request", 2);//request dialog 
				if (option == 0){ //if the choice is yes
					for(int i=0; i<rowCount; i++){ // for i.row to the last
						try{//system was throwing an exception, even though everything was executed correctly
							boolean selected = (boolean) table.getModel().getValueAt(i,0);// get boolean value for the i row in the 1.column of the table
						if(selected){
							removed = true;
							int id = (int) table.getModel().getValueAt(i, 1);//if true get id of the product
							Iterator<SaleLine> sl = items.iterator();//iterator for removing sale line from shopping cart
							while(sl.hasNext()){
								SaleLine s = sl.next();
								if(id == s.getProduct().getProductID())sl.remove();
							}
							((DefaultTableModel)table.getModel()).removeRow(i);//remove the row in the table
						}
						}
						catch(ArrayIndexOutOfBoundsException e){
							
						}
						
					}	
					if(!removed) JOptionPane.showMessageDialog(contentPane, "Select Product!");
					addTotal();// adds total to the label in the bottom part of the window, see the method
				}
			}});
		
		lblTotal = new JLabel("Total: ");
		contentPane.add(lblTotal, "10, 10, 3, 1");
		lblTotal.setHorizontalAlignment(JLabel.RIGHT);
		contentPane.add(btnRemove, "2, 12, left, top");
	}

	/*
	 * methods count total price 
	 * the total price is shown in the label in the bottom
	 */
	public void addTotal(){
		
		double total = 0;
		int rowCount = table.getRowCount();
		
		for(int i=0; i<rowCount; i++){ // for i.row to the last
			total = total + (double) table.getModel().getValueAt(i, 6);
		}
		lblTotal.setText("Total: "+ String.valueOf(total));
	}
	
	/*
	 * simple method for closing the application
	 */
	public void closeApplication(){
		dispose();
	}

}
