package ModelLayer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ArrayList; //Needed to make an orderList, which will contain SaleLine instances;


public class SalesOrder {
	//FIELDS
	private int orderID; //helps to find the order, after it is recorded, automatically generated;
	private String timeStamp; //exact date and time when the order is made;
	private double amount; //the total amount that customer has to pay;
	private boolean deliveryStatus; //when the order must be delivered;
	private String deliveryDate; //is it delivered - yes or no, true or false;
	
	private Customer customer; //determines whose the order is;
	private Invoice invoice; //invoice must be created after order is finished; 
	
	private ArrayList<SaleLine> lineList; //The lineList consists of several SaleLine instances;
	
	//CONSTRUCTORS
	//Creates an empty instance;
	public SalesOrder() {
	}
	
	//METHODS
	/** orderID */
	public int getOrderID() {
		return orderID;
	}

	public void setOrderID(int orderID) {
		this.orderID = orderID;
	}

	/** timeStamp */
	public String getTimeStamp() {
		return timeStamp;
	}

	public void setTimeStamp() {
		//timeStamp initialization;
		DateFormat dFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy"); //sets a date format;
		Date date = new Date(); //creates current date;
		timeStamp = dFormat.format(date); //format the date and assigns it to the timeStamp;
	}
	
	public void setTimeStamp(String timeStamp) {
		this.timeStamp = timeStamp;
	}

	/** amount */
	public double getAmount() {
		return amount;
	}

	public void setAmount(double amount) {
		this.amount = amount;
	}

	/** deliveryStatus */
	public boolean getDeliveryStatus() {
		return deliveryStatus;
	}

	public void setDeliveryStatus(boolean deliveryStatus) {
		this.deliveryStatus = deliveryStatus;
	}
	
	/** deliveryDate */
	public String getDeliveryDate() {
		return deliveryDate;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	/** customer */
	//gets the Customer instance;
	public Customer getCustomer() {
		return customer;
	}
	
	//sets a reference to a Customer instance;
	public void setCustomer(Customer customer) {
		this.customer = customer;
	}

	public Invoice getInvoice() {
		return invoice;
	}

	public void setInvoice(Invoice invoice) {
		this.invoice = invoice;
	}

	/** orderList */
	//initialization of the orderList;
	public void createOrderList() {
		lineList = new ArrayList<SaleLine>();
	}
	
	//adds a SaleLine to the orderList;	
	public void addSaleLine(SaleLine sLine) {
		lineList.add(sLine);
	}
	
	//finds the position of SaleLine in the Array by Product;
	public int findSaleLine(Product product) {
		 boolean isSearching = true; //true - yes, false - no;
	     
		 int loopNum = 0;
	     while(loopNum < lineList.size() && isSearching) {
	    	 Product currentProduct = lineList.get(loopNum).getProduct();
	    	 
	         if(product == currentProduct) {
	        	//we have match, the product that we are looking for is found, therefore, searching is ended;
	            isSearching = false;
	         }
	         loopNum++;
	     }
	        return loopNum; //returns the position of found product;
	}
	
	//fetches a SaleLine found by ProductID;
	public SaleLine getSaleLine(Product product) {
		return lineList.get(findSaleLine(product));
	}
	
	//finds a SaleLine by a productID and updates the quantity;
	public void updateSaleLine(Product product, int quantity) {
		lineList.get(findSaleLine(product)).setQuantity(quantity);
	}

    //finds a SaleLine by a productID and deletes it;
	public void removeSaleLine(Product product) {
			lineList.remove(findSaleLine(product));
	}

	//returns the whole orderList;
	public ArrayList<SaleLine> getOrderList() {
		return lineList;
	}

	//sets what is the orderList;
	public void setLineList(ArrayList<SaleLine> lineList) {
		this.lineList = lineList;
	}

	/** toString all variables */
	@Override
	public String toString() {
		return "SalesOrder [orderID=" + orderID + ", timeStamp=" + timeStamp + ", amount=" + amount
				+ ", deliveryStatus=" + deliveryStatus + ", deliveryDate=" + deliveryDate + "]";
	}
}