package ModelLayer;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProductTest {
	
	private Product product;
	// other objects needed
	private Location location;
	private Supplier supplier;

	// is run before whole test Class eg. ProductTest.java
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	// is run after whole test Class eg. ProductTest.java
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	// is run before each @Test method eg. testGetName()
	@Before
	public void setUp() throws Exception {
		// product = new Product("product name", 1, 1, "far away", 1, null);
		product = new Product();
		supplier = new Supplier();
		location = new Location();
		
		supplier.setLocation(location);
		product.setSupplier(supplier);
	}

	// is run after each @Test method eg. testGetName()
	@After
	public void tearDown() throws Exception {
	}

	// test empty constructor, is it needed ?!
	@Test
	public void testProduct() {
		// fail("Not yet implemented");
	}
	
	// test constructor with fields, is it needed ?!
	// long list of types is list of tested class field types
	@Test
	public void testProductStringIntIntStringIntSupplier() {
		// fail("Not yet implemented");
	}

	// TODO delete getMethonds() are tested together with setMethods()
	@Test
	public void testGetName() {
		// fail("Not yet implemented");
	}

	// by testing testSetName() we are testing also testGetName()
	@Test
	public void testSetName() {
		product.setName("new name");
		assertEquals("new name", product.getName());
	}

	@Test
	public void testSetProductID() {
		product.setProductID(2);
		assertEquals(2, product.getProductID());
	}

	@Test
	public void testSetPurchasePrice() {
		product.setPurchasePrice(20);
		assertEquals(20, product.getPurchasePrice());
	}

	@Test
	public void testSetRentPrice() {
		product.setRentPrice(2);
		assertEquals(2, product.getRentPrice());
	}

	@Test
	public void testSetCountryOfOrigin() {
		product.setCountryOfOrigin("home");
		assertEquals("home", product.getCountryOfOrigin());
	}

	@Test
	public void testSetMinStock() {
		product.setMinStock(100);
		assertEquals(100, product.getMinStock());
	}

	@Test
	public void testSetSupplier() {
		// setting the new one for the sake of testing
		Supplier supplier = new Supplier();
		product.setSupplier(supplier);
		assertEquals(supplier, product.getSupplier());
	}

	@Test
	public void testToString() {
		// dummy objects, could be moved @Before - moved
		// Supplier supplier = new Supplier();
		// Location location = new Location();
		// Product product = new Product();
		// could be moved @Before - moved
		// supplier.setLocation(location);
		// product.setSupplier(supplier);
		// what we get
		// System.out.println(location.toString());
		// System.out.println(supplier.toString());
		// System.out.println(product.toString());
		
		// not working
		// String expected = "Product [name=product name, productID=0, purchasePrice=1, rentPrice=1," +
		//		" countryOfOrigin=far away, minStock=1, supplier=]";
		// failing
		// assertEquals(expected, product.toString());
		
		// if we use previous dummy object with null values
		String expectNullValues = "Product [name=null, productID=0, purchasePrice=0, rentPrice=0," +
				" countryOfOrigin=null, minStock=0, supplier=Supplier [name=null, address=null," +
				" location=Location [zipCode=0, city=null, country=null], email=null, phoneNr=null]]";
		// success if we use 'expectNullValues' with dummy objects
		assertEquals(expectNullValues, product.toString());
	}

}
